<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
    <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.servers"></cv:cvMessages>
    <cv:cvMessages bundle="localization.usersJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.settings"></cv:cvMessages>
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
    <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.job"></cv:cvMessages>
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.fs"></cv:cvMessages>
</script>
<div class="row">
        <div class="col-xs-12">
            <h1 class="float-left" ng-bind="ctrl.backupsetDetails.backupSetEntity.backupsetName"></h1>
 			<span ng-if="!ctrl.hdfs"><a href="javascript:void(0)" ng-click="ctrl.deleteBackupset()" class="page-action-item" ><cv:msg key="action.delete" bundle="bigData" /></a></span>
           <span><a href="javascript:void(0)" ng-click="ctrl.backupsetRestoreHistory()" class="page-action-item" ><cv:msg key="action.commonAction.restoreHistory" bundle="settings" /></a></span>
			<span ng-if="ctrl.backsetBackupHistory"><a href="javascript:void(0)" ng-click="ctrl.backupHistory()" class="page-action-item" ><cv:msg key="action.commonAction.backupHistory" bundle="settings" /></a></span>
		</div>
    </div>

    <div class="row">
        <div class="col-xs-12 col-sm-6">
            <cv-tile-component ac-id="bigDataBackupsetGeneralInfo" loader="ctrl.appInfoLoaded" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />'>
                <div>
                    <ul class="list-style-secondary">
                        <cv-tile-label-value ng-repeat="info in ctrl.generalInfoList" label="{{info.label}}" value="{{info.value}}"></cv-tile-label-value>
                        
                        <li class="group" id="stagingLocation" ng-if="!ctrl.editStLocation && ctrl.hbase">
                        	<span class="pageDetail-three-columns-first">
				               <cv:msg key="label.stagingLocation" bundle="bigData" />
				            </span>
	                        <span class="pageDetail-three-columns-second">
                                  <span data-ng-bind="ctrl.stagingLocation"> </span>
                            </span>
                            <a class="pageDetail-three-columns-third" href=""  data-ng-click="ctrl.editStagingLocation()"><cv:msg key="action.edit" bundle="profiles"/></a> 
                        </li>
                        <li class="group" id="editStagingLocation" ng-if="ctrl.editStLocation && ctrl.hbase">
                        	<span class="pageDetail-three-columns-first">
				               <cv:msg key="label.stagingLocation" bundle="bigData" />
				            </span>
	                        <span class="pageDetail-three-columns-second">
                                <input class="margin-0 padding-0" type="text" data-ng-model = "ctrl.stagingLocation" data-ng-change="ctrl.stagingLocationError = false"></input>
                                <span class="help-block margin-left-0 margin-top-5" data-ng-if="ctrl.stagingLocationError"><cv:msg key="error.hadoop.stagingLocation" bundle="bigData" /></span>
                            </span>
                            <span class="pageDetail-three-columns-third">
                                <a class="horizontal-link-button" data-ng-click="ctrl.fSaveStagingLocation()"><i class="glyphicon glyphicon-ok"></i></a>
                                <a data-ng-click="ctrl.fDonotSaveStagingLocation()"><i class="glyphicon glyphicon-remove"></i></a>
	                      </span>
                        </li>
                        <li class="group" id="hbaseUser" ng-if="!ctrl.editHBaseUser && ctrl.hbase">
                        	<span class="pageDetail-three-columns-first">
				               <cv:msg key="label.hbaseuser" bundle="bigData" />
				            </span>
	                        <span class="pageDetail-three-columns-second">
                                  <span data-ng-bind="ctrl.hbaseuser"> </span>
                            </span>
                            <a class="pageDetail-three-columns-third" href=""  data-ng-click="ctrl.editHbaseUser()"><cv:msg key="action.edit" bundle="profiles"/></a> 
                        </li>
                        <li class="group" id="editHBaseUser" ng-if="ctrl.editHBaseUser && ctrl.hbase">
                        	<span class="pageDetail-three-columns-first">
				               <cv:msg key="label.hbaseuser" bundle="bigData" />
				            </span>
	                        <span class="pageDetail-three-columns-second">
                                <input class="margin-0 padding-0" type="text" data-ng-model = "ctrl.hbaseuser" data-ng-change="ctrl.HBaseUserError = false"></input>
                            </span>
                            <span class="pageDetail-three-columns-third">
                                <a class="horizontal-link-button" data-ng-click="ctrl.fSaveHBaseUser()"><i class="glyphicon glyphicon-ok"></i></a>
                                <a data-ng-click="ctrl.fDonotSaveHBaseUser()"><i class="glyphicon glyphicon-remove"></i></a>
	                      </span>
                        </li>
                        <li class="group" id="hdfsUser" ng-if="!ctrl.editHDFSUser && ctrl.hdfs">
                        	<span class="pageDetail-three-columns-first">
				               <cv:msg key="label.hdfsUser" bundle="bigData" />
				            </span>
	                        <span class="pageDetail-three-columns-second">
                                  <span data-ng-bind="ctrl.hdfsUser"> </span>
                            </span>
                            <a class="pageDetail-three-columns-third" href=""  data-ng-click="ctrl.editHdfsUser()"><cv:msg key="action.edit" bundle="profiles"/></a> 
                        </li>
                        <li class="group" id="editHdfsUser" ng-if="ctrl.editHDFSUser && ctrl.hdfs">
                        	<span class="pageDetail-three-columns-first">
				               <cv:msg key="label.hdfsUser" bundle="bigData" />
				            </span>
	                        <span class="pageDetail-three-columns-second">
                                <input class="margin-0 padding-0" type="text" data-ng-model = "ctrl.hdfsUser"></input>
                             </span>
                            <span class="pageDetail-three-columns-third">
                                <a class="horizontal-link-button" data-ng-click="ctrl.fSaveHdfsUser()"><i class="glyphicon glyphicon-ok"></i></a>
                                <a data-ng-click="ctrl.fDonotSaveHdfsUser()"><i class="glyphicon glyphicon-remove"></i></a>
	                      </span>
                        </li>
                          
                        <li class="group">
                        	<span class="pageDetailColumn">
				               <cv:msg key="label.savingsPercentage" bundle="job" />
				            </span>
	                        <span class="pageDetailColumn">
	                      		<span data-ng-bind="ctrl.backupsetDetails.dedupeRatio"> </span>
	                      		<cv-call-out html-template="ctrl.savingsPercentageCallOutTemplate"></cv-call-out>
	                      </span>
                  		</li>
                    </ul>
                </div>
<%--                 <div class="page-details-box-links">
                    <a href="javascript:void(0);"><cv:msg key="label.edit" bundle="clients"/></a>
                </div> --%>
            </cv-tile-component>
        </div>
        <div class="col-xs-12 col-sm-6">
            <cv-security-component entity-type="ctrl.entityType" generic-entity="ctrl.backupsetDetails.backupSetEntity" associations="ctrl.secParams.formattedSecurityAssociations" associations-loaded="ctrl.secParams.associationsLoaded" show-owners="true"></cv-security-component>
			<cv-plan-component data-ng-if="ctrl.plansLoaded" app-id="ctrl.applicationId" backup-set-id="ctrl.entityId" client-id="ctrl.clientId" plan-entity="ctrl.backupsetDetails.planEntity" show-loader="!ctrl.plansLoaded" highlight-error="false"></cv-plan-component>
    </div>
<!--<cv-grid cv-grid-options="ctrl.cvGridOptions"></cv-grid>-->
	 <div data-ng-show="ctrl.subclientListLoaded" id="subclientsTable" class="col-xs-12">
	 	<div ng-if="ctrl.hbase">
			<h1 class="float-left"><cv:msg key="header.subclients" bundle="bigData" /></h1>
		</div>
		<cv-kendo-grid class="case-inline-grid" cv-grid-options="ctrl.gridOptions" ng-if="ctrl.gridOptions">
		</cv-kendo-grid>
	</div>
</div>