<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
    <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.backupOptions" bundle="servers"/></h1>
</div>
<div class="setup-content backup-options">
	<span class="{{serverMessage.type}} serverMessage">{{serverMessage.message}}</span>
	<div class="bootstrap-wrapper">
        <span data-ng-show="!backupMsg" >
            <label data-ng-if="subclientName"><cv:msg key="info.backupSubclient" bundle="servers"/> : &nbsp;<b>{{subclientName}}</b></label>
            <div data-ng-show="!(isOneTouchSubclient && isIbmiClient)">
                <div class="global-options remove-border-padding">
                    <label><cv:msg key="label.backupLevel" bundle="servers"/></label>
                </div>
        
                <div class="global-options remove-border-padding form-panel-holder">
                    <label class="element-indent-class" data-ng-hide="hideFullBackupLevel">
                        <input type="radio" ng-model="backupType" value="FULL">
                        <cv:msg key="option.full" bundle="schedule"/>
                    </label>
        
                    <label class="element-indent-class" data-ng-show="isIncrementalSupported">
                        <input type="radio" ng-model="backupType" value="INCREMENTAL">
                        <cv:msg key="option.incremental" bundle="schedule"/>
                    </label>

                     <label class="element-indent-class" data-ng-show="isSyntheticFullSupportedForBigDataApp">
	                    <input type="radio" ng-model="backupType" value="SYNTHETIC_FULL">
	                    <cv:msg key="option.synthfull" bundle="schedule"/>
                	</label>
                </div>
            </div>
            <div data-ng-if="enableCommitLog" class="row margin-left-50">
                <cv-checkbox class="col-xs-3" checkbox-label="IncrementalLog" checkbox-name="logCheckbox" checkbox-id="logCheckbox" checkbox-model="distAppsBackupOptions.runLogBkp" value="true"></cv-checkbox>
                <cv-checkbox class="col-xs-3" checkbox-label="label.data" checkbox-name="dataCheckbox" checkbox-id="dataCheckbox" checkbox-model="distAppsBackupOptions.runDataBkp" value="true"></cv-checkbox>
            </div>
        </span>
        <div class="global-options remove-border-padding padding-top-10">
            <cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>">
            </cv-alert-me>
        </div>
    </div>

	<div class="button-container">
		<button id="bigDataBackupOptions_button_#1834" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-show="backupMsg" data-ng-click="cancel()"><cv:msg key="OK" bundle="messages"/></button> 
		<button id="bigDataBackupOptions_button_#7599" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-show="!backupMsg" data-ng-click="cancel()"><cv:msg key="Cancel" bundle="messages"/></button> 
		<button id="bigDataBackupOptions_button_#7611" type="button" class="btn btn-primary cvBusyOnAjax"  data-ng-class="{'busy':loading}" data-ng-show="!backupMsg" data-ng-click="startBackup()"><cv:msg key="OK" bundle="messages"/></button> 
	</div>
</div>