<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="row cv-needs-breadcrumb">
    <!-- TODO: [app-designer] add breadcrumb, we've managed to makes something simple really complicated... -->
    <div class="col-sm-6">
        <cv-tile-component title="{{vm.table.name}}" class="cv-app-designer-details">
            <div class="page-details-box-links">
                <a href="javascript:void(0);" ng-click="vm.handleTableEdit()">Edit</a>
            </div>
                <div class="cv-app-description" style="margin-bottom: 10px">
                    <dt>Description</dt>
                    <dd>{{vm.table.description}}</dd>
                </div>
            <dl>
                <div class="cv-app-created">
                    <dt>Creation Date</dt>
                    <dd>{{vm.table.created.at | date:'medium'}}</dd>
                    <dt>Created By</dt>
                    <dd>{{vm.table.created.name}}</dd>
                </div>
                <div class="cv-app-modfied">
                    <dt>Last Update</dt>
                    <dd>{{vm.table.modified.at | date:'medium'}}</dd>
                    <dt>Updated By</dt>
                    <dd>{{vm.table.modified.name}}</dd>
                </div>
                
                <div class="cv-app-total-records">
                    <dt>Total Records</dt>
                    <dd>{{vm.table.totalRecords}}</dd>
                    <dt></dt>
                    <dd><button id="tableConfig_button_#4213" ng-click="vm.openTableImport()">Import</button> </dd>
                </div>
            </dl>
        </cv-tile-component>
    </div>
    <div class="col-sm-6">
        <cv-security-component
                check-owner="true"
                entity-type='vm.entityType'
                generic-entity='vm.genericEntity'
                show-edit="vm.showEdit"
                has-permissions="true"
                edit-callback="vm.editSecurity"
                hide-inherited-associations="vm.hideInheritedAssociations"
                associations='vm.formattedSecurityAssociations'
                associations-loaded="vm.associationsLoaded"
                is-admin-console="true"
        >
        </cv-security-component>
    </div>
</div>
<uib-tabset class="margin-top-15" active="vm.tabActive">
    <uib-tab heading="Fields" select="vm.selectTab(0)" index=0>
        <div class="row">
            <div class="page-details-list col-md-12 appDesignerTable">
                <cv-grid cv-grid-options="vm.gridOptionsFields"></cv-grid>
            </div>
        </div>
    </uib-tab>
    <uib-tab heading='Business Rules' select="vm.selectTab(1)" index=1>
        <div class="row">
            <div class="page-details-list col-md-12 appDesignerTable">
                <cv-grid cv-grid-options="vm.gridOptionsBusinessRules"></cv-grid>
            </div>
        </div>
    </uib-tab>
    <uib-tab heading='Forms' select="vm.selectTab(2)" index=2>
        <div class="row">
            <div class="page-details-list col-md-12 appDesignerTable">
                <cv-grid cv-grid-options="vm.gridOptionsTableForms"></cv-grid>
            </div>
        </div>
    </uib-tab>
    <uib-tab heading='Views' select="vm.selectTab(3)" index=3>
        <div class="row">
            <div class="page-details-list col-md-12 appDesignerTable">
                <cv-grid cv-grid-options="vm.gridOptionsTableViews"></cv-grid>
            </div>
        </div>
    </uib-tab>
        <uib-tab heading='UI Actions' select="vm.selectTab(4)" index=4>
        <div class="row">
            <div class="page-details-list col-md-12 appDesignerTable">
                <cv-grid cv-grid-options="vm.gridOptionsTableActions"></cv-grid>
            </div>
        </div>
    </uib-tab>
</uib-tabset>
