<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="save-page-modal">
    <div class="setup-title">
        <h1>Create Page</h1>
    </div>
    <div class="setup-content">
        <!-- <div class="addPageMessage serverMessage">{{addAppMessage.message}}</div> -->
        <form name="addPageForm" cv-submit="vm.savePage()" autocomplete="off" id="addPageForm">
            <!-- // page name // -->
            <div class="cv-modal-wrapper">
                <label for="pageName" class="cv-label">Name</label>
                <div class="cv-inline-wrapper">
                    <input type="text" name="pageName" ng-model="vm.page.name" id="pageName" required autofocus/>
                </div>
            </div>
            <div class="cv-modal-wrapper">
                <label class="cv-label">Page type</label>
                <div class="cv-inline-wrapper">
                    <isteven-multi-select id="pageEditModal_isteven-multi-select_#5655" 
                            input-model="vm.pageTypes"
                            output-model="vm.selectedType"
                            button-label="name"
                            item-label="name"
                            tick-property="selected"
                            class="isteven-multi-select user-group-select"
                            helper-elements="filter"
                            selection-mode="single"
                            on-close="vm.onPageTypeChange()"
                    >
                    </isteven-multi-select>
                </div>
            </div>
            <%-- view for the table--%>
            <div class="cv-modal-wrapper" ng-if="vm.appPageType && ((vm.assocType && vm.assocItem.length) || (!vm.assocType))">
                <label class="cv-label">{{vm.appPageType.name}}</label>
                <div class="cv-inline-wrapper">
                    <isteven-multi-select id="pageEditModal_isteven-multi-select_#6227" 
                            input-model="vm.list"
                            output-model="vm.selectedItem"
                            button-label="name"
                            item-label="name"
                            tick-property="selected"
                            class="isteven-multi-select user-group-select"
                            helper-elements="filter"
                            selection-mode="single"
                            on-close="vm.onItemChange()"
                    >
                    </isteven-multi-select>
                </div>
            </div>
            <div class="cv-modal-wrapper" ng-if="vm.appPageType && vm.appPageType.id === 'table' && vm.selectedItem">
                <label class="cv-label">View</label>
                <div class="cv-inline-wrapper">
                    <isteven-multi-select id="pageEditModal_isteven-multi-select_#5737" 
                            input-model="vm.viewList"
                            output-model="vm.selectedView"
                            button-label="name"
                            item-label="name"
                            tick-property="selected"
                            class="isteven-multi-select user-group-select"
                            helper-elements="filter"
                            selection-mode="single"
                    >
                    </isteven-multi-select>
                </div>
            </div>
            <!-- // page description // -->
            <div class="cv-modal-wrapper">
                <label for="pageDesc" class="cv-label">Description</label>
                <div class="cv-inline-wrapper">
                    <textarea name="pageDesc" id="pageDesc" ng-model="vm.page.description"></textarea>
                </div>
            </div>
        
            <div class="button-container">
                <button id="pageEditModal_button_#8254" type="button" class="btn btn-default cvBusyOnAjax" ng-click="vm.cancel()">Cancel</button> 
                <button id="pageEditModal_button_#6830" type="submit" class="btn btn-primary cvBusyOnAjax">Create Page</button> 
            </div>
        </form>
    </div>
</div>