import { appDesignerModule } from 'common/js/modules';

import '../../services/reports.svc';
import { pathAccess } from '../../util';

function TableFieldChoice(reportService, customReportSvc, ReportsService) {
	return {
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'appDesigner/js/table-fields/choice/choices.html',
		scope: {
			column: '=',
			classes: '='
		},
		link: function($scope, element, attrs) {
			$scope.fields = [];
			$scope.dsList = [];
			$scope.sortOptions = ['label', 'value', 'None'];
			$scope.sortDirs = ['Asc', 'Desc'];

			$scope.column.fieldOptions.choices = Object.assign({}, { type: 'user' }, $scope.column.fieldOptions.choices);

			// $scope.getFieldsFromDataSet = function(datasetEntity) {
			//     if (!datasetEntity) return;
			//     const datasetId = datasetEntity.dataSetId;
			//     const type = pathAccess(['type'], $scope.column);
			//
			//     return ReportsService.getFieldsFromDataSet(datasetId).then((data) => {
			//         $scope.fields = [];
			//
			//         const filter = type === 'number'
			//             ? (column) => column.type === 'Integer'
			//             : null;
			//
			//         const filteredFields = filter ? data.data.columns.filter(filter) : data.data.columns;
			//
			//         $scope.fields = [""].concat(filteredFields.map(column => column.name));
			//         return $scope.fields;
			//     }, (err) => {
			//         $scope.fields = [];
			//     })
			// }

			$scope.onDataSetChange = function(dataSetEntity) {
				$scope.dsList.forEach(dataSet => {
					if (dataSet.dataSet.dataSetName === dataSetEntity.dataSetName) {
						$scope.column.fieldOptions.choices.dataSetEntity = dataSet.dataSet;
						$scope.fields = [''].concat(dataSet.fields.map(field => field.name));
						return;
					}
				});
			};

			const appendGuidToDataSet = dataset => {
				const dataSetWithGuid = Object.assign({}, dataset.dataSet, { dataSetGuid: dataset.guid });
				return Object.assign({}, dataset, { dataSet: dataSetWithGuid });
			};

			const setDatasetsAndFieldsLists = (datasets, dataSetEntity) => {
				$scope.dsList = datasets || [];

				datasets.forEach(dataSet => {
					if (dataSet.dataSet.dataSetName === dataSetEntity.dataSetName) {
						$scope.column.fieldOptions.choices.dataSetEntity = dataSet.dataSet;
						$scope.fields = [''].concat(dataSet.fields.map(field => field.name));
						return;
					}
				});
			};

			function getDataSetsAndFields() {
				const dataSetEntity = pathAccess(['fieldOptions', 'choices', 'dataSetEntity'], $scope.column);

				return reportService
					.getAllDataSets(true)
					.then(data => data.data.dataSet)
					.then(datasets => datasets.map(appendGuidToDataSet))
					.then(datasets => setDatasetsAndFieldsLists(datasets, dataSetEntity));
			}

			getDataSetsAndFields();
		}
	};
}

TableFieldChoice.$inject = ['reportService', 'customReportSvc', 'ReportsService', '$log', '$q'];

appDesignerModule.directive('tableFieldChoices', TableFieldChoice);
