import { appDesignerModule } from 'common/js/modules';
// dependencies injected by Angular
import '../services/reports.svc';
import '../services/tables.svc';

import ReportType from '../page-types/report';
import TableType from '../page-types/table';

function PageTypeService(ReportsService, TablesService) {
	const types = {
		report: new ReportType(ReportsService),
		table: new TableType(TablesService)
	};

	function getPageType(type) {
		return types[type];
	}

	return {
		getPageType
	};
}

PageTypeService.$inject = ['ReportsService', 'TablesService'];

appDesignerModule.factory('PageTypeService', PageTypeService);

export default appDesignerModule;
