import { appDesignerModule } from 'common/js/modules';

// dependencies injected by Angular
import '../controllers/pageEditModal.ctrl';
import { getErrMessage } from '../util';

function PageEditModalService(cvLoc, $modal, cvToaster) {
	this.openModal = function openModal(page) {
		let modalInstance = $modal.open({
			templateUrl: appUtil.appRoot + 'appDesigner/partials/pageEditModal.jsp',
			backdrop: 'static',
			controllerAs: 'vm',
			controller: 'PageEditModalCtrl',
			resolve: {
				page: function() {
					return page;
				}
			}
		});
		modalInstance.result.then(onSave, onCancel);

		function onSave(page) {
			cvToaster.showSuccessMessage({
				message: cvLoc('appdesigner.msg.saveSuccessful', '<b>' + page.name + '</b>')
			});
		}

		function onCancel(err) {
			if (err === 'close') return;
			if (err === 'escape key press') return;
			if (err) {
				const message = getErrMessage(err);
				cvToaster.showErrorMessage({
					message
				});
			}
		}

		return modalInstance.result;
	};
}

PageEditModalService.$inject = ['cvLoc', '$uibModal', 'cvToaster'];

appDesignerModule.service('PageEditModalService', PageEditModalService);

export default appDesignerModule;
