import { appDesignerModule } from 'common/js/modules';

import '../controllers/columnEditModal.ctrl';
import { getErrMessage } from '../util';

function ColumnEditModalService(cvLoc, $modal, cvToaster) {
	this.openModal = function openModal(column) {
		var modalInstance = $modal.open({
			templateUrl: appUtil.appRoot + 'appDesigner/partials/columnEditModal.jsp',
			backdrop: 'static',
			controllerAs: 'vm',
			controller: 'ColumnEditModalCtrl',
			resolve: {
				column: function() {
					return column;
				}
			}
		});
		modalInstance.result.then(onSave, onCancel);

		function onSave(column) {
			cvToaster.showSuccessMessage({
				message: cvLoc('appdesigner.msg.saveSuccessful', '<b>' + column.name + '</b>')
			});
		}

		function onCancel(err) {
			if (err === 'close') return;
			if (err === 'escape key press') return;
			if (err) {
				const message = getErrMessage(err);
				cvToaster.showErrorMessage({
					message
				});
			}
		}

		return modalInstance.result;
	};
}

ColumnEditModalService.$inject = ['cvLoc', '$uibModal', 'cvToaster'];

appDesignerModule.service('ColumnEditModalService', ColumnEditModalService);

export default appDesignerModule;
