import { appDesignerModule } from 'common/js/modules';
// temporary localization App Designer strings
import '../../js/temp.localization';
import '../table-fields/tableField.directive';
import '../services/views.svc';
import '../services/tables.svc';
import '../services/appForms.svc';
import '../services/actions.svc';
import '../services/cloneHelperService.svc';

import { getErrMessage } from '../util';

// dependencies injected/need by Angular

function ViewsConfigCtrl(
	$stateParams,
	$log,
	cvLoc,
	$dialogs,
	cvToaster,
	$state,
	ViewsService,
	AppFormsService,
	CloneHelperService,
	ActionsService
) {
	let { tableId, viewId, businessRule } = $stateParams;
	let vm = this;
	vm.tab = 'views';
	vm.tableId = tableId;

	let cloneId = CloneHelperService.getItemClone();

	vm.classes = {
		labelClass: 'col-xs-12 col-lg-3',
		formGroupClass: 'form-group',
		inputContainerClass: 'col-xs-12 col-lg-6'
	};

	RuleBuilder.setFetcher(() =>
		Promise.all([
			ViewsService.getViewById(tableId, cloneId || viewId),
			AppFormsService.getAppForms(tableId),
			ActionsService.getActions(tableId, true),
			ViewsService.getUserGroups()
		]).then(res => {
			if (res[0].name && cloneId) {
				delete res[0].name;
			}

			CloneHelperService.setItemClone(null);

			vm.view = res[0];
			vm.forms = res[1];

			return { view: res[0], forms: res[1], uiActions: res[2], userGroups: res[3] };
		})
	);
	RuleBuilder.openViewConfigurationPage();

	vm.loading = true;
	vm.businessRule = null;

	vm.handleEditView = function handleViewsEdit() {
		const { id, name, ...viewData } = RuleBuilder.getData();
		viewData.title = name;
		viewData.view.description = viewData.description;

		const View = ViewsService.getViewFromData(tableId, viewId, viewData);
		viewData.view.addForm = viewData.view.addForm === 'none' ? null : viewData.view.addForm;
		viewData.view.editForm = viewData.view.editForm === 'none' ? null : viewData.view.editForm;
		viewData.view.uiActionsOrder = viewData.uiTableActionsOrder.concat(viewData.uiRowActionsOrder);
		// viewData.view.columns = appendColumnSchemaToColumnsIds(viewData.view.columns)

		// validation
		if (!viewData.title) return;

		View.save().then(onRequestSuccess, onRequestFailure);

		function onRequestSuccess() {
			$state.go('tableConfig', { tableId, tab: vm.tab });
			cvToaster.showSuccessMessage({
				message: cvLoc('appdesigner.msg.saveSuccessful', '<b>' + viewData.title + '</b>')
			});
		}
	};

	vm.handleDeleteView = function handleDeleteViews() {
		const view = RuleBuilder.getData();
		const viewName = view.name;

		$dialogs.confirm(
			cvLoc('appdesigner.label.confirmDelete'),
			cvLoc('appdesigner.msg.confirmDelete', `this view <b>${viewName}</b>`),
			{
				noFunction: function() {},
				yesFunction: function() {
					vm.view.remove().then(onDeleteSuccess, onRequestFailure);
				}
			}
		);

		function onDeleteSuccess() {
			cvToaster.showSuccessMessage({
				message: cvLoc('appdesigner.msg.saveSuccessful', '<b>' + viewName + '</b>')
			});
			$state.go('tableConfig', { tableId, tab: vm.tab });
		}
	};

	function appendColumnSchemaToColumnsIds(columnIds) {
		return columnIds.map(id => ({
			dataField: id,
			id,
			visible: true
		}));
	}

	function onRequestFailure(err) {
		if (err) {
			const message = getErrMessage(err);
			cvToaster.showErrorMessage({
				message
			});
		}
		$log.error(err);
	}
}

ViewsConfigCtrl.$inject = [
	'$stateParams',
	'$log',
	'cvLoc',
	'$dialogs',
	'cvToaster',
	'$state',
	'ViewsService',
	'AppFormsService',
	'CloneHelperService',
	'ActionsService'
];

appDesignerModule.controller('ViewsConfigCtrl', ViewsConfigCtrl);

export default appDesignerModule;
