import { appDesignerModule } from 'common/js/modules';

import { cloneObjectInstance, getErrMessage } from '../util';

// dependencies injected by Angular
import '../services/tables.svc';
import '../table-fields/tableField.directive';

function ColumnEditModalCtrl($state, $uibModalInstance, TablesService, column) {
	let vm = this;

	let columnId = column.id;
	// TODO: [app-designer] improve service to provide this
	let columnTypes = TablesService.getColumnTypes().map(colType => {
		return { id: colType, name: colType };
	});

	vm.classes = {
		labelClass: 'cv-label',
		inputContainerClass: 'cv-inline-wrapper',
		formGroupClass: 'cv-modal-wrapper'
	};

	vm.column = column;
	vm.columnTypes = columnTypes;
	vm.selectedColumnType = [];

	vm.fieldTypes = TablesService.getFieldTypes();

	if (!window.System.additionalSettings) window.System.additionalSettings = {};

	if (!window.System.additionalSettings.AdminConsole) window.System.additionalSettings.AdminConsole = {};

	if (window.System.additionalSettings.AdminConsole.showAllFields == undefined)
		window.System.additionalSettings.AdminConsole.showAllFields = false;

	if (!window.System.additionalSettings.AdminConsole.showAllFields) {
		const toFilter = { Reference: true, Lookup: true };

		vm.fieldTypes = vm.fieldTypes.filter(e => !toFilter[e.name]);
	}

	vm.selectedFieldType = vm.fieldTypes.find(type => type.name === column.fieldType) || null;

	columnTypes.forEach(columnType => {
		if (vm.column.type === columnType.id) {
			columnType.selected = true;
			vm.selectedColumnType = [columnType];
		}
	});

	vm.isNewColumn = function isNewPage() {
		return columnId === undefined;
	};

	vm.handleMultiselectClose = function handleMultiselectClose() {
		if (vm.selectedColumnType.length > 0) {
			vm.column.type = vm.selectedColumnType[0].id;
		}
	};

	/**
	 * When the cancel button is pressed.
	 */
	vm.cancel = function cancel() {
		$uibModalInstance.dismiss();
	};

	vm.saveAndEdit = function saveAndEdit() {
		vm.column.save().then(onRequestSuccess, onRequestFailure);

		function onRequestSuccess(res) {
			$state.go('columnConfig', { tableId: vm.column.tableId, columnId: vm.column.id });
		}

		function onRequestFailure(err) {
			$uibModalInstance.dismiss(err);
		}
	};

	vm.saveColumn = function saveColumn() {
		return vm.column.save().then(onRequestSuccess, onRequestFailure);

		function onRequestSuccess(res) {
			$uibModalInstance.close(res);
			return res;
		}

		function onRequestFailure(err) {
			$uibModalInstance.dismiss(err);
		}
	};

	vm.onChangeName = function(event) {
		if (event.charCode === 32) {
			event.preventDefault();
			event.stopPropagation();
		}
	};
}

ColumnEditModalCtrl.$inject = ['$state', '$uibModalInstance', 'TablesService', 'column'];

appDesignerModule.controller('ColumnEditModalCtrl', ColumnEditModalCtrl);

export default appDesignerModule;
