import { appDesignerModule, cvCommon } from 'common/js/modules';

// dependencies
import '../services/apps.svc';
import '../services/pageType.svc';
import { getErrMessage } from '../util';

function BusinessRuleModalCtrl($state, $uibModalInstance, AppsService, page) {
	let vm = this;

	let pageId = page.sys_id || null;
	let pageTypes = AppsService.getPageTypes();

	vm.page = page;

	vm.pageTypes = pageTypes;
	vm.selectedType = [];

	vm.list;
	vm.selectedItem;

	pageTypes.forEach(function(pageType) {
		if (vm.page.type === pageType.id) {
			pageType.selected = true;
			vm.selectedType = [pageType];
		}
	});

	vm.handleMultiselectClose = function handleMultiselectClose() {
		if (vm.selectedType.length > 0) {
			vm.page.type = vm.selectedType[0].id;
		}
	};

	/**
	 * When the cancel button is pressed.
	 */
	vm.cancel = function cancel() {
		$uibModalInstance.dismiss();
	};

	vm.savePage = function savePage() {
		vm.page.itemId = vm.selectedItem[0] && vm.selectedItem[0].id;
		page.save().then(onRequestSuccess, onRequestFailure);

		function onRequestSuccess(res) {
			let params = { appId: page.appId, pageId: res.id };
			$state.go('appPageConfig', params, { location: true, inherit: false });
		}

		function onRequestFailure(err) {
			$uibModalInstance.dismiss(err);
		}
	};
}

BusinessRuleModalCtrl.$inject = ['$state', '$uibModalInstance', 'AppsService', 'page', 'PageTypeService'];

appDesignerModule.controller('BusinessRuleModalCtrl', BusinessRuleModalCtrl);

export default appDesignerModule;
