import { appDesignerModule } from 'common/js/modules';

// temporary localization App Designer strings
import './../temp.localization';

// dependencies injected by Angular
import '../services/apps.svc';
import { getErrMessage } from '../util';

function AppViewerCtrl($stateParams, AppsService, $url) {
	let vm = this;
	let appId = $stateParams.appId;

	vm.loading = true;
	vm.app = {};
	vm.menu = [];

	fetchApp();

	function fetchApp() {
		let req = AppsService.getAppById(appId);
		req.then(onGetAppSuccess, onGetAppFailure);

		function onGetAppSuccess(app) {
			vm.loading = false;
			vm.app = app;
			fetchMenu();
		}

		function onGetAppFailure(err) {
			if (err) {
				const message = getErrMessage(err);
				cvToaster.showErrorMessage({
					message
				});
			}
		}

		return req;
	}

	function fetchMenu() {
		let req = vm.app.getMenu();

		req.then(onRequestSuccess, onRequestFailure);

		function onRequestSuccess(res) {
			vm.menu = res.menu;
		}

		function onRequestFailure(err) {
			const message = getErrMessage(err);
			cvToaster.showErrorMessage({
				message
			});
		}

		return req;
	}

	function onGetAppSuccess(app) {
		vm.loading = false;
		vm.app = app;
	}

	function onGetAppFailure(err) {
		if (err) {
			const message = getErrMessage(err);
			cvToaster.showErrorMessage({
				message
			});
		}
	}
}

AppViewerCtrl.$inject = ['$stateParams', 'AppsService'];

appDesignerModule.controller('AppViewerCtrl', AppViewerCtrl);

export default appDesignerModule;
