import { appDesignerModule } from 'common/js/modules';
import '../services/appForms.svc';
import '../services/cloneHelperService.svc';
import './../temp.localization';
import { getErrMessage } from '../util';

function AppStudioFormCustomizeCtrl(
	$stateParams,
	$log,
	cvLoc,
	$dialogs,
	cvToaster,
	$state,
	AppFormsService,
	CloneHelperService
) {
	let { tableId, formId } = $stateParams;
	let vm = this;
	let tab = 'form';
	vm.tab = tab;
	vm.classes = {
		labelClass: 'col-xs-12 col-lg-3',
		formGroupClass: 'form-group',
		inputContainerClass: 'col-xs-12 col-lg-6'
	};

	let cloneId = CloneHelperService.getItemClone();

	RuleBuilder.setFetcher(() =>
		cvUtil
			.loadPage('retrieveAppTableForm.do', { tableId, formId: cloneId || formId || 0, isBuilder: true })
			.then(function({ formName, ...data }) {
				var rules = [];

				if (data.properties && data.properties.rules && data.properties.rules.rules) {
					var currRules = data.properties.rules.rules;
					for (var i = 0; i < currRules.length; i++) {
						if (currRules[i].applyRuleToAllForms == undefined || currRules[i].applyRuleToAllForms != true)
							rules.push(currRules[i]);
					}
					data.properties.rules.rules = rules;
				}
				return { inputForm: cloneId ? data : { formName, ...data } };
			})
	);

	CloneHelperService.setItemClone(null);

	vm.saveFormRuleBuilder = function() {
		const builderData = RuleBuilder.getFormRuleBuilderData();

		if (!builderData.formName) return;

		var inputParams = {};
		inputParams.properties = builderData.properties;
		inputParams.formName = builderData.formName;
		//delete inputParams.properties["pageMode"];

		inputParams = JSON.stringify(inputParams);

		return formId
			? AppFormsService.updateInputForm(tableId, formId, inputParams).then(
					data => onSuccessSave(data, builderData),
					onErrorSave
			  )
			: AppFormsService.createInputForm(tableId, inputParams).then(
					data => onSuccessSave(data, builderData),
					onErrorSave
			  );
	};

	RuleBuilder.onCancelFormRuleBuilder(() => $state.go('tableConfig', { tableId, tab }));
	RuleBuilder.onSaveFormRuleBuilder(vm.saveFormRuleBuilder);
	RuleBuilder.openAppStudioFormsRuleBuilder({ tableId, formId });

	function onErrorSave(err) {
		if (err) {
			const message = getErrMessage(err);
			cvToaster.showErrorMessage({
				message
			});
		}
	}

	function onSuccessSave(data, builderData) {
		$state.go('tableConfig', { tableId, tab });
		cvToaster.showSuccessMessage({
			message: cvLoc('appdesigner.msg.saveSuccessful', '<b>' + builderData.formName + '</b>')
		});

		return data;
	}

	vm.loading = true;
	vm.tableId = tableId;
}

AppStudioFormCustomizeCtrl.$inject = [
	'$stateParams',
	'$log',
	'cvLoc',
	'$dialogs',
	'cvToaster',
	'$state',
	'AppFormsService',
	'CloneHelperService'
];

appDesignerModule.controller('AppStudioFormCustomizeCtrl', AppStudioFormCustomizeCtrl);

export default appDesignerModule;
