import { appDesignerModule } from 'common/js/modules';

import { cloneObjectInstance, getErrMessage } from '../util';

// dependencies
import '../services/apps.svc';

function AppEditModalCtrl($uibModalInstance, app) {
	let vm = this;

	// work with copy not original instance
	vm.app = cloneObjectInstance(app);

	vm.isNewApp = function isNewApp() {
		return app.id === undefined;
	};

	/**
	 * When the cancel button is pressed.
	 */
	vm.cancel = function cancel() {
		$uibModalInstance.dismiss();
	};

	vm.saveApp = function saveApp() {
		vm.app.save().then(onRequestSuccess, onRequestFailure);

		function onRequestSuccess(res) {
			$uibModalInstance.close(res);
		}
		function onRequestFailure(err) {
			$uibModalInstance.dismiss(err);
		}
	};
}

AppEditModalCtrl.$inject = ['$uibModalInstance', 'app'];

appDesignerModule.controller('AppEditModalCtrl', AppEditModalCtrl);

export default appDesignerModule;
