import { appDesignerModule } from 'common/js/modules';
// temporary localization App Designer strings
import '../../js/temp.localization';
import '../services/actions.svc';

import { getErrMessage } from '../util';

// dependencies injected/need by Angular

function ActionsConfigCtrl($stateParams, $log, cvLoc, $dialogs, cvToaster, $state, ActionsService) {
	let { tableId, businessRule } = $stateParams;
	let actionId = $stateParams.buttonId;
	let vm = this;
	vm.tab = 'actions';
	vm.tableId = $stateParams.tableId;
	vm.workflowEntities = {};
	vm.enableOptions = [
		{
			name: 'Always',
			value: 'always'
		},
		{
			name: 'On Single Row Selected',
			value: 'singleSelect'
		},
		{
			name: 'On Multi Row Selected',
			value: 'multiSelect'
		},
		{
			name: 'Expression',
			value: 'custom'
		}
	];

	vm.enableOptionsForRowActions = [
		{
			name: 'Always',
			value: 'always'
		},
		{
			name: 'Expression',
			value: 'custom'
		}
	];

	vm.typeOptions = [
		{
			name: 'Link',
			value: 'link'
		},
		{
			name: 'Button',
			value: 'button'
		}
	];

	vm.visibleOptions = [
		{
			name: 'Always',
			value: 'always'
		},
		{
			name: 'Expression',
			value: 'custom'
		}
	];

	vm.actionTypes = [
		{
			name: 'None',
			value: ''
		},
		{
			name: 'Run a workflow',
			value: 'Workflow'
		},
		{
			name: 'Url',
			value: 'Link'
		},
		{
			name: 'Custom',
			value: 'Custom'
		}
	];

	vm.classes = {
		labelClass: 'col-xs-12 col-lg-3',
		formGroupClass: 'form-group',
		inputContainerClass: 'col-xs-12 col-lg-6'
	};
	vm.action = {
		properties: {
			buttonType: 'table',
			mobileOptions: {
				visible: 'On'
			}
		}
	};
	vm.loading = true;

	if (actionId) ActionsService.getActionById(tableId, actionId).then(onRequestSuccess, onRequestFailure);

	function onRequestSuccess(action) {
		vm.loading = false;
		vm.action = action;
		vm.getOptionsForSelectedAction(vm.action.properties.clickExpression.action);
	}

	function onRequestFailure(err) {
		if (err) {
			const message = getErrMessage(err);
			cvToaster.showErrorMessage({
				message
			});
		}
		$log.error(err);
	}

	vm.getOptionsForSelectedAction = function(actionType) {
		if (actionType === 'Workflow') {
			if (!vm.workflows) {
				var promise = ActionsService.getForms();
				promise.then(function(response) {
					vm.workflows = response.container;
					for (var i = 0; i < vm.workflows.length; i++) {
						vm.workflowEntities[vm.workflows[i].entity.workflowName] = vm.workflows[i];
					}
				});
			}
		} else if (actionType === 'Report') {
		}
	};

	vm.getWorkflowInputs = function(name) {
		vm.action.properties.clickExpression.inputs = [];
		var obj = vm.workflowEntities[name];
		var inputForm = obj.deployments[0].inputForm;
		if (inputForm.entries) {
			for (var i = 0; i < inputForm.entries.length; i++) {
				vm.action.properties.clickExpression.inputs.push({
					id: inputForm.entries[i].inputName,
					value: '',
					isMulti: inputForm.entries[i].listType
				});
			}
		}
	};

	vm.handleEditAction = function handleEditAction() {
		if (!vm.action.properties.title.text) return;

		vm.action.name = vm.action.properties.title.text;

		const Action = ActionsService.getActionFromData(vm.tableId, vm.action);

		Action.save().then(onRequestSuccess, onRequestFailure);

		function onRequestSuccess() {
			$state.go('tableConfig', { tableId: vm.tableId, tab: vm.tab });
			cvToaster.showSuccessMessage({
				message: cvLoc('appdesigner.msg.saveSuccessful', '<b>' + vm.action.properties.title.text + '</b>')
			});
		}
	};

	vm.handleDeleteAction = function handleDeleteAction() {
		const actionName = vm.action.properties.title.text;

		$dialogs.confirm(
			cvLoc('appdesigner.label.confirmDelete'),
			cvLoc('appdesigner.msg.confirmDelete', `this action <b>${actionName}</b>`),
			{
				noFunction: function() {},
				yesFunction: function() {
					vm.action.remove().then(onDeleteSuccess, onRequestFailure);
				}
			}
		);

		function onDeleteSuccess() {
			cvToaster.showSuccessMessage({
				message: cvLoc('appdesigner.msg.deleteSuccessful', '<b>' + actionName + '</b>')
			});
			$state.go('tableConfig', { tableId: vm.tableId, tab: vm.tab });
		}
	};

	function appendColumnSchemaToColumnsIds(columnIds) {
		return columnIds.map(id => ({
			dataField: id,
			id,
			visible: true
		}));
	}

	function onRequestFailure(err) {
		if (err) {
			const message = getErrMessage(err);
			cvToaster.showErrorMessage({
				message
			});
		}
		$log.error(err);
	}
}

ActionsConfigCtrl.$inject = ['$stateParams', '$log', 'cvLoc', '$dialogs', 'cvToaster', '$state', 'ActionsService'];

appDesignerModule.controller('ActionsConfigCtrl', ActionsConfigCtrl);

export default appDesignerModule;
