<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.alertsJs"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.alerts">
<div class="setup-title">
	<h3><fmt:message key="heading.addNewUsers" /></h3>
</div>
<div class="setup-content">
	<fmt:message key="error.addNewUsersError" var="addNewUsersError" />	
		
		<div class="add-users group">
				<div class="user-suggestions-wrapper">
					<input type="text" class="add-user-textbox" data-ng-model="newUser.name" data-ng-keyup="getUserSuggestionsList()" placeholder="${addNewUsersError}">
					<div class="user-suggestions js-user-suggestions">
						<table class="user-suggestions-data js-user-suggestions-data">
							<tbody>
								<tr class="js-suggestions__row" data-ng-click="selectUserSuggestionRow()" data-ng-repeat="userSuggestion in userSuggestionList" data-ng-keyup="">
									<td class="suggestion" data-id="{{userSuggestion.userInfo.id}}" data-type="{{userSuggestion.userInfo.userType}}">
										<span class="match-text">{{newUser.name}}</span><span>{{userSuggestion.name | substring:newUser.name.length:userSuggestion.name.length}}</span>
									</td>
								</tr>
							</tbody>		
						</table>
					</div>
				</div>
				<label class="select-label user" for="adduserId">
				<select data-ng-model="newUser.type" class="add-user-type" id="adduserId">
					<option value="" selected="selected"><fmt:message key="label.selectAType" /></option>
					<option value="USER"><fmt:message key="userType.user" /></option>
					<option value="COMMCELL_GROUP"><fmt:message key="userType.group" /></option>
					<option value="EXTERNAL_GROUP"><fmt:message key="userType.egroup" /></option>
					<option value="EMAIL"><fmt:message key="userType.ngroup" /></option>
				</select>
				</label>
				
				<button id="editAlertUsers_button_#8436" data-ng-click="addNewUserGroup()" class="btn btn-primary add-user-btn"><fmt:message key="label.add" /></button> 
		</div>
		
		 <div class="added-users">
			<div class="peopleInfos ownerInfo">
					<div class="users-list">
						<ul class="users-list__user group" data-ng-repeat="user in alertDetails.userList">
							<li>
								<span class="user-type"><label data-id="{{user.id}}">{{user.name}}</label><span class="delete-user" ng-click="deleteUser(user)">&times;</span></span>
							</li>
						</ul>
						<ul class="users-list__user group" data-ng-repeat="group in alertDetails.userGroupList">
							<li>
								<span class="group-type"><label data-id="{{group.id}}">{{group.name}}</label><span class="delete-user" ng-click="deleteUser(group)">&times;</span></span>
							</li>
						</ul>
						<ul class="users-list__user group" data-ng-repeat="egroup in alertDetails.externalGroupList">
							<li>
								<span class="group-type"><label data-id="{{egroup.id}}">{{egroup.name}}</label><span class="delete-user" ng-click="deleteUser(egroup)">&times;</span></span>
							</li>
						</ul> 
						<ul class="users-list__user group" data-ng-repeat="ngroup in alertDetails.nonGalaxyUserList">
							<li>
								<span class="email-type"><label data-id="{{ngroup.id}}">{{ngroup.name}}</label><span class="delete-user" ng-click="deleteUser(ngroup)">&times;</span></span>
							</li>
						</ul> 
					</div>
			</div>
		</div>
		
		<span class="server-message {{serverMessage.type}}">{{serverMessage.message}}</span>
		<div class="button-container">
		  <button id="editAlertUsers_button_#1362" class="btn btn-default"  
		          data-ng-click="cancelUsersModal();"><fmt:message key="label.cancel" /></button>
		  <button id="editAlertUsers_button_#6923" class="btn btn-primary"  
		          data-ng-click="submitUsersModal();"><fmt:message key="label.save" /></button>
		</div>
</div>
</fmt:bundle>