<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div >
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.alertsJs"></cv:cvMessages>
	</script>
	<script type="text/ng-template"  id="tree_item_renderer.html">
		<div ng-class="{'selected': item.selectedState==='selected', 'partial': item.selectedState==='partial'}" >
			<button id="alertDetails_button_#3928" type="button" ng-class="item.state | lowercase" ng-click="itemDrilledDown(item)"></button> 
			<span ng-click="toggleSelectedState(item)"><label>{{item.label}}</span>
		</div>
    	<div class="children" ng-class="item.state">
	        <div class="browse-item" ng-repeat="item in item.children" ng-include="'tree_item_renderer.html'"></div>
	    </div>
	</script>
	<fmt:bundle basename="localization.alerts">
		<h1 class="page-title">{{alertDetail.alertDetail.alert.alert.name}}</h1>
		<div class="row">
			<div class="col-md-6">
				<cv-tile-component data-title='Users/Groups to notify'>
					<div class="page-details-box-links"><a class="edit-users" ng-click="openUserEditModal()"><fmt:message key="label.edit" /></a></div>
							<div class="users-list">
								<ul class="users-list__user group" data-ng-repeat="user in alertDetail.alertDetail.userList">
									<li>
										<span class="detail-results user-type"><label data-id="{{user.id}}">{{user.name}}</label></span>
										<span class="detail-results"><fmt:message key="userType.user" /></span>
									</li>
								</ul>
								<ul class="users-list__user group" data-ng-repeat="group in alertDetail.alertDetail.userGroupList">
									<li>
										<span class="detail-results group-type"><label data-id="{{group.id}}">{{group.name}}</label></span>
										<span class="detail-results"><fmt:message key="userType.group" /></span>
									</li>
								</ul>
								<ul class="users-list__user group" data-ng-repeat="ngroup in alertDetail.alertDetail.nonGalaxyUserList">
									<li>
										<span class="detail-results email-type"><label data-id="{{ngroup.id}}">{{ngroup.name}}</label></span>
										<span class="detail-results"><fmt:message key="userType.ngroup" /></span>
									</li>
								</ul>
								<ul class="users-list__user group" data-ng-repeat="egroup in alertDetail.alertDetail.externalGroupList">
									<li>
										<span class="detail-results group-type"><label data-id="{{egroup.id}}">{{egroup.name}}</label></span>
										<span class="detail-results"><fmt:message key="userType.egroup" /></span>
									</li>
								</ul>
							</div>
				</cv-tile-component>
			</div>
			<div class="col-md-6">
				<cv-tile-component data-title='<fmt:message key="heading.alertSummary" />'>
					<ul class="group">
						<li><span class="detail-results"><fmt:message key="label.alertDescription" /></span>
							 <span class="detail-results">{{alertDetail.alertDetail.alert.alert.name}}</span></li>
						<li><span class="detail-results"><fmt:message key="label.alertType" /></span>
							 <span class="detail-results">{{alertDetail.alertDetail.alert.alertType.name}}</span></li>
						<li><span class="detail-results"><fmt:message key="label.alertCategory" /></span>
							 <span class="detail-results">{{alertDetail.alertDetail.alert.alertCategory.name}}</span></li>
						<%-- <li><span class="detail-results"><fmt:message key="label.notificationTypes" /></span>
							 <span class="detail-results">None</span></li>
						<li><span class="detail-results"><fmt:message key="label.reportingCriteria" /></span>
							 <span class="detail-results">None</span></li> --%>
					</ul>
				</cv-tile-component>
			</div>
		</div>
		<div class="server-message {{serverMessage.type}}">{{serverMessage.message}}</div>
	</fmt:bundle>
</div>