<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.setup"></cv:cvMessages>
</script>
<div class="width-750-center" data-ng-controller="linkMetallicAccountController as linkMetallicAccountCtrl" data-ng-show="linkMetallicAccountCtrl.isLinkingAllowed">
	<div data-ng-show="!linkMetallicAccountCtrl.showMetallicOptions">
		<div class="error text-center"
				data-ng-bind="linkMetallicAccountCtrl.tenantOperatorErrorMessage"></div>
	</div>
	<div data-ng-show="linkMetallicAccountCtrl.showMetallicOptions">

	<div class="setup-title">
		<h1>
			<cv:msg key="label.enterMetallicCredentials" bundle="setup" />
		</h1>
	</div>
	<div class="bootstrap-wrapper">
		<div>

			<div
				class="{{linkMetallicAccountCtrl.serverMessage.type}} text-center"
				data-ng-bind="linkMetallicAccountCtrl.serverMessage.message"></div>
			<div class="list-group-item" data-ng-show="formConfig.hide">
				<h5 class="text-left font-weight-bold">
					<cv:msg key="label.MetallicAlreadyConfigured" bundle="setup" />
				</h5>
			</div>
			<form name="linkMetallicAccount" cv-hide-api novalidate autocomplete="off"
				data-cv-submit="linkMetallicAccountCtrl.linkCredentials()"
				class="bootstrap-wrapper form-horizontal"
				data-ng-show="!formConfig.hide">
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="userName"> <cv:msg
							key="label.userName" bundle="servers" />
					</label>
					<div class="col-xs-12 col-lg-8">
						<input type="text" data-ng-model="data.userName" required
							id="userName" name="userName" /> <span class="help-block"
							data-ng-show="cv.linkMetallicAccount.needsAttention(linkMetallicAccount.userName)">
							<cv:msg key="error.userName" bundle="ediscovery" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="userNamePassword"> <cv:msg
							key="label.password" bundle="servers" />
					</label>
					<div class="col-xs-12 col-lg-8">
						<input type="password" data-ng-model="data.password" required
							id="userNamePassword" name="userNamePassword" /> <span
							class="help-block"
							data-ng-show="cv.linkMetallicAccount.needsAttention(linkMetallicAccount.userNamePassword)">
							<cv:msg key="error.password" bundle="ediscovery" />
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="showLinkCompany && companies.length > 0">
					<label class="col-xs-12 col-lg-4" for="linkCompany">
						<cv:msg key="label.company" bundle="servers" />
					</label>
					<div class="col-xs-12 col-lg-8">
						<isteven-multi-select
							input-model="companies"
							output-model="selectedCompany"
							button-label="name"
							item-label="name"
							tick-property="ticked"
							class="isteven-multi-select user-group-select"
							id="linkCompany"
							name="linkCompany"
							selection-mode="single">
						</isteven-multi-select>
						<input type="text" name="selectLinkCompany"  ng-model="selectedCompany" ng-hide="true" required/>
						<span
							class="help-block"
							data-ng-show="cv.linkMetallicAccount.needsAttention(linkMetallicAccount.linkCompany)">
							<cv:msg key="error.comapny" bundle="ediscovery" />
						</span>
					</div>
				</div>

				<div class="button-container">
					<button id="linkMetallicAccount_button_#1403"
                        class="btn btn-default cvBusyOnAjax setup-btn--hidden" type="button" ng-click="openMetallic()">
                        <span> <cv:msg key="label.getMetallic" bundle="setup" />
                        </span>
                    </button>
					<button id="linkMetallicAccount_button_#1402"
						data-ng-disabled="!linkMetallicAccount.$valid" type="submit"
						class="btn btn-primary cvBusyOnAjax">
						<span> <cv:msg key="Save" bundle="messages" />
						</span>
					</button>
				</div>

			</form>
			<div class="button-container" data-ng-show="formConfig.hide">
				<button id="linkMetallicAccount_button_#4745" type="button"
					class="btn btn-default cvBusyOnAjax" data-ng-click="unsubscribe()"><cv:msg key="label.MetallicUnsubscribe" bundle="setup" /></button>
			</div>
		</div>
	</div>
</div>
</div>