<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.scheduleJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvEnum name="App.CloudAppsInstanceType"></cv:cvEnum>
</script>
<div data-ng-controller="oneDriveSubClientDetailsGAPIController as cappSCDetGAPIctl">
<!-- !!! Need to create scss class for page-details-box-links -->
<%-- <h1 class="pageTitle">
	<span class="name">
		<span data-ng-bind="details.subClientEntity.subclientName" ></span>
		<span data-ng-show="!details.subClientEntity.subclientName"><cv:msg key="label.loadingCollection" bundle="collections" /></span>
	</span>
</h1> --%>
<div class="row">
	<div class="col-md-12">
		<h1 class="float-left" data-ng-bind="cappSCDetGAPIctl.scdetails.subClientEntity.subclientName" ></h1>
		<span class="server-message {{cappSCDetGAPIctl.serverMessage.type}}">{{cappSCDetGAPIctl.serverMessage.message}}</span>
		<!--Backup Restore links -->
		<span data-ng-if="cappSCDetGAPIctl.scdetails && cappSCDetGAPIctl.scdetails.commonProperties.isDefaultSubclient!=true"  data-ng-click="cappSCDetGAPIctl.deleteCAppClientSC(cappSCDetGAPIctl.scdetails.subClientEntity)"><a class="page-action-item" href=""><cv:msg key="Delete" bundle="messages"/></a></span>
		<span data-ng-if="cappSCDetGAPIctl.scdetails"><a class="page-action-item" href="" data-ng-click="cappSCDetGAPIctl.getRestoreHistoryUrl()"><cv:msg key="label.RestoreHistory" bundle="capps" /></a></span>
		<span data-ng-if="cappSCDetGAPIctl.scdetails"><a class="page-action-item" href="" data-ng-click="cappSCDetGAPIctl.getBackupHistoryUrl()"><cv:msg key="label.BackupHistory" bundle="capps" /></a></span>
		<span data-ng-if="cappSCDetGAPIctl.scdetails && cappSCDetGAPIctl.showRestoreOption()" ><a class="page-action-item" href="" data-ng-click="cappSCDetGAPIctl.doCappsBrowse()"><cv:msg key="label.restore" bundle="capps"/></a></span>
	</div>
</div>
<span class="server-message {{cappSCDetGAPIctl.serverMessage.type}}">{{cappSCDetGAPIctl.serverMessage.message}}</span>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="cappsSubclientDetailsGM-label_summary-servers" data-ng-show="cappSCDetGAPIctl.scdetails" data-title='<cv:msg key="label.summary" bundle="servers"/>' loader="cappSCDetGAPIctl.backupEnabledStatusInfo">
			<ul data-ng-if="cappSCDetGAPIctl.scdetails" class="group list-style-secondary">
					<li class="group"><span class="pageDetailColumn"><cv:msg key="label.lastbackup.time" bundle="collections" /></span>
						 <span data-ng-if='cappSCDetGAPIctl.scdetails.commonProperties.lastBackupTime!=0' class="pageDetailColumn"><div class="time crop" val="{{cappSCDetGAPIctl.scdetails.commonProperties.lastBackupTime}}"></div></span></li>
					<li class="group"><span class="pageDetailColumn"><cv:msg key="label.lastbackup.size" bundle="collections" /></span>
						 <span class="pageDetailColumn">{{cappSCDetGAPIctl.scdetails.commonProperties.lastBackupSize | capacity}}</span></li>
					<li class="group"><span class="pageDetailColumn"><cv:msg key="label.data.management" bundle="servers" /></span>
					<span class="pageDetailColumn">
						<toggle-control class="{{cappSCDetGAPIctl.backupEnabledStatusInfo}}" status="cappSCDetGAPIctl.backupEnabledStatusInfo" data-ng-click="cappSCDetGAPIctl.manageActivity()" title="Enable/disable <cv:msg key='label.data.management' bundle='servers' />"></toggle-control>
					</span>
					</li>
				</ul>
		</cv-tile-component>
		<cv-tile-component data-ac-id="cappsSubclientDetailsGM-label_backup-collections" data-ng-show="cappSCDetGAPIctl.scdetails" data-title='<cv:msg key="label.backup" bundle="collections" />'>
			<ul class="serverBackupTile">
<!-- Top right tile links -->
				<li><span class="page-details-box-links multiLinks">
					<ul>
					<!-- Show BackupNow link only when no backup jobs are currently running-->
						<li data-ng-if="cappSCDetGAPIctl.showBackup['backup'] && cappSCDetGAPIctl.backupEnabledStatusInfo!= 'disabled-activity'" class="restoreli"    data-ng-click="cappSCDetGAPIctl.showBackupOptions(cappSCDetGAPIctl.entityType,cappSCDetGAPIctl.genericEntity, cappSCDetGAPIctl.cloudInstanceType)"><a href=""><cv:msg key="action.backupNow" bundle="collections" /></a></li>
						<li><a data-ng-href="#jobs?collectionId={{cappSCDetGAPIctl.scdetails.subClientEntity.subclientId}}&collectionName={{cappSCDetGAPIctl.scdetails.subClientEntity.subclientName}}&jobType=Backup&cappsType={{cappSCDetGAPIctl.cloudAppIntType}}"><cv:msg key="action.jobs" bundle="servers" /></a></li>
					</ul>
				</span></li>
<!-- If no backup jobs are running, show appropriate message -->
				<li data-ng-if="cappSCDetGAPIctl.showBackup['backup']">
					<p class="info-place-holder"><cv:msg key="info.nobackupRunning" bundle="collections" /></p>
				</li>
<!-- If backup job is being submitted, show appropriate message -->
				<li data-ng-if="cappSCDetGAPIctl.showBackup['submittingJob']">
					<p class="info-place-holder"><cv:msg key="info.submittingJob" bundle="collections" /></p>
				</li>
<!-- If atleast one backup job is running, show the job details using cvJob directive -->
				<li data-ng-if="cappSCDetGAPIctl.backupJobs.length>0"><data-cv-job jobs='cappSCDetGAPIctl.backupJobs' show-backup='cappSCDetGAPIctl.showBackup'></data-cv-job></li>
				<li data-ng-if="cappSCDetGAPIctl.backupJobErrorMessage">
					<ul>
							<span class="serverMessage {{cappSCDetGAPIctl.backupJobErrorMessage.type}}">{{cappSCDetGAPIctl.backupJobErrorMessage.message}}</span>
						</ul>
				</li>
				</ul>
		</cv-tile-component>
		<cv-security-component data-ng-show="cappSCDetGAPIctl.scdetails" entity-type='cappSCDetGAPIctl.entityType' generic-entity = 'cappSCDetGAPIctl.genericEntity' associations='cappSCDetGAPIctl.formattedSecurityAssociations' associations-loaded='cappSCDetGAPIctl.associationsLoaded' data-show-Owners='true'>
		</cv-security-component>
		<cv-alert-component data-ng-show="cappSCDetGAPIctl.scdetails" alerts='cappSCDetGAPIctl.alerts'>
		</cv-alert-component>
	</div>
	<div class="col-md-6">
		<!-- 	plan tile -->
		<cv-plan-component
			data-ng-show="cappSCDetGAPIctl.planSet"
			client-id="cappSCDetGAPIctl.clientId"
			subclient-id="cappSCDetGAPIctl.subclientId"
			plan-entity="cappSCDetGAPIctl.scdetails.planEntity"
			type="Server">
		</cv-plan-component>
		<!-- 	storage pool tile -->
		<cv-storage-pool-tile
			data-ng-show="cappSCDetGAPIctl.planSet && cappSCDetGAPIctl.primaryStoragePoolInfo"
			plan-sub-type="cappSCDetGAPIctl.planSubType"
			show-edit="false"
			primary-storage-pool-info="cappSCDetGAPIctl.primaryStoragePoolInfo"
			secondary-storage-pool-info="cappSCDetGAPIctl.secondaryStoragePoolInfo"
			snap-storage-info="cappSCDetGAPIctl.snapStorageInfo">
		</cv-storage-pool-tile>
		<!-- 	storage targets tile -->
		<cv-storage-policy-component
			data-ng-show="!cappSCDetGAPIctl.planSet"
			show-edit="true"
			client-id="cappSCDetGAPIctl.clientId"
			application-id="cappSCDetGAPIctl.applicationId"
			subclient-id="cappSCDetGAPIctl.subclientId"
			subclient-name ="cappSCDetGAPIctl.subclientName"
			hide-copy-properties="true">
		</cv-storage-policy-component>
		<!-- 	schedules tile -->
		<cv:comp name="show.schedules">
			<cv-schedule-tile data-ng-if="!cappSCDetGAPIctl.mspUI" data-ng-show="cappSCDetGAPIctl.scdetails"
				loader="cappSCDetGAPIctl.scdetails"
				scheduleIdentifierList="cappSCDetGAPIctl.scheduleIdentifierList"
				subclient-id="subclientId"
				show-edit="!cappSCDetGAPIctl.planSet"
				is-schedule-editable="!cappSCDetGAPIctl.planSet" ></cv-schedule-tile>
		</cv:comp>
		<cv-tile-component data-ac-id="cappsSubclientDetailsGM-label_content-capps" data-ng-show="cappSCDetGAPIctl.scdetails" data-title='<cv:msg key="label.content" bundle="capps"/>' loader="cappSCDetGAPIctl.previewContents">
			<ul data-ng-if="cappSCDetGAPIctl.previewContents.length>0" class="group list-style-secondary">
				<li class="group"><span class="pageDetailColumnFull content-count-underline"><div class="content-count-display"><cv:msg key="label.content.count" bundle="capps" />: ({{cappSCDetGAPIctl.contentCounts.total.count}})</div>
						<div data-ng-show="cappSCDetGAPIctl.contentCounts.userContent.count > 0" class="content-count-display"><span class="{{cappSCDetGAPIctl.contentCounts.userContent.iconClass}}"></span><cv:msg key="content.type.google.user.acc" bundle="capps"/>({{cappSCDetGAPIctl.contentCounts.userContent.count}})</div>
						<div data-ng-show="cappSCDetGAPIctl.contentCounts.ggContent.count > 0" class="content-count-display">
							<span class="{{cappSCDetGAPIctl.contentCounts.ggContent.iconClass}}"></span>
							<span data-ng-if="(cappSCDetGAPIctl.cloudInstanceType === cappSCDetGAPIctl.cloudAppTypeGoogleDrive) || (cappSCDetGAPIctl.cloudInstanceType === cappSCDetGAPIctl.cloudAppTypeGoogleMail)"><cv:msg key="content.type.google.group.acc" bundle="capps" /></span>
							<span data-ng-if="(cappSCDetGAPIctl.cloudInstanceType === cappSCDetGAPIctl.cloudAppTypeOneDrive)"><cv:msg key="content.type.azure.group.acc" bundle="capps"  /></span>
							({{cappSCDetGAPIctl.contentCounts.ggContent.count}})
						</div>
						<div data-ng-show="cappSCDetGAPIctl.contentCounts.regexContent.count > 0" class="content-count-display"><span class="{{cappSCDetGAPIctl.contentCounts.regexContent.iconClass}}"></span><cv:msg key="content.type.regex" bundle="capps"/>({{cappSCDetGAPIctl.contentCounts.regexContent.count}})</div>
					</span>
				</li>
				<li data-ng-repeat="previewContent in cappSCDetGAPIctl.previewContents" class="group">
					<span class="pageDetailColumn"><div class="{{previewContent.iconClass}}"></div>
						<span data-ng-show="previewContent.contentType ===  cappSCDetGAPIctl.contentTypeUser">{{previewContent.contentValue | removeonedrivecoloncolon1}}</span>
						<span data-ng-show="previewContent.contentType !==  cappSCDetGAPIctl.contentTypeUser">{{previewContent.contentName}}</span>
					</span>
					<span class="pageDetailColumn">{{previewContent.localizedType}}</span>
				</li>
			</ul>
			<span class="tile-link-wrapper" data-ng-if="cappSCDetGAPIctl.previewContents.length > 0">
				<a class="tile-content-link" data-ng-click="cappSCDetGAPIctl.showSCContentModal()"><cv:msg key="content.label.more" bundle="capps"/></a>
			</span>
			<ul data-ng-if="cappSCDetGAPIctl.previewContents.length == 0" class="group list-style-secondary">
				<li><span class="serverMessage {{cappSCDetGAPIctl.noContentMsg.type}}">{{cappSCDetGAPIctl.noContentMsg.message}}</span></li>
			</ul>
			<!-- Uncomment below div that exposes Manage of content once discovery js code is refactored and subclient save is completed-->
			<div class="page-details-box-links" data-ng-show="cappSCDetGAPIctl.previewContents">
				<a href="" data-ng-click="cappSCDetGAPIctl.showSCContentModal()"><cv:msg key="label.manage" bundle="capps" /></a>
            </div>
		</cv-tile-component>
	</div>
</div>
</div>
