<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>//also needed for displaying the toast message
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.restoreOpts" bundle="restore"/></h1>
</div>
<span class="{{restoreCappsCtrl.serverMessage.type}}" data-ng-bind="restoreCappsCtrl.serverMessage.message"></span>
<form name="restoreForm" class="form-horizontal bootstrap-wrapper" novalidate data-cv-submit="restoreCappsCtrl.doRestore()" autocomplete="off">
		<div class="modal-body">
			<div class="form-group">
				<label class="col-xs-5"><cv:msg key="label.restoreTo" 	bundle="exchange" /></label>
				<div class="col-xs-7">
					<select id="restoreTo" name="restoreTo"
								data-ng-options="option.value as option.name for option in  restoreCappsCtrl.restoreTypeList "
								data-ng-model="restoreCappsCtrl.restoreType"
								data-ng-change="restoreCappsCtrl.restoreTypeChanged()"	>
<%-- 								<option value="{{restoreCappsCtrl.restoreTypeDisk}}"><cv:msg key="label.toDisk" bundle="capps"/></option> --%>
<%-- 								<option value="{{restoreCappsCtrl.restoreTypeAccount}}"> <cv:msg key="label.toOneDrive" bundle="capps"/></option> --%>
					</select>
				</div>
			</div>
			<hr>
			<div data-ng-switch="restoreCappsCtrl.restoreType">
					<!-- START - TO DISK -->
				<div data-ng-switch-when="disk">
					<!--proxy servers with cloudconnector agent -->
					<div class="form-group">
								<label class="col-xs-5" for="proxyServer"><cv:msg key="label.destHost" bundle="capps"/></label>
								<div class="col-xs-7">
									<select id="proxyServer" name="proxyServer"
											data-ng-model="restoreCappsCtrl.selectedProxyServer"
											data-ng-options="ds as ds.clientName for ds in restoreCappsCtrl.proxyServerList track by ds.clientId | orderBy: 'clientName'"
											data-ng-required="true"
											data-ng-change="restoreCappsCtrl.proxyServerChanged()">
											<option value=""><cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/></option>
									</select>
									<div class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.proxyServer)">
											<i class="ion-alert-circled"></i>
											<cv:msg key="error.destinationServer" bundle="restore"></cv:msg>
									</div>
							</div>
					</div>
					  <!-- For Path -->
					<div class="form-group">
								<label for="restorePath" class="col-xs-5"><cv:msg key="label.destPath" bundle="snapArray"/></label>
								<div class="col-xs-7">
										<div class="input-group">
												<input type="text" id="restorePath" name="restorePath"
													data-ng-disabled="!restoreCappsCtrl.selectedProxyServer"
													data-ng-model="restoreCappsCtrl.selectedDiskPath"
													data-ng-required="restoreCappsCtrl.restoreType == restoreCappsCtrl.restoreTypeDisk" />
												<span class="input-group-btn">
															<button id="oneDriveRestoreOptions_button_#0782" class="btn btn-default" type="button" 
																data-ng-disabled="!restoreCappsCtrl.selectedProxyServer"
																data-ng-click="restoreCappsCtrl.openDiskDestinationFolder()"><cv:msg key="label.browse" bundle="restore"/>
															</button>
											    </span>
										</div>
										<div class="help-block" data-ng-show="restoreCappsCtrl.isDiskDestinationInfoNeeded() && cv.restoreForm.needsAttention(restoreForm.restorePath)">
											<i class="ion-alert-circled"></i>
											<cv:msg key="error.pathRequired" bundle="restore"/>
										</div>
								</div>
					</div>
				</div>
				<!-- END - TO DISK -->
				<!-- START - TO ONE DRIVE -->
				<div data-ng-switch-when="account">
					<!--pseudo servers filtered by cloudapptype -->
					<div class="form-group">
								<label class="col-xs-5" for="pseudoServer"><cv:msg key="label.destHost" bundle="capps"/></label>
								<div class="col-xs-7">
									<select id="pseudoServer" name="pseudoServer"
											data-ng-model="restoreCappsCtrl.selectedPseudoServer"
											data-ng-options="ds as ds.clientName for ds in restoreCappsCtrl.pseudoServerList track by ds.clientId | orderBy: 'clientName'"
											data-ng-required="true"
											data-ng-change="restoreCappsCtrl.proxyServerChanged()">
											<option value=""><cv:msg key="placeholder.selectDestinationServer" bundle="restoreJs"/></option>
									</select>
									<div class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.pseudoServer)">
											<i class="ion-alert-circled"></i>
											<cv:msg key="error.destinationServer" bundle="restore"></cv:msg>
									</div>
							</div>
					 </div>
					<!--in place restore option -->
					<div class="form-group">
						<div class="col-xs-12">
							<input id="inplace" name="inplace" 	type="checkbox" data-ng-model="restoreCappsCtrl.restoreToOriginalPath" />
							<label	for="inplace"><cv:msg key="label.restoreToOriginal" bundle="restore"/></label>
						</div>
					</div>
					<!--path selection for out of place restore -->
					 <div class="form-group">
								<label for="restoreODPath" class="col-xs-5"><cv:msg key="label.destPath" bundle="snapArray"/></label>
								<div class="col-xs-7">
										<div class="input-group">
												<input type="text" id="restoreODPath" name="restoreODPath"
													data-ng-disabled="!restoreCappsCtrl.selectedPseudoServer ||  restoreCappsCtrl.restoreToOriginalPath"
													data-ng-model="restoreCappsCtrl.selectedODPath"
													data-ng-required="(restoreCappsCtrl.restoreType == restoreCappsCtrl.restoreTypeAccount) && !restoreCappsCtrl.restoreToOriginalPath" />
												<span class="input-group-btn">
															<button id="oneDriveRestoreOptions_button_#8525" class="btn btn-default" type="button" 
																data-ng-disabled="!restoreCappsCtrl.selectedPseudoServer ||  restoreCappsCtrl.restoreToOriginalPath"
																data-ng-click="restoreCappsCtrl.openODDestinationFolder()"><cv:msg key="label.browse" bundle="restore"/>
															</button>
											    </span>
										</div>
										<div class="help-block" data-ng-show="restoreCappsCtrl.isODDestinationInfoNeeded() && cv.restoreForm.needsAttention(restoreForm.restoreODPath)">
											<i class="ion-alert-circled"></i>
											<cv:msg key="error.pathRequired" bundle="restore"/>
										</div>
								</div>
					</div>
					<!--overwrite option -->
					<div class="form-group">
						<div class="col-xs-12">
							<input id="overwrite" name="overwrite" 	type="checkbox" data-ng-model="restoreCappsCtrl.overwrite" />
							<label	for="overwrite"><cv:msg key="warning.overwrite" bundle="restore"/></label>
						</div>
					</div>
			</div>
			<!-- END - TO ONE DRIVE -->
			</div>
		</div>
		<div class="modal-footer">
			<button id="oneDriveRestoreOptions_button_#2157" class="btn btn-default cvBusyOnAjax" type="button" data-ng-click="restoreCappsCtrl.cancelModel()"><cv:msg key="Cancel" bundle="messages" /></button> 
			<button id="oneDriveRestoreOptions_button_#1779" class="btn btn-primary cvBusyOnAjax" type="submit"><cv:msg key="Submit" bundle="messages"/></button> 
		</div>
</form>
