<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.gsuite"></cv:cvMessages>
</script>

<form
	data-cv-submit="gsuiteEditAutoDiscoverSettingsCtrl.saveInfo()"
	name="editGSuiteAutoDiscoverSettingsForm"
	class="form-horizontal bootstrap-wrapper"
	novalidate
>
	<div class="modal-header">
		<h1 class="modal-title">
			<cv:msg key="settings.autodiscovery" bundle="gsuite" />
		</h1>
	</div>

	<div class="modal-body">
		<div class="form-group">
			<div class="col-xs-12">
				<input
					id="enableAutoDiscovery"
					type="checkbox"
					data-ng-checked="gsuiteEditAutoDiscoverSettingsCtrl.gsuiteInstanceDetails.isAutoDiscoveryEnabled"
					data-ng-model="gsuiteEditAutoDiscoverSettingsCtrl.gsuiteInstanceDetails.isAutoDiscoveryEnabled"
					data-ng-change="gsuiteEditAutoDiscoverSettingsCtrl.autoDiscoveryChanged()"
				/> 
				<label for="enableAutoDiscovery">
					<cv:msg key="label.enable" bundle="gsuite"/>
				</label>
			</div>
		</div>

		<div
			class="form-group margin-left-10"
			data-ng-show="gsuiteEditAutoDiscoverSettingsCtrl.gsuiteInstanceDetails.isAutoDiscoveryEnabled"
		>
			<label class="col-xs-12" for="typeOfAutoDiscoverRegex">
				<input
					type="radio" 
					id="typeOfAutoDiscoverRegex"
					value="{{gsuiteEditAutoDiscoverSettingsCtrl.regexText}}" 
					name="typeOfAutoDiscover"
					data-ng-model="gsuiteEditAutoDiscoverSettingsCtrl.gsuiteInstanceDetails.autoDiscoveryMode"
					data-ng-change="gsuiteEditAutoDiscoverSettingsCtrl.processModeSelection()"
				/>
				<cv:msg key="label.option.regular.expressions" bundle="gsuite"/>
			</label>

			<label class="col-xs-12" for="typeOfAutoDiscoverGroup" >
				<input 
					type="radio" 
					id="typeOfAutoDiscoverGroup" 
					value="{{gsuiteEditAutoDiscoverSettingsCtrl.userGrpText}}" 
					name="typeOfAutoDiscover"
					data-ng-model="gsuiteEditAutoDiscoverSettingsCtrl.gsuiteInstanceDetails.autoDiscoveryMode"
					data-ng-change="gsuiteEditAutoDiscoverSettingsCtrl.processModeSelection()"
				/>
				<cv:msg key="label.option.google.userOrganization" bundle="gsuite"/>
			</label>
		</div>

		<!-- Auto-create Subclients --START -->
		<div
			class="form-group" 
			data-ng-if="gsuiteEditAutoDiscoverSettingsCtrl.showCreateNewSubclientsOption"
			data-ng-disabled="gsuiteEditAutoDiscoverSettingsCtrl.gsuiteInstanceDetails.autoDiscoveryMode === gsuiteEditAutoDiscoverSettingsCtrl.userGrpText"
		>
			<div class="col-xs-12">
				<input
					id="enableCreateAdditionalSubclients"
					type="checkbox"
					data-ng-checked="gsuiteEditAutoDiscoverSettingsCtrl.createSubclientsCheck"
					data-ng-model="gsuiteEditAutoDiscoverSettingsCtrl.createSubclientsCheck"
					data-ng-change="gsuiteEditAutoDiscoverSettingsCtrl.createSubclientsChanged()"
				/>
				<label for="enableCreateAdditionalSubclients">
					<cv-help-text help-label="label.createSubclients" help-text="help.createSubclients"/>
				</label>
			</div>
			<div class="form-group margin-left-10">
				<label class="col-xs-12  margin-left-15" for="subclientOptions">
					<cv-radio-group
						radio-name="subclientOptions"
						on-click="gsuiteEditAutoDiscoverSettingsCtrl.subclientNumberSelection(data)"
						radio-model="gsuiteEditAutoDiscoverSettingsCtrl.gsuiteInstanceDetails.numberofAdditionalSubclients" 
						radio-obj="gsuiteEditAutoDiscoverSettingsCtrl.subclientOptions">
					</cv-radio-group>
				</label>
			</div>
		</div>
		<!--Auto-create Subclients --End -->
	</div>
	
	<div class="modal-footer">
		<button
			type="button"
			class="btn btn-default cvBusyOnAjax"
			data-ng-click="gsuiteEditAutoDiscoverSettingsCtrl.cancel()"
		>
			<cv:msg key="Cancel" bundle="messages" />
		</button>

		<button
			type="submit"
			class="btn btn-primary cvBusyOnAjax"
		>
			<cv:msg key="Save" bundle="messages" />
		</button>
	</div>
</form>