<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.gsuite"></cv:cvMessages>
</script>

<div class="row">
	<div class="col-md-6">
		<!-- General --START -->
		<cv-tile-component
			data-ac-id="gsuiteAppSettings-header_general"
			data-title='<cv:msg key="header.general" bundle="capps"/>'
			data-ng-show="gsuiteAppSettingsCtrl.instanceDetails"
			loader="(gsuiteAppSettingsCtrl.clientName && gsuiteAppSettingsCtrl.instanceDetails.emailId && gsuiteAppSettingsCtrl.infrastructureSettingsLoaded)"
		>
			<ul class="group list-style-secondary toggle-height">

				<!-- Application ID --START -->
				<li class="group" data-ng-if="gsuiteAppSettingsCtrl.previewAppClientID">
					<span class="pageDetailColumn"><cv:msg key="label.appClientId" bundle="capps"/></span>
					<span class="pageDetailColumn">
						<span data-ng-bind="gsuiteAppSettingsCtrl.instanceDetails.appClientId"></span>
						<span class="float-right tile-content-link" >
							<a data-ng-click="gsuiteAppSettingsCtrl.editAppClientID(true)">
								<cv:msg key="label.edit" bundle="clients" />
							</a>
						</span>
					</span>
				</li>

				<li class="group"  data-ng-if="!gsuiteAppSettingsCtrl.previewAppClientID">
					<span class="pageDetailColumn"><cv:msg key="label.appClientId" bundle="capps"/></span>
					<span class="pageDetailColumn inline-editor">
						<div class="inline-editor-input">
							<input
								type="text"
								name="appClientId"
								id="appClientId"
								data-ng-model="gsuiteAppSettingsCtrl.instanceDetails.appClientId"
							/>
						</div>
						<span class="inline-editor-buttons">
							<a
								class="inline-editor-button"
								data-ng-class="{disabled: loading}"
								data-ng-click="gsuiteAppSettingsCtrl.updateInstanceDetails(gsuiteAppSettingsCtrl.gsuiteConstants.editModes.EDIT_APP_CLIENT_ID)">
									<span class="k-icon k-i-check"></span>
							</a>
							<a
								class="inline-editor-button"
								data-ng-class="{disabled: loading}"
								data-ng-click="gsuiteAppSettingsCtrl.editAppClientID(false)">
									<span class="k-icon k-i-x"></span>
							</a>
						</span>
					</span>
				</li>
				<!-- Application ID --END -->

				<!-- Email ID --START -->
				<li class="group" data-ng-if="gsuiteAppSettingsCtrl.previewEmailID">
					<span class="pageDetailColumn"><cv:msg key="label.emailId" bundle="capps"/></span>
					<span class="pageDetailColumn">
						<span data-ng-bind="gsuiteAppSettingsCtrl.instanceDetails.emailId"></span>
						<span class="float-right tile-content-link" >
							<a data-ng-click="gsuiteAppSettingsCtrl.editEmailID(true)">
								<cv:msg key="label.edit" bundle="clients" />
							</a>
						</span>
					</span>
				</li>

				<li class="group"  data-ng-if="!gsuiteAppSettingsCtrl.previewEmailID">
					<span class="pageDetailColumn"><cv:msg key="label.emailId" bundle="capps"/></span>
					<span class="pageDetailColumn inline-editor">
						<div class="inline-editor-input">
							<input
								type="text"
								name="emaidID"
								id="emaidID"
								data-ng-model="gsuiteAppSettingsCtrl.instanceDetails.emailId"
							/>
						</div>
						<span class="inline-editor-buttons">
							<a
								class="inline-editor-button"
								data-ng-class="{disabled: loading}"
								data-ng-click="gsuiteAppSettingsCtrl.updateInstanceDetails(gsuiteAppSettingsCtrl.gsuiteConstants.editModes.EDIT_EMAIL_ID)">
									<span class="k-icon k-i-check"></span>
							</a>
							<a
								class="inline-editor-button"
								data-ng-class="{disabled: loading}"
								data-ng-click="gsuiteAppSettingsCtrl.editEmailID(false)">
									<span class="k-icon k-i-x"></span>
							</a>
						</span>
					</span>
				</li>
				<!-- Email ID --END -->

				<!-- Content indexing --START -->
				<li class="group" data-ng-show="gsuiteAppSettingsCtrl.onlineContentIndex">
					<span class="pageDetailColumn"><cv:msg key="label.ContentIndex" bundle="capps"/></span>
					<span class="pageDetailColumn">
						<toggle-control
							data-ng-class="gsuiteAppSettingsCtrl.onlineContentIndex"
							status="gsuiteAppSettingsCtrl.onlineContentIndex"
							data-ng-click="gsuiteAppSettingsCtrl.manageContentIndexing()"
							title="Enable/disable <cv:msg key='label.ContentIndex' bundle='capps' />"
						></toggle-control>
					</span>
				</li>
				<!-- Content indexing --END -->

				<!-- Auto discovery --START -->
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.data.autoDiscover" bundle="capps"/></span>
					<span class="pageDetailColumn">
						<span data-ng-bind="gsuiteAppSettingsCtrl.autoDiscoverStatus"></span>
						<span class="float-right tile-content-link" >
							<a data-ng-click="gsuiteAppSettingsCtrl.editGSuiteAutoDiscoverSettings()">
								<cv:msg key="label.edit" bundle="clients" />
							</a>
						</span>
					</span>
				</li>
				<!-- Auto discovery --END -->

				<!-- Automatic content management --START -->
				<li class="group" data-ng-if="gsuiteAppSettingsCtrl.isAutoDiscoveryEnabled">
					<span class="pageDetailColumn">
						<cv-help-text
							help-label="label.gsuite.autoManageContent"
							help-text="help.gsuite.autoManageContent"
						/>
					</span>
					<span class="pageDetailColumn">
						<toggle-control 
							data-ng-class="gsuiteAppSettingsCtrl.toggle_manageSubclientContentAutomatically"
							status="gsuiteAppSettingsCtrl.toggle_manageSubclientContentAutomatically" 
							data-ng-click="gsuiteAppSettingsCtrl.manageContentAutomatically()" 
							title="Enable/disable <cv:msg key='label.gsuite.autoManageContent' bundle='gsuite' />">
						</toggle-control>
					</span>
				</li>
				<!-- Automatic content management --END -->

			</ul>
		</cv-tile-component>
		<!-- General --END -->

		<!-- Connection settings --START -->
		<cv-tile-component
			data-title='<cv:msg key="header.connectionSettings" bundle="gsuite"/>'
			loader="gsuiteAppSettingsCtrl.gsuiteConnectionsLoaded"
		>
			<ul class="list-style-secondary">
				<li class="group">
					<cv-kendo-grid data-cv-grid-options="gsuiteAppSettingsCtrl.gsuiteConnectionsGrid"></cv-kendo-grid>
				</li>
				<div class="page-details-box-links">
					<a data-ng-click="gsuiteAppSettingsCtrl.addGSuiteServiceAccount()">
						<cv:msg key="action.addServiceAccount" bundle="gsuite" />
					</a>
				</div>
		</cv-tile-component>
		<!-- Connection settings --END -->
	</div>

	<div class="col-md-6">
		<!-- Infrastructure settings --START -->
		<cv-tile-component
			data-ac-id="gsuiteAppSettings-header_InfrastructureSettings"
			data-title='<cv:msg key="header.infrastructureSettings" bundle="gsuite"/>'
			loader="gsuiteAppSettingsCtrl.infrastructureSettingsLoaded"
		>
			<ul class="list-style-secondary">

				<!-- Server Plan --START -->
				<li class="group" data-ng-if="gsuiteAppSettingsCtrl.showPlan">
					<span class="pageDetailColumn"><cv:msg key="label.gsuite.serverPlan" bundle="gsuite"/></span>
					<span class="pageDetailColumn">
						<a
							data-ng-click="gsuiteAppSettingsCtrl.redirectToPlanDetails()"
							data-ng-bind="gsuiteAppSettingsCtrl.clientPlan.planName">
						</a>
						<span class="float-right tile-content-link" >
							<a data-ng-click="gsuiteAppSettingsCtrl.editClientPlan(true)">
								<cv:msg key="label.edit" bundle="clients" />
							</a>
						</span>
					</span>
				</li>

				<li class="group no-horizontal-padding" data-ng-if="!gsuiteAppSettingsCtrl.showPlan">
					<span class="pageDetailColumn margin-top-20">
						<cv:msg key="label.gsuite.serverPlan" bundle="gsuite"/>
					</span>
					<span class="pageDetailColumn inline-editor margin-top-20">
						<div class="inline-editor-input">
							<cv-plan-summary-dropdown
								class="full-width"
								data-ng-if="gsuiteAppSettingsCtrl.plansLoaded"
								input-model="gsuiteAppSettingsCtrl.serverPlanList"
								output-model="gsuiteAppSettingsCtrl.selectedPlanList"
								button-label="'planName'"
								item-label="'planName'"
								tick-property="'selected'"
								selection-mode="'single'"
								directive-id="'plans'"
								class="inline-editor-input"
								max-labels="1"
								translation="gsuiteAppSettingsCtrl.localLang"
								disable-property="'disabled'"
								on-item-clicked="gsuiteAppSettingsCtrl.processServerPlanSelection()">
							</cv-plan-summary-dropdown>
						</div>
						<span class="inline-editor-buttons">
							<a
								class="inline-editor-button"
								data-ng-class="{disabled: loading}"
								data-ng-click="gsuiteAppSettingsCtrl.updateClientPlan()">
									<span class="k-icon k-i-check"></span>
							</a>
							<a
								class="inline-editor-button"
								data-ng-class="{disabled: loading}"
								data-ng-click="gsuiteAppSettingsCtrl.editClientPlan(false)">
									<span class="k-icon k-i-x"></span>
							</a>
						</span>
					</span>
				</li>
				<!-- Server Plan --END -->

				<!-- Access Node --START -->
				<li class="group" data-ng-if="gsuiteAppSettingsCtrl.previewAccessNode">
					<span class="pageDetailColumn"><cv:msg key="header.accessNode" bundle="capps"/></span>
					<span class="pageDetailColumn">
						<a
							data-ng-click="gsuiteAppSettingsCtrl.redirectToClientDetails()"
							data-ng-bind="gsuiteAppSettingsCtrl.instanceDetails.backupClient.clientName">
						</a>
						<span class="float-right tile-content-link" >
							<a data-ng-click="gsuiteAppSettingsCtrl.editAccessNode(true)">
								<cv:msg key="label.edit" bundle="clients" />
							</a>
						</span>
					</span>
				</li>

				<li class="group"  data-ng-if="!gsuiteAppSettingsCtrl.previewAccessNode">
					<span class="pageDetailColumn"><cv:msg key="header.accessNode" bundle="capps"/></span>
					<span class="pageDetailColumn inline-editor">
						<div class="inline-editor-input">
							<isteven-multi-select
								input-model="gsuiteAppSettingsCtrl.accessNodesList"
								output-model="gsuiteAppSettingsCtrl.selectedAccessNodeList"
								button-label="clientName"
								item-label="clientName"
								id="accessNodes"
								search-limit="10"
								search-property="clientName"
								selection-mode="single"
								tick-property="selected"
								class="isteven-multi-select user-group-select"
								helper-elements="filter"
								on-item-click="gsuiteAppSettingsCtrl.processAccessNodeSelection()">
							</isteven-multi-select>
						</div>
						<span class="inline-editor-buttons">
							<a
								class="inline-editor-button"
								data-ng-class="{disabled: loading}"
								data-ng-click="gsuiteAppSettingsCtrl.updateInstanceDetails(gsuiteAppSettingsCtrl.gsuiteConstants.editModes.EDIT_ACCESS_NODE)">
									<span class="k-icon k-i-check"></span>
							</a>
							<a
								class="inline-editor-button"
								data-ng-class="{disabled: loading}"
								data-ng-click="gsuiteAppSettingsCtrl.editAccessNode(false)">
									<span class="k-icon k-i-x"></span>
							</a>
						</span>
					</span>
				</li>
				<!--Access Node --END -->

				<!-- Client Readiness --START -->
				<cv-client-readiness-status
					data-ng-if="gsuiteAppSettingsCtrl.clientReadinessLoaded"
					client-id="{{gsuiteAppSettingsCtrl.clientId}}"
					client-readiness="gsuiteAppSettingsCtrl.clientReadiness">
				</cv-client-readiness-status>
				<!-- Client Readiness --END -->
			</ul>
		</cv-tile-component>
		<!-- Infrastructure settings --END -->

		<!-- Activity control --START -->
		<cv-activity-control-component
			data-ac-params="gsuiteAppSettingsCtrl.activityControlParams"
		></cv-activity-control-component>
		<!-- Activity control --END -->

		<!-- Security --START -->
		<div data-ng-if="gsuiteAppSettingsCtrl.formattedSecurityAssociations">
			<cv-security-component
				entity-type='gsuiteAppSettingsCtrl.entityType'
				generic-entity='gsuiteAppSettingsCtrl.genericEntity'
				associations='gsuiteAppSettingsCtrl.formattedSecurityAssociations'
				associations-loaded='gsuiteAppSettingsCtrl.associationsLoaded'
				show-owners='true'
			></cv-security-component>
		</div>
		<!-- Security --END -->
	</div>
</div>