<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
	<div data-ng-if="syncDbCtrl.syncDatabase.dbEnabled || syncDbCtrl.alwaysEnable">

		<div class="form-group" data-ng-class="{'{{syncDbCtrl.formGroupClass}}' : syncDbCtrl.formGroupClass}">
			<div class="col-xs-12 col-sm-5" data-ng-class="{'{{syncDbCtrl.labelClass}}' : syncDbCtrl.labelClass}">
				<label>
					<cv:msg key="label.databaseType" bundle="capps"/>
				</label>
			</div>
			<div class="col-xs-12 col-sm-7" data-ng-class="{'{{syncDbCtrl.inputClass}}' : syncDbCtrl.inputClass}">
				<cv-isteven-single-select id-name="addSfDbType_isteven-multi-select"
								input-model="syncDbCtrl.databaseTypes"
								binding-model="syncDbCtrl.syncDatabase.dbType"
								binding-field="name"
								track-field="name" 
								label="name"
								tick-property="selected" 
								disable-property="disabled"
								data-helper-elements="filter"
								on-change="syncDbCtrl.dbTypeChanged()"
								>
				</cv-isteven-single-select>
				<span class="cv-help-block" data-ng-show="(syncDbCtrl.submitAttempted && !syncDbCtrl.syncDatabase.dbType.length)">
					<cv:msg key="error.databaseType" bundle="capps"/>
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-class="{'{{syncDbCtrl.formGroupClass}}' : syncDbCtrl.formGroupClass}">
			<div class="col-xs-12 col-sm-5" data-ng-class="{'{{syncDbCtrl.labelClass}}' : syncDbCtrl.labelClass}">
				<label>
					<cv:msg key="label.databaseHost" bundle="capps"/>
				</label>
			</div>
			<div class="col-xs-12 col-sm-7" data-ng-class="{'{{syncDbCtrl.inputClass}}' : syncDbCtrl.inputClass}">
				<input name="databaseHost" class="full-text" type="text" data-ng-model="syncDbCtrl.syncDatabase.dbHost" data-ng-change="syncDbCtrl.dbHostChanged()" required list="databaseHostList" placeholder='<cv:msg key="placeholder.typeOrSelect" bundle="capps"/>'/>
				<datalist id="databaseHostList">
					<option data-ng-repeat="dbClient in syncDbCtrl.databaseClients track by dbClient.clientId">
						{{dbClient.hostName}}
					</option>
				</datalist>
				<span class="cv-help-block" data-ng-show="submitController.needsAttention(formController.databaseHost)">
					<cv:msg key="error.databaseHost" bundle="capps"/>
				</span>
			</div>
		</div>

		<div class="form-group" data-ng-if="syncDbCtrl.syncDatabase.dbType == 'SQLSERVER'" data-ng-class="{'{{syncDbCtrl.formGroupClass}}' : syncDbCtrl.formGroupClass}">
			<div class="col-xs-12 col-sm-5" data-ng-class="{'{{syncDbCtrl.labelClass}}' : syncDbCtrl.labelClass}">
				<label>
					<cv:msg key="label.serverInstanceName" bundle="capps"/>
				</label>
			</div>
			<div class="col-xs-12 col-sm-7" data-ng-class="{'{{syncDbCtrl.inputClass}}' : syncDbCtrl.inputClass}">
				<input name="serverInstanceName" class="full-text" type="text" data-ng-model="syncDbCtrl.syncDatabase.dbInstance" required list="databaseInstanceList" placeholder='<cv:msg key="placeholder.typeOrSelect" bundle="capps"/>'/>
				<datalist id="databaseInstanceList">
					<option data-ng-repeat="dbInstance in syncDbCtrl.databaseInstances track by dbInstance.instanceId">
						{{dbInstance.instanceName}}
					</option>
				</datalist>
				<span class="cv-help-block" data-ng-show="submitController.needsAttention(formController.serverInstanceName)">
					<cv:msg key="error.serverInstanceName" bundle="capps"/>
				</span>
			</div>
		</div>

		<div class="form-group" data-ng-if="!syncDbCtrl.hideDatabaseName" data-ng-class="{'{{syncDbCtrl.formGroupClass}}' : syncDbCtrl.formGroupClass}">
			<div class="col-xs-12 col-sm-5" data-ng-class="{'{{syncDbCtrl.labelClass}}' : syncDbCtrl.labelClass}">
				<label>
					<cv:msg key="label.databaseName" bundle="capps"/>
				</label>
			</div>
			<div class="col-xs-12 col-sm-7" data-ng-class="{'{{syncDbCtrl.inputClass}}' : syncDbCtrl.inputClass}">
				<input name="databaseName" class="full-text" type="text" data-ng-model="syncDbCtrl.syncDatabase.dbName" required placeholder='<cv:msg key="label.databaseName" bundle="capps"/>'/>
				<span class="cv-help-block" data-ng-show="submitController.needsAttention(formController.databaseName)">
					<cv:msg key="error.databaseName" bundle="capps"/>
				</span>
			</div>
		</div>

		<div class="form-group" data-ng-class="{'{{syncDbCtrl.formGroupClass}}' : syncDbCtrl.formGroupClass}">
			<div class="col-xs-12 col-sm-5" data-ng-class="{'{{syncDbCtrl.labelClass}}' : syncDbCtrl.labelClass}">
				<label>
					<cv:msg key="label.databasePort" bundle="capps"/>
				</label>
			</div>
			<div class="col-xs-12 col-sm-7" data-ng-class="{'{{syncDbCtrl.inputClass}}' : syncDbCtrl.inputClass}">
				<input name="databasePort" class="full-text" type="text" data-ng-model="syncDbCtrl.syncDatabase.dbPort" required data-ng-pattern="'\\d+'" placeholder='<cv:msg key="label.databasePort" bundle="capps"/>'/>
				<span class="cv-help-block" data-ng-show="submitController.needsAttention(formController.databasePort)">
					<cv:msg key="error.databasePortInvalid" bundle="capps"/>
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-class="{'{{syncDbCtrl.formGroupClass}}' : syncDbCtrl.formGroupClass}">
			<div class="col-xs-12 col-sm-5" data-ng-class="{'{{syncDbCtrl.labelClass}}' : syncDbCtrl.labelClass}">
				<label>
					<cv:msg key="label.userName" bundle="servers"/>
				</label>
			</div>
			<div class="col-xs-12 col-sm-7" data-ng-class="{'{{syncDbCtrl.inputClass}}' : syncDbCtrl.inputClass}">
				<input name="dbUserName" class="full-text" type="text" data-ng-model="syncDbCtrl.syncDatabase.dbUserPassword.userName" required placeholder='<cv:msg key="label.userName" bundle="servers"/>'/>
				<span class="cv-help-block" data-ng-show="submitController.needsAttention(formController.dbUserName)">
					<cv:msg key="error.dbUserName" bundle="capps"/>
				</span>
			</div>
		</div>

		<div class="form-group" data-ng-class="{'{{syncDbCtrl.formGroupClass}}' : syncDbCtrl.formGroupClass}">
			<div class="col-xs-12 col-sm-5" data-ng-class="{'{{syncDbCtrl.labelClass}}' : syncDbCtrl.labelClass}">
				<label>
					<cv:msg key="label.password" bundle="users"/>
				</label>
			</div>
			<div class="col-xs-12 col-sm-7" data-ng-class="{'{{syncDbCtrl.inputClass}}' : syncDbCtrl.inputClass}">
				<input name="dbPassword" class="full-text" type="password" data-ng-model="syncDbCtrl.dbPassword" placeholder='<cv:msg key="label.password" bundle="users"/>' data-ng-required="!syncDbCtrl.allowEmptyPassword()" data-ng-change="syncDbCtrl.dbPasswordChanged()"/>
				<span class="cv-help-block" data-ng-show="submitController.needsAttention(formController.dbPassword)">
					<cv:msg key="error.password" bundle="users"/>
				</span>
			</div>
		</div>

		<div class="form-group text-right" data-ng-if="!syncDbCtrl.hideTestConnection" data-ng-class="{'{{syncDbCtrl.formGroupClass}}' : syncDbCtrl.formGroupClass}">
			<div class="col-xs-12">
				<button id="syncDatabase_button_#9337" type="button" data-ng-click="syncDbCtrl.validateSalesforceDbConnection()" class="btn btn-default pull-right cvBusyOnAjax" data-ng-disabled="!syncDbCtrl.enableValidateSalesforceDbConnection()">
					<cv:msg key="label.testConnection" bundle="capps" />
				</button>
			</div>
		</div>
	</div>