<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>

<!-- Environment-->
<div class="form-group">
    <label class="col-xs-12 col-md-3" for="sfEnvironmentType"><cv:msg
            key="label.environment" bundle="capps" /></label>
    <div class="col-xs-12 col-md-9">
        <cv-isteven-single-select id-name="sfEnvironmentType"
			input-model="sfAccountDetailsCtrl.environmentType"
			binding-model="sfAccountDetailsCtrl.salesforceAccount.environment"
			track-field="name" label="name"
			tick-property="selected" disable-property="disabled"
			on-change="sfAccountDetailsCtrl.clickEnvironment(sfAccountDetailsCtrl.salesforceAccount.environment)">
		</cv-isteven-single-select>
        <div class="help-block"
            data-ng-if="addSfOrganizationForm.$submitted"
            data-ng-show="sfAccountDetailsCtrl.salesforceAccount.environmentType === undefined">
            <cv:msg key="error.environment" bundle="capps" />
        </div>
    </div>
</div>
<!-- Environment end-->
<!-- Authentication-->
<div class="form-group">
    <label class="col-xs-12 col-md-3" for="connectionDetails"><cv:msg
        key="label.connectionDetails" bundle="exchange" /></label>
    <div class="col-xs-12 col-md-9">
        <cv-radio-group
            radio-model="sfAccountDetailsCtrl.salesforceAccount.authenticationType" 
            radio-obj="sfAccountDetailsCtrl.salesforceAccount.authenticationTypeOptions"
            on-click="sfAccountDetailsCtrl.sfOrgCreationAuthValChange(data)">
        </cv-radio-group>
    </div>
</div>
<!-- Authentication end-->

<div data-ng-if="sfAccountDetailsCtrl.oAuth">
    <div id="crednetialManager" data-ng-if="(sfAccountDetailsCtrl.salesforceAccount.planSelected && !sfAccountDetailsCtrl.salesforceAccount.isResourcePoolConfigured && !sfAccountDetailsCtrl.isSalesforceSaaSTenant) || (sfAccountDetailsCtrl.isEdit && !sfAccountDetailsCtrl.isSalesforceSaaSTenant)">
        <cv-credential-manager model="sfAccountDetailsCtrl.model" show-credential="{{sfAccountDetailsCtrl.showCredential}}" input-name="sfAccountDetailsCtrl.sfCredentials" password-complexity="1" form-name="addSfOrganizationForm" need-confirm=false label-class="sfAccountDetailsCtrl.labelClass" input-class="sfAccountDetailsCtrl.inputClass"></cv-credential-manager>
    </div>
    <div class="form-group margin-top-10">
        <div class="col-xs-12 col-md-3"></div>
        <div class="col-xs-12 col-md-9">
            <button id="loginSalesforce" type="button" data-ng-click="sfAccountDetailsCtrl.loginWithSalesforce()" class="btn btn-primary pull-left cvBusyOnAjax" data-ng-disabled="sfAccountDetailsCtrl.disableLoginSalesforce()"> 
                <cv:msg key="label.loginWithSalesforce" bundle="capps" />
            </button>
            <span data-ng-if="sfAccountDetailsCtrl.sfAuthenticated" class="col-md-1 col-sm-1" title='<cv:msg key="title.sfAuthenticated" bundle="capps"/>'><img data-ng-src="{{sfAccountDetailsCtrl.imgSrc}}"/></span>
            <div class="help-block"
                data-ng-if="addSfOrganizationForm.$submitted"
                data-ng-show="!sfAccountDetailsCtrl.salesforceAccount.token">
                <cv:msg key="error.sfLogin" bundle="capps" />
            </div>
            <div class="help-block"
                data-ng-if="sfAccountDetailsCtrl.sfLoginFailed">
                <cv:msg key="error.salesforceLoginFailed" bundle="capps" />
            </div>
        </div>
    </div>
</div>
<!-- Password auhtentication start-->
<div data-ng-if="sfAccountDetailsCtrl.passwordAuthentication">
    <!-- End point-->
    <div class="form-group">
        <label class="col-xs-12 col-md-3" for="salesforceLoginUrl" >
                <cv:msg key="label.salesforceLoginUrl" bundle="capps" />
        </label>
        <div class="col-xs-12 col-md-9">
            <input type="text" name="salesforceLoginUrl" id="salesforceLoginUrl" data-ng-model="sfAccountDetailsCtrl.salesforceAccount.endpoint" data-ng-pattern="sfAccountDetailsCtrl.REGEX.SALEFORCE_LOGIN_URL" required placeholder='<cv:msg key="label.salesforceLoginUrl" bundle="capps" />' />
            <span class="help-block" data-ng-show="submitController.needsAttention(formController.salesforceLoginUrl)">
                <cv:msg key="error.salesforceLoginUrl" bundle="capps" />
            </span>
        </div>
    </div>
    <!-- End Point end-->
    <!-- user name-->
    <div class="form-group">
        <label class="col-xs-12 col-md-3" for="username"><cv:msg
                key="label.username" bundle="capps" /></label>
        <div class="col-xs-12 col-md-9">
            <input type="text" name="username" id="username"
                placeholder='<cv:msg key="label.username" bundle="capps"/>'
                data-ng-model="sfAccountDetailsCtrl.salesforceAccount.userCredentials.userName"
                required autofocus />
            <span class="help-block" data-ng-show="submitController.needsAttention(formController.username)">
                <cv:msg key="error.dbUserName" bundle="capps"/>
            </span>
        </div>
    </div>
    <!-- user name end-->
    <!-- password-->
    <div class="form-group">
        <label class="col-xs-12 col-md-3" for="password"><cv:msg
                key="label.password" bundle="capps" /></label>
        <div class="col-xs-12 col-md-9">
            <input type="password" name="password" id="password"
                placeholder='{{sfAccountDetailsCtrl.passwordHelptext}}'
                data-ng-model="sfAccountDetailsCtrl.salesforceAccount.userCredentials.password"
                data-ng-required="{{!sfAccountDetailsCtrl.isEdit}}" autofocus />
                <span class="help-block" data-ng-show="!sfAccountDetailsCtrl.isEdit && submitController.needsAttention(formController.password)">
                    <cv:msg key="error.password" bundle="capps"/>
                </span>
        </div>
    </div>
    <!-- password end-->
    <!-- API Token-->
    <div class="form-group">
        <label class="col-xs-12 col-md-3" for="apiToken"><cv:msg key="label.apiToken" bundle="capps" />
                <span class="optional-text"><cv:msg key="label.optional" bundle="restore" /></span>
        </label>
        <div class="col-xs-12 col-md-9">
            <input type="password" name="apiToken" id="apiToken"
                placeholder='{{sfAccountDetailsCtrl.apiTokenHelpText}}'
                data-ng-model="sfAccountDetailsCtrl.salesforceAccount.token" autofocus />
        </div>
    </div>
    <!-- API Token end-->
    <!-- consumerKey-->
    <div class="form-group">
        <label class="col-xs-12 col-md-3" for="consumerKey"><cv:msg
                key="label.consumerKey" bundle="capps" /></label>
        <div class="col-xs-12 col-md-9">
            <input type="text" name="consumerKey" id="consumerKey"
                placeholder='<cv:msg key="label.consumerKey" bundle="capps"/>'
                data-ng-model="sfAccountDetailsCtrl.salesforceAccount.consumerId"
                required autofocus />
                <span class="help-block" data-ng-show="submitController.needsAttention(formController.consumerKey)">
                    <cv:msg key="error.consumerKey" bundle="capps"/>
                </span>
        </div>
    </div>
    <!-- consumerKey end-->
    <!-- consumerSecret-->
    <div class="form-group">
        <label class="col-xs-12 col-md-3" for="consumerSecret"><cv:msg
                key="label.consumerSecret" bundle="capps" /></label>
        <div class="col-xs-12 col-md-9">
            <input type="password" name="consumerSecret" id="consumerSecret"
                placeholder='{{sfAccountDetailsCtrl.consumerSecretHelpText}}'
                data-ng-model="sfAccountDetailsCtrl.salesforceAccount.consumerSecret"
                data-ng-required="{{!sfAccountDetailsCtrl.isEdit}}" autofocus />
                <span class="help-block" data-ng-show="!sfAccountDetailsCtrl.isEdit && submitController.needsAttention(formController.consumerSecret)">
                    <cv:msg key="error.consumerSecret" bundle="capps"/>
                </span>
        </div>
    </div>
    <!-- consumerSecret end--> 
    <div class="form-group">
        <div class="col-xs-12 text-right">
            <button id="cappsConfigurationSF" type="button" data-ng-click="sfAccountDetailsCtrl.validateSalesforceConnection()" class="btn btn-default pull-right cvBusyOnAjax" data-ng-disabled="!sfAccountDetailsCtrl.enableValidateSalesforceConnection()"> 
                <cv:msg key="label.testConnection" bundle="capps" />
            </button>
        </div>
    </div>																	
</div>
