<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="label.editPlan" bundle="profiles"/></h1>
</div>
<div class="setup-content">
	<div class="{{editPlan.editPlanServerMessage.type}} serverMessage">{{editPlan.editPlanServerMessage.message}}</div>
	<form id="editPlanForm" name="editPlanForm" data-cv-submit="editPlan.savePlanForClient()" novalidate autocomplete="off">
		<div class="cv-modal-wrapper" data-ng-show="editPlan.planList && editPlan.planList.length">
				
						<label for="plan" class="select-label add-server">
							<cv:msg key="label.plan" bundle="capps"/>
							<select name="plan"
							data-ng-options="profile as profile.planName for profile in editPlan.planList | orderBy: 'planName'"
							data-ng-model="editPlan.selectedPlan" required>
								<option value=""><cv:msg key="placeholder.plan" bundle="capps"/></option>
							</select>
							<span class="help-block" data-ng-show="cv.editPlanForm.needsAttention(editPlanForm.plan)"><cv:msg key="error.plan" bundle="capps"/></span>
						</label>
		</div>
		
		<div class="button-container">
			<button id="editPlanClient_button_#1664" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="editPlan.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
			<button id="editPlanClient_button_#3864" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="action.save" bundle="profiles"/></button> 
		</div>
	</form>
</div>
