<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1> <cv:msg key="label.crossAccountOperations" bundle="capps"/></h1>
	</div>
	<span class="{{cappsCrossAccountDest.serverMessage.type}}" data-ng-bind="cappsCrossAccountDest.serverMessage.message"></span>
	<form name="cappsAccountOperationsForm" class="form-horizontal" novalidate data-cv-submit="cappsCrossAccountDest.ok()" autocomplete="off">
		<div class="panel">
		<div class="panel-body">
			<div class="form-group">
				<label for="destinationAccount" class="col-xs-12 col-sm-5">
					<cv:msg key="label.chooseAction" bundle="capps"/>
				</label>
				<div class="col-xs-12 col-sm-4">
					<input type="radio" name="shareOnly" id="shareOnly" data-ng-model="cappsCrossAccountDest.model.copyType" value="1">
					<label for="shareOnly">
						<cv-help-text help-label="<cv:msg key="label.shareOnly" bundle="capps"/>" help-text="'<cv:msg key="help.shareOnly" bundle="capps"/>'"></cv-help-text>
					</label>
				</div>
				<div class="col-xs-12 col-sm-3">
					<input type="radio" name="fullCopy" id="fullCopy" data-ng-model="cappsCrossAccountDest.model.copyType" value="2">
					<label for="fullCopy">
						<cv-help-text help-label="<cv:msg key="label.fullCopy" bundle="capps"/>" help-text="'<cv:msg key="help.fullCopy" bundle="capps"/>'"></cv-help-text>
					</label>
				</div>
			</div>
			<div class="form-group">
				<label for="destinationAccount" class="col-xs-12 col-sm-5">
					<cv:msg key="label.destinationAccount" bundle="capps"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<div class="input-group" >
					 <isteven-multi-select id="accountList"
					 	directive-id="destinationAccount"
						input-model="cappsCrossAccountDest.model.accountList"
						output-model="cappsCrossAccountDest._selectedAccount"
						button-label="clientName"
						item-label="clientName"
						translation="cappsCrossAccountDest.localLangAccountList"
						tick-property="selected"
						helper-elements="filter"
						selection-mode="single"
						is-required="true"
						class="isteven-multi-select user-group-select"
						on-close="cappsCrossAccountDest.accountChanged()"
						/>
							<span class="input-group-btn" >
								<label data-ng-if="!cappsCrossAccountDest.model.isRDSInstance">.</label>
								<a  data-ng-if="cappsCrossAccountDest.model.isRDSInstance" class="btn btn-ternary rounded-border-radius"
									data-ng-click="cappsCrossAccountDest.openAddRDSInstanceDialog()" title="<cv:msg key="label.addRDSInstanceMsg" bundle="capps"/>">
									<span class="k-icon k-i-plus font-size-page-title"> </span>
								</a>
							</span>
						</div>
					<span class="help-block" data-ng-show="cv.cappsAccountOperationsForm.needsAttention(cappsAccountOperationsForm.destinationAccount)">
						<cv:msg key="label.selectDestinationAccount" bundle="capps"/>
					</span>
				</div>
			</div>
		</div>
		</div>
		<div class="modal-footer">
			<button id="cappsCrossAccountDest_CancelButton" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cappsCrossAccountDest.cancel()">
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<button id="cappsCrossAccountDest_OkButton" class="btn btn-primary cvBusyOnAjax" type="submit" >
				<cv:msg key="OK" bundle="messages"/>
			</button>
		</div>
	</form>
</div>
