<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@  taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div data-ng-controller = "salesforceRestoreTypesController as sfRTCtrl">
	<h1 data-ng-if="!sfRTCtrl.isCompare"><cv:msg key="label.selectRestoreType" bundle="restore" /></h1>
	<h1 data-ng-if="sfRTCtrl.isCompare"><cv:msg key="label.selectCompareType" bundle="capps" /></h1>
	<span class="server-message {{sfRTCtrl.serverMessage.type}}" data-ng-bind="sfRTCtrl.serverMessage.message"></span>
	
	<ul id="restore-Options" data-ng-if="sfRTCtrl.backupsetLoaded && sfRTCtrl.subclientLoaded">
		<li >
			<a href="{{sfRTCtrl.getObjectLevelRestoreUrl()}}" data-ng-if="!sfRTCtrl.isCompare">
				<img src="${pageContext.request.contextPath}/img/salesforce_restore_object_level.png" />
				<div class="restore-type-names"><cv:msg key="label.objectLevelRestore" bundle="capps" /></div>
				<div class="restore-type-details"><cv:msg key="label.objectLevelRestoreDetails" bundle="capps" /></div>
			</a>
			
			<a href="{{sfRTCtrl.getObjectLevelRestoreUrl()}}" data-ng-if="sfRTCtrl.isCompare && sfRTCtrl.backupsetProp.cloudAppsBackupset.salesforceBackupSet.syncDatabase.dbEnabled">
				<img src="${pageContext.request.contextPath}/img/salesforce_restore_object_level.png" />
				<div class="restore-type-names"><cv:msg key="label.objectCompare" bundle="capps" /></div>
				<div class="restore-type-details"><cv:msg key="label.objectCompareNote" bundle="capps" /></div>
			</a>
			<div class="disabled-link" data-ng-if="sfRTCtrl.isCompare && !sfRTCtrl.backupsetProp.cloudAppsBackupset.salesforceBackupSet.syncDatabase.dbEnabled">
				<img src="${pageContext.request.contextPath}/img/salesforce_restore_object_level.png" />
				<div class="restore-type-names"><cv:msg key="label.objectCompare" bundle="capps" /></div>
				<div class="restore-type-details"><cv:msg key="label.objectCompareNote" bundle="capps" />
				<br> 
				<cv:msg key="label.recordLevelRestoreDetailsNote" bundle="capps" />
				</div>
			</div>
			
			
		</li>
		<!-- Hide for non default subclient -->
		<li data-ng-if="sfRTCtrl.subclientProp.commonProperties.isDefaultSubclient && !sfRTCtrl.isCompare">
			<a data-ng-if="sfRTCtrl.backupsetProp.cloudAppsBackupset.salesforceBackupSet.syncDatabase.dbEnabled" href="{{sfRTCtrl.getRecordLevelRestoreUrl()}}">
				<img src="${pageContext.request.contextPath}/img/salesforce_restore_record_level.png" />
				<div class="restore-type-names"><cv:msg key="label.recordLevelRestore" bundle="capps" /></div>
				<div class="restore-type-details"><cv:msg key="label.recordLevelRestoreDetails" bundle="capps" />
				</div>
			</a>
			<!-- Show but disable if sync db is not enabled -->
			<div class="disabled-link" data-ng-if="!sfRTCtrl.backupsetProp.cloudAppsBackupset.salesforceBackupSet.syncDatabase.dbEnabled">
				<img src="${pageContext.request.contextPath}/img/salesforce_restore_record_level.png" />
				<div class="restore-type-names"><cv:msg key="label.recordLevelRestore" bundle="capps" /></div>
				<div class="restore-type-details"><cv:msg key="label.recordLevelRestoreDetails" bundle="capps" />
				<br> 
				<cv:msg key="label.recordLevelRestoreDetailsNote" bundle="capps" />
				</div>
			</div>
		</li>
		<li >
			<!-- Disable metadata compare/restore if metadata backup is not enabled -->
			<div class="disabled-link" data-ng-if="!sfRTCtrl.subclientProp.cloudAppsSubClientProp.salesforceSubclient.backupSFMetadata">
				<img src="${pageContext.request.contextPath}/img/salesforce_restore_metadata.png" />
				<div data-ng-if="!sfRTCtrl.isCompare" class="restore-type-names"><cv:msg key="label.metadataRestore" bundle="capps" /></div>
				<div data-ng-if="!sfRTCtrl.isCompare" class="restore-type-details"><cv:msg key="label.metadataRestoreDetails" bundle="capps" />
					<br> 
					<cv:msg key="label.metadataRestoreNote" bundle="capps" />
				</div>
				<div data-ng-if="sfRTCtrl.isCompare" class="restore-type-names"><cv:msg key="label.metadataCompare" bundle="capps" /></div>
				<div data-ng-if="sfRTCtrl.isCompare" class="restore-type-details"><cv:msg key="label.metadataCompareNote" bundle="capps" />
					<br> 
					<cv:msg key="label.metadataRestoreNote" bundle="capps" />
				</div>
			</div>
			<a href="{{sfRTCtrl.getMetadataRestoreUrl()}}" data-ng-if="sfRTCtrl.subclientProp.cloudAppsSubClientProp.salesforceSubclient.backupSFMetadata">
				<img src="${pageContext.request.contextPath}/img/salesforce_restore_metadata.png" />
				<div data-ng-if="!sfRTCtrl.isCompare" class="restore-type-names"><cv:msg key="label.metadataRestore" bundle="capps" /></div>
				<div data-ng-if="!sfRTCtrl.isCompare" class="restore-type-details"><cv:msg key="label.metadataRestoreDetails" bundle="capps" /></div>
				<div data-ng-if="sfRTCtrl.isCompare" class="restore-type-names"><cv:msg key="label.metadataCompare" bundle="capps" /></div>
				<div data-ng-if="sfRTCtrl.isCompare" class="restore-type-details"><cv:msg key="label.metadataCompareNote" bundle="capps" /></div>
			</a>
		</li>
		
		<!-- Hide for non default subclient -->
		<li data-ng-if="sfRTCtrl.subclientProp.commonProperties.isDefaultSubclient && !sfRTCtrl.isCompare">
			<a data-ng-if="sfRTCtrl.backupsetProp.cloudAppsBackupset.salesforceBackupSet.syncDatabase.dbEnabled" href="{{sfRTCtrl.getSandboxSeedingUrl()}}">
				<img src="${pageContext.request.contextPath}/img/salesforce_restore_sandbox_seeding.png" />
				<div class="restore-type-names"><cv:msg key="label.sandboxSeeding" bundle="capps" /></div>
				<div class="restore-type-details"><cv:msg key="label.sandboxSeedingDetails" bundle="capps" />
				</div>
			</a>
			<!-- Show but disable if sync db is not enabled -->
			<div class="disabled-link" data-ng-if="!sfRTCtrl.backupsetProp.cloudAppsBackupset.salesforceBackupSet.syncDatabase.dbEnabled">
				<img src="${pageContext.request.contextPath}/img/salesforce_restore_sandbox_seeding.png" />
				<div class="restore-type-names"><cv:msg key="label.sandboxSeeding" bundle="capps" /></div>
				<div class="restore-type-details"><cv:msg key="label.sandboxSeedingDetails" bundle="capps" />
				<br> 
				<cv:msg key="label.recordLevelRestoreDetailsNote" bundle="capps" />
				</div>
			</div>
		</li>
	</ul>
</div>