<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div data-ng-init="leftGrid=['col-xs-12', 'col-lg-5']"></div>
<div data-ng-init="rightGrid=['col-xs-12', 'col-lg-7']"></div>
<div data-ng-class="{'limited-width-container': !sfRestore.isModal}">
	<div class="bootstrap-wrapper" data-ng-class="{'modal-dialog': sfRestore.isModal}" >
		<div data-ng-class="{'col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2': !sfRestore.isModal}">
			<div data-ng-if="sfRestore.isModal" class="setup-title">
				<h1><span> <cv:msg key="label.restoreOpts" bundle="restore"/> </span></h1>
			</div>
			<div data-ng-if="!sfRestore.isModal">
				<h1 class="page-header"><cv:msg key="label.salesforceRestoreOpts" bundle="capps"/></h1>
			</div>
			<span class="serverMessage {{sfRestore.serverMessage.type}}" data-ng-bind="sfRestore.serverMessage.message"></span>
				<form class="form-horizontal" novalidate name="salesforceRestoreForm" autocomplete="off" cv-submit="sfRestore.doRestoreWrapper()">
					<div data-ng-init="sfRestore.setForm(salesforceRestoreForm, cv.salesforceRestoreForm);"> <!-- data-ng-class="{'modal-body': sfRestore.isModal}" -->
						<!--  RESTORE TARGET PANEL -->
						<div class="panel panel-default" data-ng-if="!sfRestore.isSaaS && !sfRestore.isSandboxSeeding()">
							<div class="panel-body">
								<div class="form-group">
									<div data-ng-class="leftGrid" >
										<label><cv:msg key="label.restoreTarget" bundle="capps"/></label>
									</div>
									<div data-ng-class="rightGrid">
										<div data-ng-if="!sfRestore.showTargetRadioOptions()">
											<label><cv:msg key="label.clientType.salesforce" bundle="capps"/></label>
										</div>
										<div data-ng-if="sfRestore.showTargetRadioOptions()">
											<div class="checkbox-inline">
												<input name="restoreTarget" type="radio" data-ng-model="sfRestore.restoreData.globalOptions.restoreTarget" data-ng-change="sfRestore.restoreTargetChanged()" value="Salesforce Instance"/>
												<label>
													<cv:msg key="label.clientType.salesforce" bundle="capps"/>
												</label>
											</div>
											<div class="checkbox-inline" data-ng-if="!sfRestore.isRecordRestore() && !sfRestore.isMetadataRestore()">
												<input name="restoreTarget" type="radio"  data-ng-model="sfRestore.restoreData.globalOptions.restoreTarget" data-ng-change="sfRestore.restoreTargetChanged()" value="Database"/>
												<label>
													<cv:msg key="label.database" bundle="capps"/>
												</label>
											</div>
											<div class="checkbox-inline" data-ng-if="sfRestore.showFsRestore()">
												<input name="restoreTarget" type="radio" data-ng-model="sfRestore.restoreData.globalOptions.restoreTarget" data-ng-change="sfRestore.restoreTargetChanged()" value="File System"/>
												<label>
													<cv:msg key="label.fileSystem" bundle="capps"/>
												</label>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
						<!--  RESTORE DETAILS PANEL -->
						<uib-accordion close-others="false" class="text-left" data-ng-init="sfRestore.openDestinationSection=true" data-ng-if="!sfRestore.isSaaS && !sfRestore.isDbRestore()">
							<div uib-accordion-group data-is-open="sfRestore.openDestinationSection" >
								<uib-accordion-heading> <cv:msg key="label.destinationDetails" bundle="capps"/><i
									class="float-right glyphicon"
									data-ng-class="sfRestore.openDestinationSection ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right'"></i></uib-accordion-heading>
								<div class="form-group">
									<div data-ng-class="leftGrid" >
										<label data-ng-if="sfRestore.isSfRestore()"><cv:msg key="label.destinationOrganization" bundle="capps"/></label>
										<label data-ng-if="!sfRestore.isSfRestore()"><cv:msg key="label.destHost" bundle="capps"/></label>
									</div>
									<div data-ng-class="rightGrid">
										<select name="DestClient" data-ng-model="sfRestore.restoreData.globalOptions.destinationServer" data-ng-change="sfRestore.destinationServerChanged()" data-ng-options="server.clientName for server in sfRestore.restoreData.globalOptions.destinationServerList" required>
										</select>
										<span class="help-block" data-ng-show="salesforceRestoreForm.$submitted && salesforceRestoreForm.DestClient.$error.required">
											<span data-ng-if="sfRestore.isSfRestore()"><cv:msg key="error.destinationOrganization" bundle="capps"/></span>
											<span data-ng-if="!sfRestore.isSfRestore()"><cv:msg key="error.destHost" bundle="capps"/></span>
										</span>
									</div>
								</div>
								<div class="form-group" data-ng-show="sfRestore.restoreData.globalOptions.restoreTarget == 'Salesforce Instance' && sfRestore.restoreData.globalOptions.destinationInstanceList.length > 1">
									<div data-ng-class="leftGrid">
										<label>
											<cv:msg key="label.destinationInstance" bundle="restore"/>
										</label>
									</div>
									<div data-ng-class="rightGrid">
										<select name="DestInstance" data-ng-model="sfRestore.restoreData.globalOptions.destinationInstance" data-ng-change="sfRestore.destinationInstanceChanged()" data-ng-options="instance.instance.instanceName for instance in sfRestore.restoreData.globalOptions.destinationInstanceList" data-ng-required="sfRestore.isSfRestore()">
										</select>
										<span class="help-block" data-ng-show="salesforceRestoreForm.$submitted && salesforceRestoreForm.DestInstance.$error.required">
											<cv:msg key="error.DestinationInstance" bundle="restore"/>
										</span>
									</div>
								</div>
								<div class="form-group" data-ng-show="sfRestore.restoreData.globalOptions.restoreTarget == 'Salesforce Instance' && sfRestore.restoreData.globalOptions.destinationBackupsetList.length > 1">
									<div data-ng-class="leftGrid">
										<label>
											<cv:msg key="label.destinationBackupset" bundle="capps"/>
										</label>
									</div>
									<div data-ng-class="rightGrid">
										<select name="DestBackupset" data-ng-model="sfRestore.restoreData.globalOptions.destinationBackupset" data-ng-change="sfRestore.destinationBackupsetChanged()"
														data-ng-options="backupset.backupSetEntity.backupsetName for backupset in sfRestore.restoreData.globalOptions.destinationBackupsetList" data-ng-required="sfRestore.isSfRestore()">
										</select>
										<span class="help-block" data-ng-show="salesforceRestoreForm.$submitted && salesforceRestoreForm.DestBackupset.$error.required">
											<cv:msg key="error.destinationBackupset" bundle="capps"/>
										</span>
									</div>
								</div>
								
								<div class="form-group" data-ng-if="sfRestore.restoreData.globalOptions.restoreTarget == 'File System'">
									<div data-ng-class="leftGrid">
										<label class="storage-path-label" for="destinationPath">
											<cv:msg key="label.destinationPath" bundle="capps"/>
										</label>
									</div>
									<div data-ng-class="rightGrid">
										<div class="input-group">
											<input type="text" name="destinationPath" data-ng-model="sfRestore.restoreData.globalOptions.destinationPath" required/>
											<span class="input-group-btn">
												<button id="cappsRestoreOptionsSF_button_#3930" type="button" data-ng-click="sfRestore.browseDestinationPath()" class="btn btn-default browse-btn" data-ng-disabled="sfRestore.shouldDisableBrowse()"> 
													<cv:msg key="label.browse" bundle="restore"/>
												</button>
											</span>
										</div>
										<span class="help-block" data-ng-show="salesforceRestoreForm.$submitted && salesforceRestoreForm.destinationPath.$error.required">
											<cv:msg key="error.destinationPath" bundle="capps"/>
										</span>
									</div>

								</div>

							</div>
						</uib-accordion>
						<!-- SAAS DESTINATION PANEL -->
						<div class="panel panel-default" data-ng-if="sfRestore.isSaaS">
							<div class="panel-body">
								<div class="form-group">
									<div data-ng-class="leftGrid" >
										<label><cv:msg key="label.destinationOrganization" bundle="capps"/></label>
									</div>
									<div data-ng-class="rightGrid">
										<select name="destOrg" data-ng-model="sfRestore.model.destinationOrg" data-ng-options="org.entity.instanceName for org in sfRestore.destinationOrgs" required>
										</select>
										<span class="help-block" data-ng-show="cv.salesforceRestoreForm.needsAttention(salesforceRestoreForm.destOrg)">
											<cv:msg key="error.destinationOrganization" bundle="capps"/>
										</span>
									</div>
								</div>
							</div>
						</div>
						<!--  DATABASE DETAILS PANEL -->
						<uib-accordion close-others="false" class="text-left" data-ng-if="sfRestore.isDbOptionRequired()">
							<div uib-accordion-group data-is-open="sfRestore.openDatabaseSection">
								<uib-accordion-heading> <cv:msg key="label.databaseDetails" bundle="capps"/> <i
									class="float-right glyphicon"
									data-ng-class="sfRestore.openDatabaseSection ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right'"></i></uib-accordion-heading>
								<div>
										<cv-sync-database data-ng-if="sfRestore.resetDatabase"
												  always-enable="true"
												  sync-database="sfRestore.restoreData.globalOptions.syncDatabase"
												  server-message="sfRestore.serverMessage"
												  source-database="sfRestore.sourceDatabase"
												  entity = "sfRestore.sourceEntity"
												  proxy-servers="sfRestore.proxyServers">
										</cv-sync-database>
										<cv-sync-database data-ng-if="!sfRestore.resetDatabase"
												  always-enable="true"
												  sync-database="sfRestore.restoreData.globalOptions.syncDatabase"
												  server-message="sfRestore.serverMessage"
												  source-database="sfRestore.sourceDatabase"
												  entity = "sfRestore.sourceEntity"
												  proxy-servers="sfRestore.proxyServers">
										</cv-sync-database>
										<div class="cv-modal-wrapper no-pad" data-ng-if="sfRestore.isDbRestore()">
											<input type="checkbox" id="restoreCatalogDatabase" data-ng-model="sfRestore.restoreData.globalOptions.restoreOnlyLatestVersion"/>
											<label for="restoreCatalogDatabase">
												<cv:msg key="label.restoreOnlyLatestVersion" bundle="capps"/>
											</label>
										</div>
								</div>
							</div>
						</uib-accordion>
						<uib-accordion close-others="false" class="text-left" data-ng-if="(!sfRestore.isMetadataRestore()) || (sfRestore.isSandboxSeeding() && sfRestore.isDataMaskingApplicable())" data-ng-init="sfRestore.openSalesforceOptionsSection=true">
							<div uib-accordion-group data-is-open="sfRestore.openSalesforceOptionsSection">
								<uib-accordion-heading> <cv:msg key="label.options" bundle="profiles"/> <i
									class="float-right glyphicon"
									data-ng-class="sfRestore.openSalesforceOptionsSection ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right'"></i></uib-accordion-heading>
								<div data-ng-if="!sfRestore.isMetadataRestore()">
									
									<div class="form-group" data-ng-if="!sfRestore.isSandboxSeeding()">
										<div data-ng-class="leftGrid">
											<label>
												<cv:msg key="label.restoreParentObj" bundle="capps"/>
											</label>
										</div>
										<div data-ng-class="rightGrid">
											<isteven-multi-select id="cappsRestoreOptionsSF_isteven-multi-select_#4723" 
												input-model="sfRestore.restoreParentTypeList"
												output-model="sfRestore.restoreData.globalOptions.restoreParentTypeList"
												button-label="label"
												item-label="label"
												tick-property="selected"
												selection-mode="single"
												directive-id="restoreParentObj"
												on-item-click="sfRestore.restoreData.globalOptions.restoreParentType = sfRestore.restoreData.globalOptions.restoreParentTypeList[0].value">
											</isteven-multi-select>
										</div>
									</div>
									
									<div class="form-group" data-ng-if="!sfRestore.isSandboxSeeding()">
										<div data-ng-class="leftGrid">
											<label>
												<cv:msg key="label.restoreDepObj" bundle="capps"/>
											</label>
										</div>
										<div data-ng-class="rightGrid">
											
											<isteven-multi-select id="cappsRestoreOptionsSF_isteven-multi-select_#1456" 
												input-model="sfRestore.restoreData.globalOptions.dependentRestoreLevelList"
												output-model="sfRestore.model.dependentRestoreLevelList"
												button-label="text"
												item-label="text"
												tick-property="selected"
												selection-mode="single"
												directive-id="restoreDepObj"
												on-item-click="sfRestore.dependentLevelChangedWrapper()">
											</isteven-multi-select>
										</div>
									</div>
									<cv-salesforce-exclude-objects
										data-ng-show="sfRestore.showExcludeChildren()"
										subclient-id="{{sfRestore.sourceEntity.subclientId}}"
										source-objects="sfRestore.objectItems"
										browse-time="sfRestore.browseTime"
										parent-controller="sfRestore"
										dependent-level="sfRestore.restoreData.globalOptions.dependentRestoreLevel"
										server-message="sfRestore.serverMessage"
										exclude-children="sfRestore.model.excludeChildren"
										children-to-exclude="sfRestore.model.childrenToExclude"
										data-ng-if="!sfRestore.isSandboxSeeding()">
									</cv-salesforce-exclude-objects>
									<div class="form-group" data-ng-if="sfRestore.isDisableTriggersRequired()">
										<div class="col-xs-12">
											<input type="checkbox" id="disableTriggersAndRules" data-ng-model="sfRestore.restoreData.globalOptions.disableTriggersAndRules" data-ng-change="sfRestore.disableTriggersChanged()"/>
											<label for="disableTriggersAndRules">
												<cv:msg key="label.disableTriggersAndRules" bundle="capps"/>
											</label>
										</div>
									</div>
								</div>
								<div data-ng-show="sfRestore.isDataMaskingApplicable()" id="sf-mask-policy-options">
									<div class="form-group">
										<div class="col-xs-12 margin-top-10">
											<input type="checkbox" id="enable-data-masking" data-ng-model="sfRestore.restoreData.globalOptions.enableMasking" data-ng-disabled="!sfRestore.maskPolicies || sfRestore.maskPolicies.length === 0"/>
											<label for="enable-data-masking" class="padding-right-20">
												<cv:msg key="label.enableMasking" bundle="capps"/>
												<cv-help-component  data-ng-if= "!sfRestore.maskPolicies || sfRestore.maskPolicies.length === 0" class="help-component" help-text='<cv:msg key="salesforce.help.policyDisabledTooltip" bundle="capps" />'></cv-help-component>
	  										</label>
										</div>
									</div>
									<div class="form-group padding-left-20" data-ng-disabled="!sfRestore.restoreData.globalOptions.enableMasking">
										<div class="col-xs-12 col-sm-5">
											<label for="policy-select" ><cv:msg key="label.selectMaskingPolicy" bundle="capps"/></label>
										</div>
										<div class="col-xs-12 col-sm-7">
											<isteven-multi-select
													input-model="sfRestore.maskPolicies"
													output-model= "sfRestore.restoreData.globalOptions.selectedMaskPolicy"
													item-label="policyName"
													button-label="policyName"
													tick-property="checked"
													disable-property="disabled"
													helper-elements="filter"
													class="isteven-multi-select user-group-select single-select"
													name="policy-select"
													id="policy-select"
													max-labels="1"
													data-selection-mode="single"
													translation="sfRestore.localLang">
											</isteven-multi-select>
											<input type="text" data-ng-model="sfRestore.restoreData.globalOptions.selectedMaskPolicy" name="dataMaskPolicy" style="display:none" data-ng-required="sfRestore.isDataMaskingApplicable() && sfRestore.restoreData.globalOptions.enableMasking" />
											<span class="help-block" data-ng-show="salesforceRestoreForm.$submitted && salesforceRestoreForm.dataMaskPolicy.$error.required">
												<cv:msg key="salesforce.help.noPolicy" bundle="capps"/>
											</span>
										</div>
									</div>
								</div>
							</div>
						</uib-accordion>
					</div>
					<div class="back-strip margin-top-0 min-height-0">
					<div class="button-container" data-ng-class="{'modal-footer full-width': sfRestore.isModal, 'button-container': !sfRestore.isModal}">
						<button id="cappsRestoreOptionsSF_button_#0404" data-ng-if="sfRestore.isMetadataRestore() && sfRestore.restoreData.globalOptions.restoreTarget === 'Salesforce Instance'"
								type="submit" class="btn btn-primary cvBusyOnAjax float-left" data-ng-disabled="!sfRestore.isSaaS && (!sfRestore.backupSetInfoLoaded || !sfRestore.destBackupsetInfoLoaded)"
								data-ng-click="sfRestore.restoreData.globalOptions.validateOnly=true">
							<cv:msg key="label.validateOnly" bundle="restore"/>
						</button>
						
						<button id="cappsRestoreOptionsSF_button_#4049" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="sfRestore.cancel()"> 
							<cv:msg key="Cancel" bundle="messages"/>
						</button>
						
						<button id="cappsRestoreOptionsSF_button_#3010" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="!sfRestore.isSaaS && (!sfRestore.backupSetInfoLoaded || !sfRestore.destBackupsetInfoLoaded)" 
								data-ng-click="sfRestore.restoreData.globalOptions.validateOnly=false">
							 
							<span data-ng-if="sfRestore.isMetadataRestore() && sfRestore.restoreData.globalOptions.restoreTarget === 'Salesforce Instance'">
								<cv:msg key="action.submitRestore" bundle="restore"/>
							</span>
							
							<span data-ng-if="!(sfRestore.isMetadataRestore() && sfRestore.restoreData.globalOptions.restoreTarget === 'Salesforce Instance')">
								<cv:msg key="action.submit" bundle="restore"/>
							</span>
							
						</button>
					</div>
			</form>
		</div>
	</div>
</div>