<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.cloudStorageApp"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<script type="text/ng-template"  id="dynamoDbRestoreTemplate.html">
	<div class="form-group">
		<label class="col-xs-12 col-sm-5" for="destinationServer">
			<cv:msg key="label.destinationAccount" bundle="cloudStorageApp"/>
		</label>

		<div class="col-xs-12 col-sm-7" >
			<cv-isteven-single-select id-name="destinationServer"
				input-model="dynamoDbRestore.destClientList"
				binding-model="dynamoDbRestore.restoreData.destClient"
				track-field="clientId"
				label="clientName"
				tick-property="selected"
				disable-property="disabled"
				on-change="dynamoDbRestore.onDestClientChanged()"
				place-holder='<cv:msg key="label.selectDestinationAccount" bundle="capps"/>'
				help-text='<cv:msg key="label.selectDestinationAccount" bundle="capps"/>'
				required = "true">
			</cv-isteven-single-select>
			<span class="help-block" data-ng-show="dynamoDbRestore.restoreData.destClient && dynamoDbRestore.instancesLoaded === dynamoDbRestore.restoreData.destClient.clientId  && !dynamoDbRestore.restoreData.destInstance">
				<cv:msg key="label.serverHasNoDynamoInstance" bundle="capps"/>
			</span> 
		</div>
	</div>
	<div class="form-group">
		<div class="col-xs-12 col-sm-5" >
			<label for="noOfStreams">
				<cv:msg key="label.noOfStreams" bundle="job" />
			</label>
		</div>
		<div class="col-xs-12 col-sm-7" >
			<input  type="number" id="noOfStreams" name="noOfStreams" min="1" max="50" step="1" data-ng-model="dynamoDbRestore.restoreData.noOfStreams" />
			<span class="help-block" data-ng-show="!dynamoDbRestore.isValidStream()">
				<cv:msg key="error.numberBackupStreams" bundle="oracle" />
			</span>
		</div>
	</div>							
	<div class="form-group">
		<div class="col-xs-12 col-sm-5" >
			<toggle-control status="dynamoDbRestore.restoreData.adjustWriteCapacity" data-ng-click="dynamoDbRestore.restoreData.adjustWriteCapacity = !dynamoDbRestore.restoreData.adjustWriteCapacity"></toggle-control>
			<label for="writeCap" >
				<cv-help-text help-label="label.adjustWriteCapacity" help-text="label.adjustWriteCapactiyHelp" />
			</label>
		</div>
		<div class="col-xs-12 col-sm-7" data-ng-if="dynamoDbRestore.restoreData.adjustWriteCapacity">
			<input type="number" id="writeCap" name="writeCap" min="{{dynamoDbRestore.minCap}}" max="{{dynamoDbRestore.maxCap}}" data-ng-model="dynamoDbRestore.restoreData.writeCap" />
			<cv:msg key='label.units' bundle='capps'/>
			<span class="help-block" data-ng-show="!dynamoDbRestore.isValidCap()">
				<cv:msg key="label.numberOutOfRange" bundle="capps"/>
			</span>
		</div>
	</div>							
	<div class="form-group" >
		<div class="col-xs-12">
			<toggle-control status="dynamoDbRestore.restoreData.overwriteTables" data-ng-click="dynamoDbRestore.restoreData.overwriteTables = !dynamoDbRestore.restoreData.overwriteTables"></toggle-control>
			<cv-help-text help-label="label.overwriteDestinationTables" help-text="help.overwriteDestinationTables" />

		</div>
	</div>
	<div class="form-group" data-ng-show="false" >
		<div class="col-xs-12">
			<toggle-control status="dynamoDbRestore.restoreData.createGlobalTable" data-ng-click="dynamoDbRestore.restoreData.createGlobalTable = !dynamoDbRestore.restoreData.createGlobalTable"></toggle-control>
			<label><cv:msg key='label.createGlobalTable' bundle='capps'/></label>
		</div>
	</div>
	
	
	<cv-kendo-grid cv-grid-options="dynamoDbRestore.gridOptions"/>
</script>
<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 > <cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	<span class="{{dynamoDbRestore.serverMessage.type}}" data-ng-bind="dynamoDbRestore.serverMessage.message"></span>
	<form name="restoreForm" class="form-horizontal" novalidate data-cv-submit="dynamoDbRestore.submit()" autocomplete="off">
		<div class="panel">
		<div class="panel-body">
			<div data-ng-include="'dynamoDbRestoreTemplate.html'"> </div>
		</div>
		</div>
		
		<div class="modal-footer">
			<button id="cappsRestoreOptionsDynamoDb_button_#1759" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="dynamoDbRestore.cancel()"> 
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<button id="cappsRestoreOptionsDynamoDb_button_#4696" class="btn btn-primary cvBusyOnAjax" type="submit" > 
				<cv:msg key="Submit" bundle="messages"/>
			</button>
		</div>
	</form>
</div>
