<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 > <cv:msg key="label.restoreOpts" bundle="restore"/></h1>
	</div>
	<span class="{{amazonDbRestore.serverMessage.type}}" data-ng-bind="amazonDbRestore.serverMessage.message"></span>
	<form name="restoreForm" class="form-horizontal" novalidate data-cv-submit="amazonDbRestore.submit()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<label class="col-xs-12 col-sm-5" for="destinationServer">
						<cv:msg key="label.cloudAccount" bundle="postgres"/>
					</label>
					<label class="col-xs-12 col-sm-7 label-as-input">
						<a target="_blank" ng-href="#clientDetails/{{rds.restoreData.destClient.clientId}}">{{amazonDbRestore.restoreData.destClient.clientName}}</a>
					</label>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-5">
						<cv:msg key="label.SnapShot" bundle="browse"/>
					</label>
					<label class="col-xs-12 col-sm-7 label-as-input">
						{{amazonDbRestore.sourceSnap.snapShotName}}
					</label>
				</div>
				<div class="form-group">
					<label for="dbIdentifier" class="col-xs-12 col-sm-5">
						<cv-help-text help-label="{{amazonDbRestore.targetDbLabel}}" help-text="amazonDbRestore.targetDbTooltip" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" id="dbIdentifier" name="dbIdentifier"
							data-ng-model="amazonDbRestore.restoreData.targetDbName" required />
						 <span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.dbIdentifier)">
							{{amazonDbRestore.targetDbErrorLabel}}
						</span>
					</div>
				</div>

				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType !== 'AMAZON_DOCUMENTDB'">
					<div class="col-xs-12">
						<toggle-control status="amazonDbRestore.restoreData.publicAccess"
							data-ng-click="amazonDbRestore.restoreData.publicAccess = !amazonDbRestore.restoreData.publicAccess"></toggle-control>
						<cv-help-text help-label="label.publicAccess" help-text="amazonDbRestore.publicAccessTooltip" />
					</div>
				</div>
				<%-- <div class="form-group">
					<div class="col-xs-12">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</div> --%>
			</div>
		</div>
		<uib-accordion  close-others="true" class="text-left">
			<div uib-accordion-group data-is-open="amazonDbRestore.accordionOpen">
				<uib-accordion-heading>
					<cv:msg key="label.advanced" bundle="clients" />
					<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': amazonDbRestore.accordionOpen, 'glyphicon-chevron-right': !amazonDbRestore.accordionOpen}"></i>
				</uib-accordion-heading>


				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType === 'AMAZON_RDS'">
					<div class="col-xs-12">
						<toggle-control status="amazonDbRestore.restoreData.isMultiAZ"
							data-ng-click="amazonDbRestore.restoreData.isMultiAZ = !amazonDbRestore.restoreData.isMultiAZ"></toggle-control>
						<cv-help-text help-label="label.isMultiAZ" help-text="tooltip.multiAzDeploymentRds"/>
					</div>
				</div>


				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType !== 'AMAZON_DOCUMENTDB' && !amazonDbRestore.restoreData.isMultiAZ">
					<label class="col-xs-12 col-sm-5" for="targetZone" >
						<cv-help-text help-label="label.targetAvailbilityZone" help-text="amazonDbRestore.targetZoneTooltip"/>
					</label>
					<div class="col-xs-12 col-sm-7">
						<isteven-multi-select id="targetZone"
							directive-id="targetZone"
							input-model="amazonDbRestore.targetZoneList"
							output-model="amazonDbRestore._targetZone"
							button-label="label"
							item-label="label"
							translation="amazonDbRestore.localLangTargetZone"
							tick-property="selected"
							class="isteven-multi-select user-group-select"
							selection-mode="single"
							on-close="amazonDbRestore.targetZoneChanged()">
						</isteven-multi-select>
					</div>
				</div>


				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType !== 'AMAZON_REDSHIFT'">
					<label class="col-xs-12 col-sm-5" for="targetDBInstanceClass" >
						<cv-help-text help-label="label.instanceClass" help-text="amazonDbRestore.targetDBInstanceClassTooltip" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<isteven-multi-select id="targetDBInstanceClass"
							directive-id="targetDBInstanceClass"
							input-model="amazonDbRestore.targetDBInstanceClassList"
							output-model="amazonDbRestore._targetDBInstanceClass"
							button-label="label"
							item-label="label"
							translation="amazonDbRestore.localLangTargetDBInstanceClass"
							tick-property="selected"
							class="isteven-multi-select user-group-select"
							selection-mode="single"
							on-close="amazonDbRestore.targetDBInstanceClassChanged()">
						</isteven-multi-select>
					</div>
				</div>

				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType === 'AMAZON_REDSHIFT'">
					<label class="col-xs-12 col-sm-5" for="nodeType" >
						<cv-help-text help-label="label.nodeType" help-text="amazonDbRestore.nodeTypeTooltip" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<isteven-multi-select id="nodeType"
							directive-id="nodeType"
							input-model="amazonDbRestore.nodeTypeList"
							output-model="amazonDbRestore._nodeType"
							button-label="label"
							item-label="label"
							translation="amazonDbRestore.localLangNodeType"
							tick-property="selected"
							class="isteven-multi-select user-group-select"
							selection-mode="single"
							on-close="amazonDbRestore.nodeTypeChanged()">
						</isteven-multi-select>
					</div>
				</div>

				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType === 'AMAZON_RDS'">
					<label class="col-xs-12 col-sm-5" for="targetStorageType">
						<cv-help-text help-label="label.storageType" help-text="tooltip.storageTypeRds" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<isteven-multi-select id="targetStorageType"
							directive-id="targetStorageType"
							input-model="amazonDbRestore.targetStorageTypeList"
							output-model="amazonDbRestore._targetStorageType"
							button-label="label"
							item-label="label"
							translation="amazonDbRestore.localLangTargetStorageType"
							tick-property="selected"
							class="isteven-multi-select user-group-select"
							selection-mode="single"
							on-close="amazonDbRestore.targetStorageTypeChanged()">
						</isteven-multi-select>
					</div>
				</div>
				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType === 'AMAZON_RDS' && amazonDbRestore.restoreData.targetStorageType.option === 'io1'">
					<label class="col-xs-12 col-sm-5" for="targetIops">
						<cv:msg key="label.provisionedIops" bundle="capps" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="number" id="targetIops" min="1" max="100000" name="targetIops"  data-ng-model="amazonDbRestore.restoreData.targetIops" required/>
						<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.targetIops) || restoreForm.$submitted && !amazonDbRestore.isValidIops()">
							<cv:msg key="error.provisionedIops" bundle="capps" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-5" for="targetSecurityGroupValue">

						<cv-help-text help-label="label.dbSubnetGroup" help-text="amazonDbRestore.targetSecurityGroupValueTooltip" />
						<span class="optional-text"><cv:msg key="label.optional" bundle="restore"/> </span>

					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" id="targetSecurityGroupValue" name="targetSecurityGroupValue"  data-ng-model="amazonDbRestore.restoreData.targetSecurityGroupValue"/>
					</div>
				</div>
				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType !== 'AMAZON_DOCUMENTDB'">
					<label class="col-xs-12 col-sm-5" for="targetParameterGroupName">

						<cv-help-text help-label="{{amazonDbRestore.targetParameterGroupLabel}}" help-text="amazonDbRestore.targetParameterGroupTooltip" />
						<span class="optional-text"><cv:msg key="label.optional" bundle="restore"/> </span>
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" id="targetParameterGroupName" name="targetParameterGroupName"  data-ng-model="amazonDbRestore.restoreData.targetParameterGroupName"/>
					</div>
				</div>
				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType === 'AMAZON_RDS'">
					<label class="col-xs-12 col-sm-5" for="targetOptionGroupName">
						<cv-help-text help-label="label.optionGroup" help-text="tooltip.optionGroupRds"/>
						<span class="optional-text"><cv:msg key="label.optional" bundle="restore"/> </span>
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" id="targetOptionGroupName" name="targetOptionGroupName"  data-ng-model="amazonDbRestore.restoreData.targetOptionGroupName"/>
					</div>
				</div>

				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType === 'AMAZON_RDS'">
					<label class="col-xs-12 col-sm-5" for="portNumber">
						<cv:msg key="label.port" bundle="storage"/>
						<span class="optional-text"><cv:msg key="label.optional" bundle="restore"/></span>
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="number" id="portNumber" name="portNumber"  data-ng-model="amazonDbRestore.restoreData.portNumber"/>
					</div>
				</div>

				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType === 'AMAZON_RDS'">
					<div class="col-xs-12">
						<toggle-control status="amazonDbRestore.restoreData.autoMinorVersionUpgrade"
							data-ng-click="amazonDbRestore.restoreData.autoMinorVersionUpgrade = !amazonDbRestore.restoreData.autoMinorVersionUpgrade"></toggle-control>
						<cv-help-text help-label="label.autoMinorVersionUpgrade" help-text="tooltip.autoMinorVersionUpgradeRds" />
					</div>
				</div>

				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType === 'AMAZON_REDSHIFT'">
					<div class="col-xs-12">
						<toggle-control status="amazonDbRestore.restoreData.allowVersionUpgrade"
							data-ng-click="amazonDbRestore.restoreData.allowVersionUpgrade = !amazonDbRestore.restoreData.allowVersionUpgrade"></toggle-control>
						<cv-help-text help-label="label.allowVersionUpgrade" help-text="tooltip.allowVerionUpgradeRedshift" />
					</div>
				</div>

				<div class="form-group" data-ng-if="amazonDbRestore.cloudAppsType === 'AMAZON_DOCUMENTDB'">
					<label class="col-xs-12 col-sm-5" for="numberOfInstances">
						<cv-help-text help-label="label.numberOfInstances" help-text="tooltip.numberOfInstancesDocumentdb" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="number" id="numberOfInstances" min="1" max="16" name="numberOfInstances"  data-ng-model="amazonDbRestore.restoreData.numberOfInstances" required/>
						<span class="help-block" data-ng-show="cv.restoreForm.needsAttention(restoreForm.numberOfInstances) || restoreForm.$submitted && !amazonDbRestore.isValidNumberOfInstances()">
							<cv:msg key="error.numberOfInstances" bundle="capps" />
						</span>
					</div>
				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-5" for="targetVpcSecurityGroup">
						<cv-help-text help-label="label.vpcSecurityGroup" help-text="tooltip.vpcSecurityGroup" />
						<span class="optional-text"><cv:msg key="label.optional" bundle="restore"/> </span>

					</label>
					<div class="col-xs-12 col-sm-7">
						<input type="text" id="targetVpcSecurityGroup" name="targetVpcSecurityGroup" data-ng-model="amazonDbRestore.restoreData.targetVpcSecurityGroup"/>
					</div>
				</div>
		    </div>
		</uib-accordion>
		<div class="panel">
			<div class="panel-body">
				<div class="form-group">
					<div class="col-xs-12">
						<cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="cappsRestoreOptionsAmazonDb_button_cancel" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="amazonDbRestore.cancel()">
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<button id="cappsRestoreOptionsAmazonDb_button_submit" class="btn btn-primary cvBusyOnAjax" type="submit" >
				<cv:msg key="Submit" bundle="messages"/>
			</button>
		</div>
	</form>
</div>
