<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div data-ng-init="leftGrid=['col-xs-12', 'col-lg-5']"></div>
<div data-ng-init="rightGrid=['col-xs-12', 'col-lg-7']"></div>
<div class="bootstrap-wrapper" >
	<div class="setup-title">
		<h1><span> <cv:msg key="label.restoreOpts" bundle="restore"/> </span></h1>
	</div>
	
	<span class="serverMessage {{cappsORCtrl.serverMessage.type}}" data-ng-bind="cappsORCtrl.serverMessage.message"></span>
	
	<form class="form-horizontal" novalidate id="cappsOrgRestoreForm" name="cappsOrgRestoreForm" autocomplete="off" cv-submit="cappsORCtrl.submit()">
		<div class="modal-body">
			
			<div>
				<div class="form-group">
					<div data-ng-class="leftGrid" >
						<label><cv:msg key="label.destinationOrganization" bundle="capps"/></label>
					</div>
					<div data-ng-class="rightGrid">
						<select name="destOrg" data-ng-model="cappsORCtrl.model.destinationOrg" data-ng-options="org.entity.instanceName for org in cappsORCtrl.destinationOrgs" required>
						</select>
						<span class="help-block" data-ng-show="cv.cappsOrgRestoreForm.needsAttention(cappsOrgRestoreForm.destOrg)">
							<cv:msg key="error.destinationOrganization" bundle="capps"/>
						</span>
					</div>
				</div>
				<div class="form-group" data-ng-if="!cappsORCtrl.isMetadataRestore()">
					<div data-ng-class="leftGrid" >
						<label><cv:msg key="label.restoreDepObj" bundle="capps"/></label>
					</div>
					<div data-ng-class="rightGrid">
						<select name="restoreDepObj" data-ng-model="cappsORCtrl.model.dependentRestoreLevel" data-ng-options="level.intValue as level.text for level in cappsORCtrl.dependentRestoreLevelList" required>
					</select>
					</div>
				</div>
				
				<div class="form-group" data-ng-if="cappsORCtrl.isDisableTriggersRequired()">
					<div class="col-xs-12">
						<input type="checkbox" id="disableTriggersAndRules" data-ng-model="cappsORCtrl.model.disableTriggersAndRules" data-ng-change="cappsORCtrl.disableTriggersChanged()"/>
						<label for="disableTriggersAndRules">
							<cv:msg key="label.disableTriggersAndRules" bundle="capps"/>
						</label>
					</div>
				</div>
			
			</div>
		</div>			 
			<div class="modal-footer">
				<button id="cappsOrgRestoreOptionsSF_button_#3962" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cappsORCtrl.cancel()"> 
					<cv:msg key="Cancel" bundle="messages"/>
				</button>
		
				<button id="cappsOrgRestoreOptionsSF_button_#3418" type="submit" class="btn btn-primary cvBusyOnAjax"> 
					<cv:msg key="action.submit" bundle="restore"/>
				</button>
			</div>
	
		</form>
		
</div>
		
