<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
	<div class="row bootstrap-wrapper" data-ng-controller="cappsOrgEditSFController as orgEditCtrl">
		<div
			class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
			<h1 class="page-header" data-ng-if="!orgEditCtrl.isEdit"><cv:msg key="label.addSalesforceOrg" bundle="capps" />
			<cv-help-component help-text='<cv:msg key="note.addSalesforceOrg" bundle="capps" />'></cv-help-component></h1>
			<h1 class="page-header" data-ng-if="orgEditCtrl.isEdit"><cv:msg key="label.editSalesforceOrg" bundle="capps" /></h1>
	
			<span class="server-message {{orgEditCtrl.serverMessage.type}}" data-ng-bind="orgEditCtrl.serverMessage.message"></span>
	
			<form class="form-horizontal" novalidate name="cappsOrgForm"  autocomplete="off" cv-submit="orgEditCtrl.confirmEmptyAPIToken()">
					<div>
						<div class="panel panel-default">
							<div class="panel-body">
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="orgName"><cv:msg key="label.organization" bundle="capps" /></label>
									<div class="col-xs-12 col-lg-6">
										<input required type="text" name="orgName" placeholder="<cv:msg key="label.organizationName" bundle="capps" />" data-ng-model="orgEditCtrl.model.org.entity.instanceName"/>
										<div class="help-block"
											data-ng-show="cv.cappsOrgForm.needsAttention(cappsOrgForm.orgName)">
											<i class="ion-alert-circled"></i>
											<cv:msg key="error.organizationName" bundle="capps" />
										</div>
									</div>
								</div>
							</div>
						</div>
	
						<uib-accordion close-others="false" class="text-left">
						<div uib-accordion-group data-is-open="orgEditCtrl.openAccountDetails" data-ng-init="orgEditCtrl.openAccountDetails=true">
							<uib-accordion-heading><cv:msg key="header.accountDetails" bundle="capps" /><i
								class="float-right glyphicon"
								data-ng-class="orgEditCtrl.openAccountDetails ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right'"></i></uib-accordion-heading>
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="url"><cv:msg key="label.salesforceLoginUrl" bundle="capps"/></label>
									<div class="col-xs-12 col-lg-6">
										<input required type="text" name="url" placeholder="<cv:msg key="label.salesforceLoginUrl" bundle="capps"/>"
											data-ng-model="orgEditCtrl.model.org.instanceProp.endpoint"/>
										<div class="help-block"
											data-ng-show="cv.cappsOrgForm.needsAttention(cappsOrgForm.url)">
											<i class="ion-alert-circled"></i>
											<cv:msg key="error.salesforceLoginUrl" bundle="capps"/>
										</div>
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="username"><cv:msg key="label.userName" bundle="servers"/></label>
									<div class="col-xs-12 col-lg-6">
										<input required type="text" name="username" placeholder="<cv:msg key="placeholder.sfUserName" bundle="capps"/>"
											data-ng-model="orgEditCtrl.model.org.backupsetProp.userPassword.userName"/>
											<div class="help-block"
												data-ng-show="cv.cappsOrgForm.needsAttention(cappsOrgForm.username)">
												<i class="ion-alert-circled"></i>
												<cv:msg key="error.userName" bundle="servers"/>
											</div>
											
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="password"><cv:msg key="label.password" bundle="users"/></label>
									<div class="col-xs-12 col-lg-6">
										<input required type="password" name="password" placeholder="<cv:msg key="label.password" bundle="users"/>" 
											data-ng-model="orgEditCtrl.model.password"/>
											<div class="help-block"
												data-ng-show="cv.cappsOrgForm.needsAttention(cappsOrgForm.password)">
												<i class="ion-alert-circled"></i>
												<cv:msg key="error.password" bundle="users"/>
											</div>
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="apiToken"><cv:msg key="label.apiToken" bundle="capps"/></label>
									<div class="col-xs-12 col-lg-6">
										<input type="password" name="apiToken" placeholder="<cv:msg key="label.apiToken" bundle="capps"/>"
											data-ng-model="orgEditCtrl.model.token"/>
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="consumerKey"><cv:msg key="label.consumerKey" bundle="capps"/></label>
									<div class="col-xs-12 col-lg-6">
										<input required type="text" name="consumerKey" placeholder="<cv:msg key="label.consumerKey" bundle="capps"/>"
											data-ng-model="orgEditCtrl.model.org.instanceProp.consumerId"/>
											<div class="help-block"
												data-ng-show="cv.cappsOrgForm.needsAttention(cappsOrgForm.consumerKey)">
												<i class="ion-alert-circled"></i>
												<cv:msg key="error.consumerKey" bundle="capps"/>
											</div>
									</div>
								</div>
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="consumerSecret"><cv:msg key="label.consumerSecret" bundle="capps"/></label>
									<div class="col-xs-12 col-lg-6">
										<input required type="password" name="consumerSecret" placeholder="<cv:msg key="label.consumerSecret" bundle="capps"/>"
											data-ng-model="orgEditCtrl.model.consumerSecret"/>
											<div class="help-block"
												data-ng-show="cv.cappsOrgForm.needsAttention(cappsOrgForm.consumerSecret)">
												<i class="ion-alert-circled"></i>
												<cv:msg key="error.consumerSecret" bundle="capps"/>
											</div>
									</div>
								</div>
								<!--  <div class="form-group">
									<div class="col-xs-12 col-lg-9">
											<button id="cappsOrgEditSF_button_#1061" type="button" class="btn btn-default cvBusyOnAjax pull-right" data-ng-disabled="!orgEditCtrl.enableTestConnection()"  
												data-ng-click="orgEditCtrl.testConnection()">
												Test connection
											</button>
									</div>
								</div> -->
						</div>
						
						<div uib-accordion-group data-is-open="orgEditCtrl.openBackupOptions" data-ng-init="orgEditCtrl.openBackupOptions=true">
							<uib-accordion-heading><cv:msg key="header.backupOptions" bundle="capps" /><i
								class="float-right glyphicon"
								data-ng-class="orgEditCtrl.openBackupOptions ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right'"></i></uib-accordion-heading>
								<div class="form-group">
									<label class="col-xs-12 col-lg-3" for="backupPlan"><cv:msg key="label.backupPlan" bundle="capps"/></label>
									<div class="col-xs-12 col-lg-6">
										<select name="plan" id="plan" data-ng-options="profile.plan.planId as profile.plan.planName for profile in orgEditCtrl.profileList | orderBy: 'plan.planName'"
											data-ng-model="orgEditCtrl.model.org.planEntity.planId" required>
											<option value=""><cv:msg key="placeholder.plan" bundle="capps"/></option>
										</select>
										<div class="help-block"
												data-ng-show="cv.cappsOrgForm.needsAttention(cappsOrgForm.plan)">
												<i class="ion-alert-circled"></i>
												<cv:msg key="error.backupPlan" bundle="capps"/>
										</div>
									</div>
								</div>
								<div class="form-group" data-ng-if="!orgEditCtrl.isEdit">
									<div class="col-xs-12 col-lg-3">
										<cv-help-text help-label="label.backupContent" help-text='note.backupContent'></cv-help-component>
									</div>
									
									
									<div class="col-xs-12 col-lg-9">
										<div class="checkbox-inline">
											<input type="checkbox" id="backupObjects" data-ng-disabled="true"
												data-ng-model="orgEditCtrl.model.org.subclientProp.backupSfObjects"></input>
											<label for="backupObjects"><cv:msg key="label.salesforceObjects" bundle="capps"/></label>
										</div>
										<div class="checkbox-inline">
											<input type="checkbox" id="backupFiles"
												data-ng-model="orgEditCtrl.model.org.subclientProp.backupFileObjects"></input>
											<label for="backupFiles"><cv:msg key="label.salesforceFiles" bundle="capps"/></label>
										</div>	
										<div class="checkbox-inline">
											<input type="checkbox" id="backupMetadata"
												data-ng-model="orgEditCtrl.model.org.subclientProp.backupSFMetadata"></input>
											<label for="backupMetadata"><cv:msg key="label.salesforceMetadata" bundle="capps"/></label>
										</div>	
									</div>
								</div>
								<div class="form-group" data-ng-if="orgEditCtrl.isEdit">
										<div class="col-xs-12 col-lg-3">
											<label for="filesPerBackup">
												<cv-help-text help-label="label.filesPerBackup" help-text="help.filesPerBackup"></cv-help-text>
											</label>
										</div>
										<div class="col-xs-12 col-lg-9" class="text-left">
											<input type="number" name="filesPerBackup" id="filesPerBackup" data-ng-model="orgEditCtrl.model.org.instanceProp.filesPerBackup" min="1" max="90" required /> %
											<span class="help-block" data-ng-show="cappsOrgForm.$submitted && (cappsOrgForm.filesPerBackup.$error.required || !cappsOrgForm.filesPerBackup.$valid)">
												<cv:msg key="error.filesPerBackup" bundle="capps" />
											</span>
										</div>
								</div>
						</div>
						</uib-accordion>
					
					<div class="text-right">
						<button id="cappsOrgEditSF_button_#6074" data-ng-if="!orgEditCtrl.noOrgFoundFlag" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="orgEditCtrl.cancel()"> 
							<cv:msg key="Cancel" bundle="messages" />
						</button>
						<button id="cappsOrgEditSF_button_#7312" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-disabled="!orgEditCtrl.enableTestConnection()"  
							data-ng-click="orgEditCtrl.testConnection()">
							<cv:msg key="label.testConnection" bundle="capps" />
						</button>
						<button id="cappsOrgEditSF_button_#8947" type="submit" class="btn btn-primary cvBusyOnAjax"> 
							<cv:msg key="Save" bundle="messages" />
						</button>
					</div>
				</div>
			</form>
		</div>
	</div>
