<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvEnum name="App.CloudAppsInstanceType"></cv:cvEnum>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.setup"></cv:cvMessages>
</script>
<div data-ng-controller="cappsLandingPageController as cAppLPCtrl" >
	<h1 data-ng-class= 'page-title'><cv:msg key="label.capps" bundle="navJs"/></h1>
<div class="getting-started">
	<div class="center-container setup-container">
		<div class="row">
			<div class="app-tiles">
				<div data-ng-repeat="cloudAppType in cAppLPCtrl.cloudAppsTypes">
								<div class="col-md-6 col-lg-6 app-setup-container">
									<div class="panel panel-default" class="clickable">
											<div class="panel-body horz-center capps-tile-wrapper">
												<div class="capps-tile-container"  data-ng-click="cAppLPCtrl.handleTileClick(cloudAppType)">
													<div><img ng-src={{cloudAppType.svgPath}} /></div>
													<div data-ng-if="cloudAppType.setupCompleted"><a class="larger-font" href="javascript:void(0)">{{cloudAppType.localizedType}}</a></div>
													<div data-ng-if="!cloudAppType.setupCompleted"><a class="larger-font" href="javascript:void(0)">{{'label.completeSetupFor' | cvLoc:cloudAppType.localizedType}}<i style="margin-left: 5px;" class="ion-chevron-right"></i></a></div>
												</div>
												<div class="capps-tile-footer" id="div1" data-ng-if="cloudAppType.setupCompleted && cloudAppType.setupName != cAppLPCtrl.distributedSystemSetupName">
																		<input name="chkDefault_{{cloudAppType.type.key}}" id="chkDefault_{{cloudAppType.type.key}}" type="checkbox"
																		data-ng-model="cloudAppType.isDefault"
																		 data-ng-change="cAppLPCtrl.defaultCloudAppTypeChanged(cloudAppType)"
																		 data-ng-disabled="cloudAppType.isDefault"
																		  />
																		<label for="chkDefault_{{cloudAppType.type.key}}" class="cv-checkbox-label"><cv:msg key="label.setAsDefaultApp" bundle="capps"/></label>
													</div>
											</div>
									</div>
							    </div>
						</div>
				</div>
			</div>
		</div>
	</div>
</div>
