<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div data-ng-controller = "salesforceInstanceDetails as sfICtrl">
 <div class="row">
	<div class="col-md-12">
		<h1 class="float-left" data-ng-bind="sfICtrl.instanceDetails.instance.instanceName" data-ng-show="sfICtrl.serverMessage.message==''"></h1>
		<span class="server-message {{sfICtrl.serverMessage.type}}" data-ng-bind="sfICtrl.serverMessage.message"></span>
		<span data-ng-if="sfICtrl.instanceDetails"><a class="page-action-item" href="" data-ng-click="sfICtrl.loadRestoreHistoryUrl()"><cv:msg key="label.RestoreHistory" bundle="clients" /></a></span>
		<span data-ng-if="sfICtrl.instanceDetails"><a class="page-action-item" href="" data-ng-click="sfICtrl.loadBackupHistoryUrl()"><cv:msg key="label.BackupHistory" bundle="clients" /></a></span>
		<span data-ng-if="sfICtrl.instanceDetails"><a class="page-action-item" href="#/salesForce/dataMaskingSF/{{sfICtrl.clientId}}/{{sfICtrl.instanceId}}/"><cv:msg key="label.dataMasking" bundle="capps" /></a></span>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="cappsInstanceDetailsSF-heading_clientGeneral-clients" data-title='<cv:msg key="heading.clientGeneral" bundle="clients"/>' data-loader="sfICtrl.instanceDetails">
			<ul class="list-style-secondary">
				<cv-tile-label-value label='<cv:msg key="label.instanceName" bundle="clients"/>' value="{{sfICtrl.instanceDetails.instance.instanceName}}" ></cv-tile-label-value>
				<cv-tile-label-value label='<cv:msg key="label.backupClientAccNode" bundle="capps"/>' value="{{sfICtrl.instanceDetails.cloudAppsInstance.generalCloudProperties.proxyServers[0].clientName}}" ></cv-tile-label-value>
			</ul>
			<div class="page-details-box-links">
                <a href="" data-ng-click="sfICtrl.editInstance('GENERAL')"><cv:msg key="action.edit.only" bundle="capps" />
                </a>
            </div>
		</cv-tile-component>
		<cv-tile-component data-ac-id="cappsInstanceDetailsSF-backupOptionsTile" data-title='<cv:msg key="header.backupOptions" bundle="capps"/>' data-loader="sfICtrl.instanceDetails">
			<ul class="list-style-secondary">
				<cv-instance-inline-edit data-ng-if="sfICtrl.instanceDetails" instance-details="sfICtrl.instanceDetails" property-path="cloudAppsInstance.salesforceInstance.filesPerBackup"
					label='<cv:msg key="label.filesPerBackup" bundle="capps" />' 
					tool-tip='<cv:msg key="help.filesPerBackup" bundle="capps" />' 
					min=1 max=90
					validation-message='<cv:msg key="error.filesPerBackup" bundle="capps" />'
					unit-label="%">
				</cv-instance-inline-edit>
			</ul>
		</cv-tile-component>

	</div>
	<div class="col-md-6">
		<cv-tile-component data-ac-id="cappsInstanceDetailsSF-label_cAppClientConnDet-capps" data-title='<cv:msg key="label.cAppClientConnDet" bundle="capps"/>' data-loader="sfICtrl.instanceDetails">
			<ul class="list-style-secondary">
				<cv-tile-label-value label='<cv:msg key="label.salesforceLoginUrl" bundle="capps"/>' value="{{sfICtrl.salesforceInstance.endpoint}}" ></cv-tile-label-value>
				<cv-tile-label-value label='<cv:msg key="label.salesforceOrgId" bundle="capps"/>' value="{{sfICtrl.salesforceInstance.sfOrgID}}" ></cv-tile-label-value>
				<cv-tile-label-value label='<cv:msg key="label.consumerKey" bundle="capps"/>' value="{{sfICtrl.salesforceInstance.consumerId}}" ></cv-tile-label-value>
			</ul>
			<div class="page-details-box-links">
                <a href="" data-ng-click="sfICtrl.editInstance('CONNECTION DETAILS')"><cv:msg key="action.edit.only" bundle="capps" />
                </a>
            </div>
		</cv-tile-component>
		<cv-security-component entity-type='sfICtrl.entityType' generic-entity = 'sfICtrl.genericEntity' associations='sfICtrl.formattedSecurityAssociations' associations-loaded="sfICtrl.associationsLoaded" data-show-Owners='true'>
		</cv-security-component>
	</div>
</div>
<cv-grid cv-grid-options="sfICtrl.gridOptions"></cv-grid>
</div>