<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="bootstrap-wrapper">
	<div class="modal-header">
		<h1>
			<cv:msg key="label.inlineEdit" bundle="messagesJs" />
			{{::adbrEdit.data.tableName}}
		</h1>
	</div>
	<span class="{{adbrEdit.serverMessage.type}}"
		data-ng-bind="adbrEdit.serverMessage.message"></span>
	<form name="adbrEditForm" class="form-horizontal" novalidate
		data-cv-submit="adbrEdit.ok()" autocomplete="off" cv-hide-api >
		<div class="panel">
			<div class="panel-body">

				<!-- Azure table storage -->
				<div data-ng-if="adbrEdit.cloudAppType === 32">
					<div class="form-group">
						<label for="destStorageAccount" class="col-xs-12 col-sm-5">
							<cv:msg key="label.destinationStorageAccount" bundle="capps" />
						</label>
						<div class="col-xs-12 col-sm-7">
							<cv-isteven-single-select id-name="destStorageAccount"
								input-model="adbrEdit.regionList"
								binding-model="adbrEdit.data.destStorageAccountName"
								binding-field="name" track-field="name" label="name"
								tick-property="selected"
								place-holder='<cv:msg key="error.storageAccount" bundle="ediscovery"/>'
								help-text='<cv:msg key="error.storageAccount" bundle="ediscovery"/>'
								required="true"> </cv-isteven-single-select>
						</div>
					</div>

					<div class="form-group">
						<label for="destTable" class="col-xs-12 col-sm-5"> <cv:msg
								key="label.destinationTable" bundle="capps" />
						</label>
						<div class="col-xs-12 col-sm-7">
							<input name="destTable" type="text"
								data-ng-model="adbrEdit.data.destTableName" required /> <span
								class="help-block"
								data-ng-show="cv.adbrEditForm.needsAttention(adbrEditForm.destTable)">
								<cv:msg key="error.destinationTable" bundle="capps" />
							</span>
						</div>
					</div>
				</div>

				<div data-ng-if="adbrEdit.cloudAppType === 23">
					<div class="form-group">
						<label for="destTable" class="col-xs-12 col-sm-5"> <cv:msg
								key="label.destinationDatabase" bundle="capps" />
						</label>
						<div class="col-xs-12 col-sm-7">
							<input name="destDatabaseName" type="text"
								data-ng-model="adbrEdit.data.destDatabaseName" required /> <span
								class="help-block"
								data-ng-show="cv.adbrEditForm.needsAttention(adbrEditForm.destDatabaseName)">
								<cv:msg key="error.destinationDatabase" bundle="capps" />
							</span>
						</div>
					</div>

					<div class="form-group" data-ng-if="adbrEdit.showContainerInput">
						<label for="destTable" class="col-xs-12 col-sm-5"> <cv:msg
								key="label.destinationContainer" bundle="capps" />
						</label>
						<div class="col-xs-12 col-sm-7">
							<input name="destContainerName" type="text"
								data-ng-model="adbrEdit.data.destContainerName" required /> <span
								class="help-block"
								data-ng-show="cv.adbrEditForm.needsAttention(adbrEditForm.destContainerName)">
								<cv:msg key="error.destinationContainer" bundle="capps" />
							</span>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="modal-footer">
			<button id="cappsEditRestoreTableAzureDb_button_#0925" type="button"
				class="btn btn-default cvBusyOnAjax"
				data-ng-click="adbrEdit.cancel()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="cappsEditRestoreTableAzureDb_button_#4714"
				class="btn btn-primary cvBusyOnAjax" type="submit">
				<cv:msg key="OK" bundle="messages" />
			</button>
		</div>
	</form>
</div>
