<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="bootstrap-wrapper" >
	<div class="modal-header">
		<h1 data-ng-if="cappsEditRegMap.isEdit"> <cv:msg key="label.inlineEdit" bundle="messagesJs"/> {{::cappsEditRegMap.data.srcRegionCode}}</h1>
		<h1 data-ng-if="!cappsEditRegMap.isEdit"> <cv:msg key="label.addRegionMapping" bundle="capps"/> </h1>
	</div>
	<span class="{{cappsEditRegMap.serverMessage.type}}" data-ng-bind="cappsEditRegMap.serverMessage.message"></span>
	<form name="cappsEditRegMapForm" class="form-horizontal" novalidate data-cv-submit="cappsEditRegMap.ok()" autocomplete="off">
		<div class="panel">
		<div class="panel-body">
		
			<div class="form-group" data-ng-if="!cappsEditRegMap.isEdit">
				<label for="srcRegion" class="col-xs-12 col-sm-5">
					<cv:msg key="label.sourceRegion" bundle="capps"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<isteven-multi-select id="sourceRegionId"
						directive-id="sourceRegion"
						input-model="cappsEditRegMap.sourceRegionList"
						output-model="cappsEditRegMap._selectedSourceRegion"
						button-label="regionName"
						item-label="regionName"
						translation="cappsEditRegMap.localLangRegionList"
						tick-property="selected"
						helper-elements="filter"
						selection-mode="single"
						is-required="true"
						class="isteven-multi-select user-group-select"
						on-close="cappsEditRegMap.sourceRegionChanged()"
						/>
					<span class="help-block" data-ng-show="cv.cappsEditRegMapForm.needsAttention(cappsEditRegMapForm.sourceRegion)">
						<cv:msg key="error.region" bundle="ediscovery"/>
					</span>
				</div>
			</div>
			<div class="form-group">
				<label for="destRegion" class="col-xs-12 col-sm-5">
					<cv:msg key="label.destinationRegion" bundle="capps"/>
				</label>
				<div class="col-xs-12 col-sm-7">
					<isteven-multi-select id="destinationRegionId"
						directive-id="destinationRegion"
						input-model="cappsEditRegMap.destinationRegionList"
						output-model="cappsEditRegMap._selectedDestinationRegion"
						button-label="regionName"
						item-label="regionName"
						translation="cappsEditRegMap.localLangRegionList"
						tick-property="selected"
						helper-elements="filter"
						selection-mode="single"
						is-required="true"
						class="isteven-multi-select user-group-select"
						on-close="cappsEditRegMap.destinationRegionChanged()"
						/>
					<span class="help-block" data-ng-show="cv.cappsEditRegMapForm.needsAttention(cappsEditRegMapForm.destinationRegion)">
						<cv:msg key="error.region" bundle="ediscovery"/>
					</span>
				</div>
			</div>
		</div>
		</div>
		<div class="modal-footer">
			<button id="cappsEditRegionMapping_CancelButton" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cappsEditRegMap.cancel()">
				<cv:msg key="Cancel" bundle="messages"/>
			</button>
			<button id="cappsEditRegionMapping_OkButton" class="btn btn-primary cvBusyOnAjax" type="submit" >
				<cv:msg key="OK" bundle="messages"/>
			</button>
		</div>
	</form>
</div>
