<!-- This tempate can be reused for Salesforce configuration, e.g. startup wizard, configuration wizard, and modals -->
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
</script>
<!-- General Start-->
<script type="text/ng-template" id="cappsSalesforceTemplateGeneral">
	<div data-ng-init="leftGrid=['col-xs-12', 'col-lg-5']"></div>
	<div data-ng-init="rightGrid=['col-xs-12','col-lg-7']"></div>
	<div data-ng-if="sfConfigCtrl.ui.showGeneralTab">
	<div data-ng-class='{"panel panel-default": sfConfigCtrl.ui.isWizard}'>
	<div data-ng-class='{"panel-body": sfConfigCtrl.ui.isWizard}'>
	<h4 data-ng-if="sfConfigCtrl.ui.isWizard" ><cv:msg key="label.cAppClientGeneral" bundle="capps"/></h4>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showClientProp">
					<div data-ng-class="leftGrid">
						<label for="clientName" >
							<cv-help-text help-label="label.clientName" help-text="label.appNameTip" />
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<input type="text" name="clientName" id="clientName" data-ng-model="sfConfigCtrl.model.entity.clientName" required placeholder='<cv:msg key="label.clientName" bundle="capps"/>'/>
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.clientName.$error.required">
							<cv:msg key="error.clientName" bundle="capps"/>
						</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showInstanceProp">
					<div data-ng-class="leftGrid">
						<label for="instanceName">
							<cv-help-text help-label='label.instanceName' help-text='label.instanceNameTip' />
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<input type="text" name="instanceName" id="instanceName" data-ng-model="sfConfigCtrl.model.entity.instanceName" required placeholder='<cv:msg key="label.instanceName" bundle="clients"/>'/>
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.instanceName.$error.required">
							<cv:msg key="error.instanceName" bundle="clients"/>
						</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.isAddSubclient">
					<div data-ng-class="leftGrid">
						<label for="subclientName" >
							<cv:msg key="label.SubclientName" bundle="clients"/>
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<input type="text" name="subclientName" id="subclientName" data-ng-model="sfConfigCtrl.model.entity.subclientName" required placeholder='<cv:msg key="label.SubclientName" bundle="clients"/>'/>
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.subclientName.$error.required">
							<cv:msg key="error.subclientName" bundle="clients"/>
						</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showInstanceProp">
					<div data-ng-class="leftGrid">
						<label for="backupClient" >
							<cv:msg key="label.backupClientAccNode" bundle="capps"/>
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<select name="backupClient" id="backupClient" data-ng-options="backupClient as backupClient.clientName for backupClient in sfConfigCtrl.backupClientList track by backupClient.clientName"
						data-ng-model="sfConfigCtrl.model.instanceDetail.cloudAppsInstance.generalCloudProperties.proxyServers[0]" required>
							<option value=""><cv:msg key="placeholder.backupClientAccNode" bundle="capps"/></option>
						</select>
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.backupClient.$error.required">
							<cv:msg key="error.backupClientAccNode" bundle="capps"/>
						</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showSubclientProp">
					<div data-ng-class="leftGrid">
						<label for="plan">
							<cv:msg key="label.plan" bundle="capps"/>
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<select name="plan" id="plan" data-ng-options="profile.plan.planId as profile.plan.planName for profile in sfConfigCtrl.profileList | orderBy: 'plan.planName'"
							data-ng-model="sfConfigCtrl.model.planId" required>
							<option value=""><cv:msg key="placeholder.plan" bundle="capps"/></option>
						</select>
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.plan.$error.required">
							<cv:msg key="error.plan" bundle="capps"/>
						</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showSubclientProp">
					<div data-ng-class="leftGrid">
						<label for="dataBackupStreams" >
							<cv:msg key="label.dataBackupStreams" bundle="capps"/>
						</label>
					</div>
					<div data-ng-class="rightGrid" class="text-left">
						<input type="number" name="dataBackupStreams" id="dataBackupStreams" data-ng-model="sfConfigCtrl.model.numberOfBackupStreams" min="1" max="99" required placeholder='<cv:msg key="label.dataBackupStreams" bundle="capps"/>'>
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && (salesforceConfigForm.dataBackupStreams.$error.required || !salesforceConfigForm.dataBackupStreams.$valid)">
							<cv:msg key="error.dataBackupStreams" bundle="capps"/>
						</span>
					</div>
			</div>
	</div>
</div>
</script>
<!-- General End-->
<!-- Connection Details Start-->
<script type="text/ng-template" id="cappsSalesforceTemplateConnectionDetails">
	<div data-ng-init="leftGrid=['col-xs-12', 'col-lg-5']"></div>
	<div data-ng-init="rightGrid=['col-xs-12','col-lg-7']"></div>
	<div data-ng-if="sfConfigCtrl.ui.showConnectionDetailsTab">
<div data-ng-class='{"panel panel-default": sfConfigCtrl.ui.isWizard}'>
<div data-ng-class='{"panel-body": sfConfigCtrl.ui.isWizard}'>
			<h4 data-ng-if="sfConfigCtrl.ui.isWizard"><cv:msg key="label.cAppClientConnDet" bundle="capps" /></h4>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showInstanceProp">
					<div data-ng-class="leftGrid">
						<label for="salesforceLoginUrl" >
								<cv:msg key="label.salesforceLoginUrl" bundle="capps" />
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<input type="text" name="salesforceLoginUrl" id="salesforceLoginUrl" data-ng-model="sfConfigCtrl.model.instanceDetail.cloudAppsInstance.salesforceInstance.endpoint" required placeholder='<cv:msg key="label.salesforceLoginUrl" bundle="capps" />' />
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.salesforceLoginUrl.$error.required">
							<cv:msg key="error.salesforceLoginUrl" bundle="capps" />
						</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showBackupsetProp">
					<div data-ng-class="leftGrid">
						<label for="sfUserName">
								<cv:msg key="label.userName" bundle="servers" />
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<input type="text" name="sfUserName" id="sfUserName" data-ng-model="sfConfigCtrl.model.backupsetDetail.cloudAppsBackupset.salesforceBackupSet.userPassword.userName" required placeholder='<cv:msg key="placeholder.sfUserName" bundle="capps" />' />
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.sfUserName.$error.required">
							<cv:msg key="error.userName" bundle="servers" />
						</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showBackupsetProp">
					<div data-ng-class="leftGrid">
						<label for="sfPassword">
								<cv:msg key="label.password" bundle="users" />
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<input type="password" name="sfPassword" id="sfPassword" data-ng-model="sfConfigCtrl.model.sfPassword" required placeholder='<cv:msg key="label.password" bundle="users" />' />
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.sfPassword.$error.required">
							<cv:msg key="error.password" bundle="users" />
						</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showBackupsetProp">
					<div data-ng-class="leftGrid">
						<label for="apiToken">
								<cv:msg key="label.apiToken" bundle="capps" />
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<input type="password" name="apiToken" id="apiToken" data-ng-model="sfConfigCtrl.model.token" placeholder='<cv:msg key="label.apiToken" bundle="capps" />' />
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showInstanceProp">
					<div data-ng-class="leftGrid">
						<label for="consumerKey">
								<cv:msg key="label.consumerKey" bundle="capps" />
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<input type="text" name="consumerKey" id="consumerKey" data-ng-model="sfConfigCtrl.model.instanceDetail.cloudAppsInstance.salesforceInstance.consumerId" required placeholder='<cv:msg key="label.consumerKey" bundle="capps" />' />
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.consumerKey.$error.required">
							<cv:msg key="error.consumerKey" bundle="capps" />
						</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showInstanceProp">
					<div data-ng-class="leftGrid">
						<label for="consumerSecret">
								<cv:msg key="label.consumerSecret" bundle="capps" />
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<input type="password" name="consumerSecret" id="consumerSecret" data-ng-model="sfConfigCtrl.model.consumerSecret" required placeholder='<cv:msg key="label.consumerSecret" bundle="capps" />' />
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.consumerSecret.$error.required">
							<cv:msg key="error.consumerSecret" bundle="capps" />
						</span>
					</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showBackupsetProp">
				<label data-ng-class="leftGrid" for="mutualAuthCert">
					<cv-help-text help-label="label.mutualAuthCert" help-text="help.mutualAuthCert"></cv-help-text>
					<span class="optional-text"><cv:msg key="label.optional" bundle="restore" /> </span>
				</label>
				<div data-ng-class="rightGrid">
					<div class="input-group">
						<input type="text" name="mutualAuthCert" placeHolder="<cv:msg key='label.mutualAuthCert' bundle='capps'/>"
							data-ng-model="sfConfigCtrl.model.backupsetDetail.cloudAppsBackupset.salesforceBackupSet.mutualAuthPath"/>
						<span class="input-group-btn">
							<cv-machine-browse folders-only="false" button-label='<cv:msg key="label.browse" bundle="restore"/>' data-ng-disabled="!sfConfigCtrl.model.instanceDetail.cloudAppsInstance.generalCloudProperties.proxyServers[0]"
								client-id='{{sfConfigCtrl.model.instanceDetail.cloudAppsInstance.generalCloudProperties.proxyServers[0].clientId}}' result-function="sfConfigCtrl.mutualAuthCertResultFunc"/>
						</span>
					</div>
				</div>
			</div>
			<div class="form-group" data-ng-if="sfConfigCtrl.ui.showBackupsetProp">
					<div class="col-xs-12 text-right">
						<button id="cappsConfigurationSFTemplate_button_#6914" type="button" data-ng-click="sfConfigCtrl.validateSalesforceConnection()" class="btn btn-default pull-right cvBusyOnAjax" data-ng-disabled="!sfConfigCtrl.enableValidateSalesforceConnection()"> 
							<cv:msg key="label.testConnection" bundle="capps" />
						</button>
					</div>
			</div>
		</div>
		<div class="form-group" data-ng-if="sfConfigCtrl.ui.showBackupsetProp">
				<div class="col-xs-12 text-left">
					<label data-ng-class="{'padding-left-20': sfConfigCtrl.ui.isWizard}"><strong><cv:msg key="note.prefix" bundle="capps" /></strong> <cv:msg key="note.userNameAsBackupsetName" bundle="capps" /></label>
				</div>
		</div>
	</div>
</div>
</script>
<!-- Connection Details End -->
<!-- Content Start -->
<script type="text/ng-template" id="cappsSalesforceTemplateContent">
	<div data-ng-init="leftGrid=['col-xs-12', 'col-lg-5']"></div>
	<div data-ng-init="rightGrid=['col-xs-12','col-lg-7']"></div>
 	<div data-ng-if="sfConfigCtrl.ui.showContentTab">
		<div class="form-group" data-ng-show="sfConfigCtrl.model.subclientDetail.commonProperties.isDefaultSubclient">
				<div data-ng-class="leftGrid">
					<label><cv:msg key="label.backupContent" bundle="capps" /></label>
				</div>
				<div data-ng-class="rightGrid">
					<div class="col-xs-12">
							<input type="checkbox" id="sfObjects" data-ng-model="sfConfigCtrl.model.subclientDetail.cloudAppsSubClientProp.salesforceSubclient.backupSfObjects" data-ng-disabled="true" />
							<label class="checkbox-label" for="sfObjects">
								<cv:msg key="label.sfObjects" bundle="capps" />
							</label>
					</div>
					<div class="col-xs-12">
							<input type="checkbox" id="sfFiles" data-ng-model="sfConfigCtrl.model.subclientDetail.cloudAppsSubClientProp.salesforceSubclient.backupFileObjects" />
							<label class="checkbox-label" for="sfFiles">
								<cv:msg key="label.sfFiles" bundle="capps" />
							</label>
					</div>
					<div class="col-xs-12">
							<input type="checkbox" id="sfMetadata" data-ng-model="sfConfigCtrl.model.subclientDetail.cloudAppsSubClientProp.salesforceSubclient.backupSFMetadata" />
							<label class="checkbox-label" for="sfMetadata">
								<cv:msg key="label.sfMetadata" bundle="capps" />
							</label>
					</div>
				</div>
		</div>
		<div class="form-group">
					<div class="col-xs-12">
							<input type="checkbox" id="backupArchDel" data-ng-model="sfConfigCtrl.model.subclientDetail.cloudAppsSubClientProp.salesforceSubclient.backupArchivedandDeletedRecs" />
							<label for="backupArchDel">
								<cv:msg key="label.backupArchDelRecs" bundle="capps" />
							</label>
					</div>
		</div>
		<div class="form-group" data-ng-if="!sfConfigCtrl.model.subclientDetail.commonProperties.isDefaultSubclient">
				<div data-ng-class="leftGrid">
					<label for="specifySfObjects">
							<cv:msg key="label.specifySfObjects" bundle="capps" />
					</label>
				</div>
				<div data-ng-class="rightGrid">
					<input type="text" name="specifySfObjects"  id="specifySfObjects" data-ng-model="sfConfigCtrl.model.specifySfObjects" required placeholder='<cv:msg key="placeholder.specifySfObjects" bundle="capps" />' />
					<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.specifySfObjects.$error.required">
						<cv:msg key="error.specifySfObjects" bundle="capps" />
					</span>
				</div>
		</div>

		<cv-salesforce-filter data-ng-if="sfConfigCtrl.isEditSubclient" subclient-info="sfConfigCtrl.model.subclientDetail" />
		
	</div>
</script>
<!-- Content End -->
<!-- Backup Options Start -->
<script type="text/ng-template" id="cappsSalesforceTemplateBackupOptions">
	<div data-ng-init="leftGrid=['col-xs-12', 'col-lg-5']"></div>
	<div data-ng-init="rightGrid=['col-xs-12','col-lg-7']"></div>
	<div data-ng-if="sfConfigCtrl.ui.showBackupOptionsTab">
				<div class="form-group">
					<div data-ng-class="leftGrid">
						<label for=downloadCachePath>
							<cv:msg key="label.downloadCachePath" bundle="capps" />
						</label>
					</div>
					<div data-ng-class="rightGrid">
						<div class="input-group">
							<input type="text" name="downloadCachePath" data-ng-model="sfConfigCtrl.model.backupsetDetail.cloudAppsBackupset.salesforceBackupSet.downloadCachePath" placeholder='<cv:msg key="label.downloadCachePath" bundle="capps" />' required />
							<span class="input-group-btn">
								<button id="cappsConfigurationSFTemplate_button_#4113" type="button" data-ng-click="sfConfigCtrl.browseDownloadCachePath()" class="btn btn-default" data-ng-disabled="!sfConfigCtrl.model.instanceDetail.cloudAppsInstance.generalCloudProperties.proxyServers[0]"> 
									<cv:msg key="Browse" bundle="storage" />
								</button>
							</span>
						</div>
						<span class="help-block" data-ng-show="salesforceConfigForm.$submitted && salesforceConfigForm.downloadCachePath.$error.required">
							<cv:msg key="error.downloadCachePath" bundle="capps" />
						</span>
					</div>
				</div>
				<cv-sync-database sync-database="sfConfigCtrl.model.backupsetDetail.cloudAppsBackupset.salesforceBackupSet.syncDatabase"
							  show-dummy-password="sfConfigCtrl.showDummyPassword"
							  server-message="sfConfigCtrl.serverMessage"
							  proxy-servers="sfConfigCtrl.model.instanceDetail.cloudAppsInstance.generalCloudProperties.proxyServers"
							  entity="sfConfigCtrl.model.entity">
				</cv-sync-database>
	</div>
</script>
<!-- Backup Options End -->
