<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div class="center-container setup-container" data-ng-controller = "cappsWizardConfigSfController as sfWCCtrl">
	<h1 class="page-title"><span> <cv:msg key="pageHeader.addSalesforceOrganization" bundle="capps"/></span></h1>

	<div class="row bootstrap-wrapper">
		<div class="col-xs-12 col-md-10 col-md-offset-1 col-lg-6 col-lg-offset-3">
				<form class="form-horizontal create-sfOrganization-form" data-cv-submit="sfWCCtrl.submitDetails()" 
				novalidate name="addSfOrganizationForm" autocomplete="off">
					<div>
						<div class="panel panel-default">
							<div class="panel-body">
								<h4><span> <cv:msg key="panelHeading.ConfigureApp" bundle="capps"/></h4>
								<!-- Organization Name-->
								<div class="form-group">
									<label class="col-xs-12 col-md-3" for="organizationName"><cv:msg
											key="label.name" bundle="capps" /></label>
									<div class="col-xs-12 col-md-9">
										<div class="input-group" ng-if="sfWCCtrl.showAppNameInput">
											<span class="input-group-addon" style="background-color:transparent; padding:0px; border:none;"
											data-ng-bind="sfWCCtrl.salesforceAppPrefix"></span>
											<input type="text" name="organizationName" id="organizationName"
												placeholder='<cv:msg key="placeholder.appName" bundle="capps"/>'
												data-ng-model="sfWCCtrl.model.organizationName"
												data-ng-change="inputAlertFlags.organizationName = false"
												required autofocus />
										</div>
										<div ng-if="!sfWCCtrl.showAppNameInput">
											<input type="text" name="organizationName" id="organizationName"
												placeholder='<cv:msg key="placeholder.appName" bundle="capps"/>'
												data-ng-model="sfWCCtrl.model.organizationName"
												data-ng-change="inputAlertFlags.organizationName = false"
												required autofocus />
										</div>
										<span class="help-block" data-ng-if="addSfOrganizationForm.$submitted && addSfOrganizationForm.organizationName.$error.required">
											<cv:msg key="error.appName" bundle="capps"/>
										</span>
									</div>
								</div>
								<!-- Plan -->
								<div class="form-group">
									<label class="col-xs-12 col-md-3" for="plan">
											<cv:msg key="label.plan" bundle="capps"/>
									</label>
									<div class="col-xs-12 col-md-9" data-ng-disabled="sfWCCtrl.planAvailable">
										<isteven-multi-select
											input-model="sfWCCtrl.planList"
											output-model="sfWCCtrl.model.planId"
											button-label="planName"
											item-label="planName"
											tick-property="selected"
											class="isteven-multi-select user-group-select"
											id="planName"
											selection-mode="single"
											on-item-click="clickPlan(data)"
											max-labels="1"
											helper-elements="filter"
											translation="localLang"
											>
										</isteven-multi-select>
										<div class="help-block"
											data-ng-if="addSfOrganizationForm.$submitted"
											data-ng-show="!sfWCCtrl.model.planId.length">
											<cv:msg key="error.plan" bundle="capps" />
										</div>
										<div class="help-block"
											data-ng-if="sfWCCtrl.connectedAppCredentialsError">
											<cv:msg key="error.connectedAppCredentials" bundle="capps" />
										</div>										
									</div>
								</div>
								<!-- Plan end-->
							</div>
						</div>
						<!-- Configure Client End-->
						<!-- Catalog DB details-->
						<uib-accordion close-others="false" class="text-left" data-ng-if="sfWCCtrl.planSelected && !sfWCCtrl.isResourcePoolConfigured">
							<div uib-accordion-group class="panel panel-default"
								data-is-open="sfWCCtrl.sfCatalogDBDetails">
								<uib-accordion-heading class="panel-info">
									<cv:msg key="label.infrastructurePane" bundle="exchange" />
									<i class="float-right glyphicon"
									data-ng-class="{'glyphicon-chevron-down': sfWCCtrl.sfCatalogDBDetails , 'glyphicon-chevron-right': !sfWCCtrl.sfCatalogDBDetails}"></i>
								</uib-accordion-heading>
								<!-- Access node-->
								<cv-capps-access-nodes instance-type="sfWCCtrl.cloudAppTypeKey"  
									selected-access-nodes-list="sfWCCtrl.model.proxyServers" 
									submit-attempted="sfWCCtrl.submitAttempted"
									label-class="sfWCCtrl.labelClass"
									input-class="sfWCCtrl.inputClass"
								>
								</cv-capps-access-nodes>
								<div class="form-group">
									<div class="col-xs-12 col-md-3">
										<label>
											<cv-help-text help-label="label.downloadCachePath" help-text="helpText.downloadCachePath"/>
										</label>
									</div>
									<div class="col-xs-12 col-md-9">
										<div class="input-group" data-ng-if="sfWCCtrl.model.proxyServers[0].client.clientId">
											<input type="text" name="downloadCachePath" data-ng-model="sfWCCtrl.model.downloadCachePath" placeholder='<cv:msg key="label.downloadCachePath" bundle="capps" />' />
											<span class="input-group-btn">
												<a href="" class="btn btn-ternary padding-3 rounded-border-radius" data-ng-click="sfWCCtrl.browseDownloadCachePath()" title="<cv:msg key="Browse" bundle="storage" />">
													<span class="k-icon k-i-folder-more font-size-page-title"></span>
												</a>
											</span>
										</div>
										<div data-ng-if="!sfWCCtrl.model.proxyServers[0].client.clientId">
											<input type="text" name="downloadCachePath" data-ng-model="sfWCCtrl.model.downloadCachePath" placeholder='<cv:msg key="label.downloadCachePath" bundle="capps" />' />
										</div>
										<span class="help-block" data-ng-show="addSfOrganizationForm.$submitted && !sfWCCtrl.model.downloadCachePath">
											<cv:msg key="error.downloadCachePath" bundle="capps" />
										</span>
									</div>
								</div>
								<!-- Access node end-->
								<cv-sync-database sync-database="sfWCCtrl.model.syncDatabase"
												show-dummy-password="sfWCCtrl.showDummyPassword"
												server-message="sfWCCtrl.serverMessage"
												proxy-servers="sfWCCtrl.model.proxyServers"
												entity="sfWCCtrl.model.entity"
												submit-attempted="sfWCCtrl.submitAttempted"
												label-class="sfWCCtrl.labelClass"
												input-class="sfWCCtrl.inputClass"
												>
								</cv-sync-database>
							</div>
						</uib-accordion>
						<!-- Catalog DB details end-->
						<!-- Salesforce account details accordion-->
						<uib-accordion close-others="false" class="text-left">
							<div uib-accordion-group class="panel panel-default"
								data-is-open="sfWCCtrl.sfAccountDetails">
								<uib-accordion-heading class="panel-info">
									<cv:msg key="header.salesforceAcctDetails" bundle="capps" />
									<i class="float-right glyphicon"
									data-ng-class="{'glyphicon-chevron-down': sfWCCtrl.sfAccountDetails , 'glyphicon-chevron-right': !sfWCCtrl.sfAccountDetails}"></i>
								</uib-accordion-heading>
								<cv-salesforce-account-details salesforce-account="sfWCCtrl.model.salesforceAccount" proxy-servers="sfWCCtrl.model.proxyServers">
								</cv-salesforce-account-details>
							</div>
						</uib-accordion>
						<!-- Salesforce account details accordion end-->
						
					</div>
					<!-- Buttons -->
					<div class="button-container">
						<button id="acreateSfOrganizationApp_button_cancel" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="sfWCCtrl.cancel()"><cv:msg key="Cancel" bundle="messages" /></button>
						<button id="createSfOrganizationApp_button" type="submit" class="btn btn-primary cvBusyOnAjax"> <cv:msg key="Save" bundle="messages" /></button>
					</div>
				</form>
		</div>
	</div>
</div>
