<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div data-ng-init="leftGrid=['col-xs-12', 'col-lg-5']"></div>
<div data-ng-init="rightGrid=['col-xs-12', 'col-lg-7']"></div>
<div>
	<div class="setup-title">
		<h3><span> <cv:msg key="label.compareOptions" bundle="capps" /></span></h3>
	</div>
	<span class="serverMessage {{sfCompare.serverMessage.type}}" data-ng-bind="sfCompare.serverMessage.message"></span>
	<form class="form-horizontal" name="salesforceCompareForm" cv-hide-api novalidate autocomplete="off" cv-submit="sfCompare.submit()">
		<div class="bootstrap-wrapper" >
			<div class='modal-body'>

				<div data-ng-class="{'panel panel-default': sfCompare.isMetadataCompare && !sfCompare.isSaaS}">
					<div data-ng-class="{'panel-body': sfCompare.isMetadataCompare && !sfCompare.isSaaS}">
						<div class="form-group">
							<div data-ng-class="leftGrid">
								<label for="sourceDate">
									<cv:msg key="label.sourceDate" bundle="capps" />
								</label>
							</div>
							<div data-ng-class="rightGrid">
								<div class="input-group">
									<input type="text" name="sourceDate" data-ng-model="sfCompare.model.sourceDate" required/>

									<span class="input-group-btn">
										<cv-date-time  heading-label='<cv:msg key="prompt.sourceDate" bundle="capps" />' result-function="sfCompare.sourceDateResultFunction" skip-cv-utc-conversion="true" >
									    	<button id="cappsCompareOptionsSF_button_#2502" type="button" class="btn btn-default"  title='<cv:msg key="label.changeDate" bundle="capps" />'>
												<i class="glyphicon glyphicon-calendar"></i>
											</button>
										</cv-date-time>
									</span>
								</div>
								<span class="help-block" data-ng-show="cv.salesforceCompareForm.needsAttention(salesforceCompareForm.sourceDate) || sfCompare.isInvalidDate(sfCompare.model.sourceDate)">
									<cv:msg key="error.sourceDate" bundle="capps" />
								</span>
							</div>
						</div>
						<!-- Dummy group to add gap -->
						<div class="form-group"></div>
					</div>

				</div>


				<!--  RESTORE DETAILS PANEL -->
				<uib-accordion data-ng-if="sfCompare.isMetadataCompare && !sfCompare.isSaaS" close-others="false" class="text-left">
					<div uib-accordion-group data-is-open="sfCompare.openDestinationSection" data-ng-init="sfCompare.openDestinationSection=true">
						<uib-accordion-heading> <cv:msg key="label.destinationToCompare" bundle="capps" /> <i
							class="float-right glyphicon"
							data-ng-class="sfCompare.openDestinationSection ? 'glyphicon-chevron-down' : 'glyphicon-chevron-right'"></i></uib-accordion-heading>

						<div class="form-group">
							<div data-ng-class="leftGrid" >
								<label><cv:msg key="label.destinationOrganization" bundle="capps"/></label>
							</div>
							<div data-ng-class="rightGrid">
								<select name="destClient" data-ng-model="sfCompare.model.destinationClient" data-ng-change="sfCompare.resetInstances()" data-ng-options="server.clientName for server in sfCompare.destinationClientList" required>
								</select>
								<span class="help-block" data-ng-show="cv.salesforceCompareForm.needsAttention(salesforceCompareForm.destClient)">
									<cv:msg key="error.destinationOrganization" bundle="capps"/>
								</span>
							</div>
						</div>

						<div class="form-group" data-ng-if="sfCompare.destinationInstanceList.length > 1">
							<div data-ng-class="leftGrid">
								<label>
									<cv:msg key="label.destinationInstance" bundle="restore"/>
								</label>
							</div>
							<div data-ng-class="rightGrid">
								<select name="destInstance" data-ng-model="sfCompare.model.destinationInstance" data-ng-change="sfCompare.resetBackupsets()" data-ng-options="instance.instance.instanceName for instance in sfCompare.destinationInstanceList" required>
								</select>
								<span class="help-block" data-ng-show="cv.salesforceCompareForm.needsAttention(salesforceCompareForm.destInstance)">
									<cv:msg key="error.DestinationInstance" bundle="restore"/>
								</span>
							</div>
						</div>

						<div class="form-group" data-ng-show="sfCompare.destinationBackupsetList.length > 1">
							<div data-ng-class="leftGrid">
								<label>
									<cv:msg key="label.destinationBackupset" bundle="capps"/>
								</label>
							</div>
							<div data-ng-class="rightGrid">
								<select name="destBackupset" data-ng-model="sfCompare.model.destinationBackupset" data-ng-change="sfCompare.resetSubclients()" data-ng-options="backupset.backupSetEntity.backupsetName for backupset in sfCompare.destinationBackupsetList" required>
								</select>
								<span class="help-block" data-ng-show="cv.salesforceCompareForm.needsAttention(salesforceCompareForm.destBackupset)">
									<cv:msg key="error.destinationBackupset" bundle="capps"/>
								</span>
							</div>
						</div>
						<div class="form-group"  data-ng-show="sfCompare.destinationSubclientList.length > 1">
							<div data-ng-class="leftGrid">
								<label>
									<cv:msg key="label.destinationSubclient" bundle="capps"/>
								</label>
							</div>
							<div data-ng-class="rightGrid">
								<select name="destSubclient" data-ng-model="sfCompare.model.destinationSubclient" data-ng-options="subclient.subClientEntity.subclientName for subclient in sfCompare.destinationSubclientList" required>
								</select>
								<span class="help-block" data-ng-show="cv.salesforceCompareForm.needsAttention(salesforceCompareForm.destSubclient)">
									<cv:msg key="error.destinationSubclient" bundle="capps"/>
								</span>
							</div>
						</div>
					</div>
				</uib-accordion>

				<div data-ng-if="sfCompare.isMetadataCompare && sfCompare.isSaaS">
					<div class="form-group">
						<div data-ng-class="leftGrid" >
							<label><cv:msg key="label.destinationOrganization" bundle="capps"/></label>
						</div>
						<div data-ng-class="rightGrid">
							<select name="destOrg" data-ng-model="sfCompare.model.destinationOrg" data-ng-options="org.entity.instanceName for org in sfCompare.destinationOrgList" required>
							</select>
							<span class="help-block" data-ng-show="cv.salesforceCompareForm.needsAttention(salesforceCompareForm.destOrg)">
								<cv:msg key="error.destinationOrganization" bundle="capps"/>
							</span>
						</div>
					</div>
					<!-- Dummy group to add gap -->
					<div class="form-group"></div>
				</div>


				<div data-ng-class="{'panel panel-default': sfCompare.isMetadataCompare && !sfCompare.isSaaS}">
					<div data-ng-class="{'panel-body': sfCompare.isMetadataCompare && !sfCompare.isSaaS}">
						<div class="form-group">
							<div data-ng-class="leftGrid">
								<label for="destDate">
									<cv:msg key="label.dateToCompare" bundle="capps" />
								</label>
							</div>
							<div data-ng-class="rightGrid">
								<div class="input-group">
									<input type="text" name="destDate" data-ng-model="sfCompare.model.destDate" required/>

									<span class="input-group-btn">
										<cv-date-time  heading-label='<cv:msg key="prompt.dateToCompare" bundle="capps" />' result-function="sfCompare.destDateResultFunction" skip-cv-utc-conversion="true" >
									    	<button id="cappsCompareOptionsSF_button_#3203" type="button" class="btn btn-default"  title='<cv:msg key="label.changeDate" bundle="capps" />'>
												<i class="glyphicon glyphicon-calendar"></i>
											</button>
										</cv-date-time>
									</span>
								</div>
								<span class="help-block" data-ng-show="cv.salesforceCompareForm.needsAttention(salesforceCompareForm.destDate) || sfCompare.isInvalidDate(sfCompare.model.destDate)">
									<cv:msg key="error.dateToCompare" bundle="capps" />
								</span>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="modal-footer">
					<button id="cappsCompareOptionsSF_button_#4200" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="sfCompare.cancel()">
					<cv:msg key="Cancel" bundle="messages" />
					</button>
					<button id="cappsCompareOptionsSF_button_#9148" type="submit" class="btn btn-primary cvBusyOnAjax">
						<cv:msg key="action.compare" bundle="capps" />
					</button>
			</div>
		</div>

	</form>
</div>