<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div data-ng-controller="cappsClientDetailsSFController as sfCCtrl">
	<span class="server-message {{sfCCtrl.serverMessage.type}}">{{sfCCtrl.serverMessage.message}}</span>
	<div class="row">
		<div class="col-md-12" data-ng-if="sfCCtrl.clientDetails">
			<h1 class="float-left">{{sfCCtrl.clientEntity.clientName}}</h1>
			<%-- <span><a href="" class="page-action-item"  data-ng-click="sfCCtrl.serverJobs()"><cv:msg key="header.jobs" bundle="capps" /></a></span> --%>
		</div>
	</div>
	<div class="row">
		<div class="col-md-6">
			<cv-tile-component data-ac-id="cappsClientDetailsSF-heading_clientGeneral-clients" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />' data-loader="sfCCtrl.clientDetails">
			<ul class="group list-style-secondary">
				<cv-tile-label-value label='<cv:msg key="label.clientName" bundle="clients"/>' value="{{sfCCtrl.clientDetails.client.clientEntity.clientName}}" ></cv-tile-label-value>
				<cv-tile-label-value label='<cv:msg key="header.type" bundle="capps"/>' value="{{sfCCtrl.cappsTypeString}}" ></cv-tile-label-value>
			</ul>
			</cv-tile-component>
		</div>
		<div class="col-md-6">
			<span data-ng-if="sfCCtrl.formattedSecurityAssociations">
				<cv-security-component entity-type='sfCCtrl.entityType' generic-entity='sfCCtrl.genericEntity' associations='sfCCtrl.formattedSecurityAssociations' associations-loaded='sfCCtrl.associationsLoaded' data-show-Owners='true'>
				</cv-security-component>
			</span>
		</div>
	</div>
 		  <cv-grid cv-grid-options="sfCCtrl.gridOptions"></cv-grid>
</div>