<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.users"></cv:cvMessages>
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
</script>
<div data-ng-controller = "salesforceBackupSetDetails as sfBCtrl">
 <div class="row">
	<div class="col-md-12">
		<h1 class="float-left" data-ng-bind="sfBCtrl.backupSetDetails.backupSetEntity.backupsetName" data-ng-show="sfBCtrl.serverMessage.message==''"></h1>
		<span class="server-message {{sfBCtrl.serverMessage.type}}" data-ng-bind="sfBCtrl.serverMessage.message"></span>
		<span data-ng-if="sfBCtrl.backupSetDetails"><a class="page-action-item" href="" data-ng-click="sfBCtrl.loadRestoreHistoryUrl()"><cv:msg key="label.RestoreHistory" bundle="clients" /></a></span>
		<span data-ng-if="sfBCtrl.backupSetDetails"><a class="page-action-item" href="" data-ng-click="sfBCtrl.loadBackupHistoryUrl()"><cv:msg key="label.BackupHistory" bundle="clients" /></a></span>
		<span data-ng-if="sfBCtrl.backupSetDetails"><a class="page-action-item" href="#/salesForce/dataMaskingSF/{{sfBCtrl.clientId}}/{{sfBCtrl.instanceId}}/?backupsetId={{sfBCtrl.backupsetId}}"><cv:msg key="label.dataMasking" bundle="capps" /></a></span>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="cappsBackupSetDetailsSF-label_backupOptions-capps" data-title='<cv:msg key="label.backupOptions" bundle="capps"/>' data-loader="sfBCtrl.backupSetDetails">
		<div>
			<ul class="list-style-secondary">
				<cv-tile-label-value label='<cv:msg key="label.downloadCachePath" bundle="capps"/>' value="{{sfBCtrl.salesforceBackupSet.downloadCachePath}}" ></cv-tile-label-value>
				<cv-tile-label-value label='<cv:msg key="label.syncToDatabase" bundle="capps"/>' value="{{sfBCtrl.salesforceBackupSet.syncDatabase.dbEnabled | boolToString}}" ></cv-tile-label-value>
				<div data-ng-if="sfBCtrl.salesforceBackupSet.syncDatabase.dbEnabled">
				<cv-tile-label-value label='<cv:msg key="label.databaseType" bundle="capps"/>' value="{{sfBCtrl.salesforceBackupSet.syncDatabase.dbType}}" ></cv-tile-label-value>
				<cv-tile-label-value label='<cv:msg key="label.databaseHost" bundle="capps"/>' value="{{sfBCtrl.salesforceBackupSet.syncDatabase.dbHost}}" ></cv-tile-label-value>
				<cv-tile-label-value data-ng-if="sfBCtrl.salesforceBackupSet.syncDatabase.dbInstance" label='<cv:msg key="label.serverInstanceName" bundle="capps"/>' value="{{sfBCtrl.salesforceBackupSet.syncDatabase.dbInstance}}" ></cv-tile-label-value>
				<cv-tile-label-value label='<cv:msg key="label.databaseName" bundle="capps"/>' value="{{sfBCtrl.salesforceBackupSet.syncDatabase.dbName}}" ></cv-tile-label-value>
				<cv-tile-label-value label='<cv:msg key="label.databasePort" bundle="capps"/>' value="{{sfBCtrl.salesforceBackupSet.syncDatabase.dbPort}}" ></cv-tile-label-value>
				<cv-tile-label-value label='<cv:msg key="label.userName" bundle="servers"/>' value="{{sfBCtrl.salesforceBackupSet.syncDatabase.dbUserPassword.userName}}" ></cv-tile-label-value>
				</div>
			</ul>
		</div>
		<div class="page-details-box-links">
                <a href="" data-ng-click="sfBCtrl.editBackupset('BACKUP OPTIONS')"><cv:msg key="action.edit.only" bundle="capps" />
                </a>
            </div>
		</cv-tile-component>
	</div>
	<div class="col-md-6">
		<cv-tile-component data-ac-id="cappsBackupSetDetailsSF-label_cAppClientConnDet-capps" data-title='<cv:msg key="label.cAppClientConnDet" bundle="capps"/>' data-loader="sfBCtrl.backupSetDetails">
		<div>
			<ul class="list-style-secondary">
				<cv-tile-label-value label='<cv:msg key="label.userName" bundle="servers"/>' value="{{sfBCtrl.salesforceBackupSet.userPassword.userName}}" ></cv-tile-label-value>
				<cv-tile-label-value data-ng-if="sfBCtrl.salesforceBackupSet.mutualAuthPath" label='<cv:msg key="label.mutualAuthCert" bundle="capps"/>' value="{{sfBCtrl.salesforceBackupSet.mutualAuthPath}}" ></cv-tile-label-value>
			</ul>
		</div>
		<div class="page-details-box-links">
                <a href="" data-ng-click="sfBCtrl.editBackupset('CONNECTION DETAILS')"><cv:msg key="action.edit.only" bundle="capps" />
                </a>
            </div>
		</cv-tile-component>
		<cv-security-component entity-type='sfBCtrl.entityType' generic-entity = 'sfBCtrl.genericEntity' associations='sfBCtrl.formattedSecurityAssociations' associations-loaded="sfBCtrl.associationsLoaded" data-show-Owners='true'>
		</cv-security-component>
	</div>
</div>
<cv-grid cv-grid-options="sfBCtrl.gridOptions"></cv-grid>
</div>