 <%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.capps"></cv:cvMessages>
    <cv:cvMessages bundle="localization.cloudStorageApp"></cv:cvMessages>
    <cv:cvMessages bundle="localization.cloudStorageAppJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.users"></cv:cvMessages>

</script>
<div class="setup-title">
    <h1>
		<cv-help-text help-label="{{::aGApp.dialogTile}}" help-text="aGApp.dialogHelpText" use-icon=true/>
    </h1>
</div>
<div class="bootstrap-wrapper modal-margin">
    <p>
		<span class="{{aGApp.type}} serverMessage no-margin">{{aGApp.addCloudStorageMessage.message}}</span>
	</p>
    <form id="add-git-app-form" class="form-horizontal" name="addCloudStorageForm" novalidate data-cv-submit="aGApp.addOrEditCloudStorage()" autocomplete="off">
        <div class="form-group" data-ng-if="!aGApp.isAddRepo && !aGApp.isEditRepo && !aGApp.isEditAccessNode">
			<label class="col-xs-12 col-md-4 col-lg-4" for="cloudStorageName"><cv:msg key="label.appName" bundle="capps" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="text" name="cloudStorageName" id="cloudStorageName" data-ng-model="aGApp.model.cloudStorageName" data-ng-required="true" />
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.cloudStorageName)">
                      <cv:msg key="error.cloudStorageName" bundle="capps" />
                </span>
			</div>
        </div>
        <div class="form-group" data-ng-if="aGApp.isAddRepo">
			<label class="col-xs-12 col-md-4 col-lg-4" for="repositoryGroupName"><cv:msg key="label.repositoryGroupName" bundle="capps" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="text" name="repositoryGroupName" id="repositoryGroupName" data-ng-model="aGApp.model.repositoryGroupName" data-ng-required="true" />
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.repositoryGroupName)">
                      <cv:msg key="error.repositoryGroupName" bundle="capps" />
                </span>
			</div>
		</div>
        <div class="form-group" data-ng-if="!aGApp.isEdit && !aGApp.isAddRepo && !aGApp.isEditRepo && !aGApp.isVendorSelected && !aGApp.isEditAccessNode">
			<label class="col-xs-12 col-md-4 col-lg-4" for="gitAppTypeKey"><cv:msg key="label.vendorType" bundle="capps" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<isteven-multi-select id="addCloudStorageContent_isteven-multi-select_#6986"
                                input-model="aGApp.model.gitAppTypes"
                                output-model="aGApp.model.selectedGitAppType"
                                button-label="name"
                                item-label="name"
                                directive-id="gitAppTypeKey"
                                tick-property="selected"
                                selection-mode="single"
                                class="isteven-multi-select user-group-select single-select"
                                name="gitAppTypeKey"
                                helper-elements="filter"
                                search-limit="10"
                                max-labels="1"
                                translation="aGApp.localLang"
                                on-close="function()"
                                on-item-click="aGApp.changeLabelsByCloudStorageAppType(aGApp.model.selectedGitAppType)">
                </isteven-multi-select>
                <span class="help-block" data-ng-show="aGApp.addCloudStorageAttempted && !aGApp.model.gitAppTypeKey">
                	<cv:msg key="error.vendorType" bundle="capps" />
                </span>
			</div>
		</div>

        <div class="form-group" data-ng-if="aGApp.isServerAndAccountNameDifferent && !aGApp.isAddRepo && !aGApp.isEditRepo && !aGApp.isEditAccessNode">
			<label class="col-xs-12 col-md-4 col-lg-4" for="accountName"><cv:msg key="label.accountName" bundle="capps" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="text" name="accountName" id="accountName" data-ng-model="aGApp.model.accountName" data-ng-required="true" />
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.accountName)">
                      <cv:msg key="error.accountName" bundle="capps" />
                </span>
			</div>
		</div>
        <div class="form-group" data-ng-if="!aGApp.isAddRepo && !aGApp.isEditRepo && aGApp.isHostURLShow && !aGApp.isEditAccessNode">
			<label class="col-xs-12 col-md-4 col-lg-4" for="hostURL"><cv:msg key="label.hostURL" bundle="capps" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="text" name="hostURL" id="hostURL" placeholder="{{aGApp.model.hostURLToolTip}}"  data-ng-model="aGApp.model.hostURL" data-ng-required="true" data-ng-disabled="aGApp.isAzureDevops"/>
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.hostURL)">
                      <cv:msg key="error.hostURL" bundle="capps" />
                </span>
			</div>
        </div>

        <div class="form-group" data-ng-if="!aGApp.isAddRepo && !aGApp.isEditRepo && !aGApp.isEditAccessNode">
			<label class="col-xs-12 col-md-4 col-lg-4" for="tokenName">{{aGApp.tokenName}}</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="text" name="tokenName" id="tokenName" placeholder="{{aGApp.model.hostURLToolTip}}"  data-ng-model="aGApp.model.tokenName" data-ng-required="true"/>
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.tokenName)">
                      <cv:msg key="error.tokenName" bundle="capps" />
                </span>
			</div>
        </div>

        <div class="form-group" data-ng-if="!aGApp.isAddRepo && !aGApp.isEditRepo && !aGApp.isEditAccessNode">
			<label class="col-xs-12 col-md-4 col-lg-4" for="accessToken"><cv:msg key="label.accessToken" bundle="capps" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="password" name="accessToken" id="accessToken" placeholder="{{aGApp.model.accessTokenToolTip}}"  data-ng-model="aGApp.model.accessToken" data-ng-required="!aGApp.isEdit"/>
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.accessToken)">
                      <cv:msg key="error.accessToken" bundle="capps" />
                </span>
			</div>
        </div>

        <div class="form-group" data-ng-if="!aGApp.isEdit && !!aGApp.model.gitAppTypeKey && aGApp.isGitHub && !aGApp.isEditAccessNode">
			<label class="col-xs-12 col-md-4 col-lg-4" for="gitAppTypeKey"><cv:msg key="label.accountType" bundle="capps" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<isteven-multi-select id="addCloudStorageContent_isteven-multi-select_#6986"
                                input-model="aGApp.model.organizationType"
                                output-model="aGApp.model.selectedOrganizationType"
                                button-label="name"
                                item-label="name"
                                directive-id="gitAppTypeKey"
                                tick-property="selected"
                                selection-mode="single"
                                class="isteven-multi-select user-group-select single-select"
                                name="gitAppTypeKey"
                                helper-elements="filter"
                                search-limit="10"
                                max-labels="1"
                                translation="aGApp.localLang"
                                on-close="function()"
                                on-item-click="aGApp.changeGitAppOrganizationType(aGApp.model.selectedOrganizationType)">
                </isteven-multi-select>
                <span class="help-block" data-ng-show="aGApp.addCloudStorageAttempted && !aGApp.model.gitAppTypeKey">
                	<cv:msg key="error.organizationType" bundle="capps" />
                </span>
			</div>
		</div>

        <div class="form-group" data-ng-if="!aGApp.isEdit && !aGApp.isEditAccessNode">
			<label class="col-xs-12 col-md-4 col-lg-4" for="organizationName">{{aGApp.organizationName}}</label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="text" name="organizationName" id="organizationName" placeholder="{{aGApp.model.hostURLToolTip}}"  data-ng-model="aGApp.model.organizationName" data-ng-required="true"/>
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.organizationName)">
                      <cv:msg key="error.gOrganizationName" bundle="capps" />
                </span>
			</div>
        </div>
        <div class="form-group"  data-ng-if="!aGApp.isAddRepo && !aGApp.isEdit && !aGApp.isEditRepo">

            <label class="col-xs-6 col-md-4 col-lg-4" for="accessNodeType"><cv:msg key="label.accessNodeType" bundle="capps" /></label>
    
            <div class="col-xs-6 col-md-8 col-lg-8">
    
                           <div class="multiple-radio-group">
    
                                <label ng-init="aGApp.model.accessNodeType = 'windows'" for="windows"><input id="windows" type="radio"
    
                           data-ng-model="aGApp.model.accessNodeType"
    
                           value="windows"
    
                           name="windowAccessNode"
    
                           data-ng-change="aGApp.changeAccessNodeType()"
    
                           class="" />
                                <cv:msg key="label.windowAccessNode" bundle="capps" /></label>
                           </div>
    
                           <div class="multiple-radio-group">
                                          <label for="unixAccessNode"><input id="unixAccessNode" type="radio" data-ng-model="aGApp.model.accessNodeType" value="unix"
                                            name="unixAccessNode"
    
                           data-ng-change="aGApp.changeAccessNodeType()" />
    
                                        <cv:msg key="label.unixAccessNode" bundle="capps" /></label></label>
    
                           </div>                                                                                                                           
    
            </div>
    
    </div>
    <!-- preventing by default sorting of the access nodes -->
    <div class="form-group margin-bottom-10" data-ng-if="!aGApp.isAddRepo && !aGApp.isEdit && !aGApp.isEditRepo">
		<label class="col-xs-12 col-md-4 col-lg-4" for="accessNode">
		<cv-help-text help-text="'<cv:msg key='info.accessNodeHelpText' bundle='cloudStorageApp'/>'"
									help-label="<cv:msg key="label.accessNode" bundle="capps" />"></cv-help-text></label>
		<div class="col-xs-12 col-md-8 col-lg-8">
            <isteven-multi-select id="addCloudStorageContent_isteven-multi-select_#7654"
                                input-model="aGApp.accessNodes"
                                output-model="aGApp.model.accessNode"
                                prevent-sort="true"
                                button-label="displayName"
                                item-label="displayName"
                                class="isteven-multi-select user-group-select"
                                tick-property="selected"
                                selection-mode="multiple"
                                name="accessNode"
                                helper-elements="all none filter reset"
                                search-limit="10"
                                max-labels="1"
                                translation="aGApp.localLang"
                                on-close="function()"
                                on-item-click="function()">
                </isteven-multi-select>
            <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.accessNode) && !aGApp.model.accessNode">
                      <cv:msg key="error.accessNode" bundle="capps" />
            </span>
		</div>
    </div>
    <div class="form-group"  data-ng-if="!aGApp.isEdit && !aGApp.isEditAccessNode">

        <label class="col-xs-6 col-md-4 col-lg-4" for="IAMRole"><cv:msg key="label.repositories" bundle="capps" /></label>

        <div class="col-xs-6 col-md-8 col-lg-8">

                       <div class="multiple-radio-group">

                            <label ng-init="aGApp.model.repositoryType = 'allRepositories'" for="IAMRole"><input id="IAMRole" type="radio"

                       data-ng-model="aGApp.model.repositoryType"

                       value="allRepositories"

                       name="authenticationType"

                       data-ng-change="aGApp.changeRepositoryType()"

                       class="" />
                                      <span class="block-indent">{{aGApp.allRepositoryLabel}}</span></label>
                       </div>

                       <div class="multiple-radio-group">
                                      <label for="AccessAndSecretKey"><input id="AccessAndSecretKey" type="radio" data-ng-model="aGApp.model.repositoryType" value="selectRepositories"
                                        name="authenticationType"

                       data-ng-change="aGApp.changeRepositoryType()" />

                                      <span class="block-indent">{{aGApp.selectRepositoryLabel}}</span></label>

                       </div>                                                                                                                           

        </div>
     
        
</div>
    <div class="form-group margin-bottom-10" data-ng-if="aGApp.model.repositoryType==='selectRepositories'">
        <label class="col-xs-12 col-md-4 col-lg-4" for="repositoryList">
        <cv-help-text help-text="'<cv:msg key='info.selectRepositoriesHelpText' bundle='capps'/>'"
                                    help-label="<cv:msg key='label.selectRepositories' bundle="capps" />"></cv-help-text></label>
        
    </div>
    <div class="form-group margin-bottom-10">
        <div class="col-xs-12 col-md-12 col-lg-12" data-ng-if="!aGApp.allRepositoriesFlag && aGApp.model.repositoryType==='selectRepositories'">
            <cv-capps-browse-content show-title="false" select-all-by-default="false" hide-search="true" entity="aGApp.selectRepositoryObj"  selected-content="aGApp.model.selectRepositories" instance-type="aGApp.model.gitAppTypeKey"/>
        </div>
        <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.accessNode) && !aGApp.model.accessNode">
                  <cv:msg key="error.selectRepositories" bundle="capps" />
        </span>
    </div>
    <div class="form-group row tooltip-reset" data-ng-if="!aGApp.isAddRepo && !aGApp.isEditRepo">
        <label class="col-xs-12 col-md-4 col-lg-4" for="stagingPath" data-uib-tooltip="<cv:msg key="label.stagingPathToolTip"  bundle="capps"/>" data-tooltip-placement="bottom" bundle="capps"><cv:msg key="label.gitStagingPath" bundle="capps" /><label class="optional-text"><cv:msg key="label.optional" bundle="capps" /></label></label>
        <div class="col-xs-6 col-md-4 col-lg-5">
            <input type="text" name="stagingPath" id="stagingPath" data-ng-model="aGApp.model.stagingPath" data-ng-required="false" />
        </div>
        <div class="col-lg-3 text-center">
            <button type="button" id="manageFSSubclientContentModal_button_#4186" class="btn btn-default cvBusyOnAjax" data-ng-click="aGApp.getStagingPath()"><cv:msg key="label.browse" bundle="capps" /></button> 
        </div>
            
    </div>
    <div class="form-group" data-ng-if="!aGApp.isAddRepo">
        <div class="col-xs-4 col-md-4 col-lg-4">
            <label for="impersonateUser">
                <cv-toggle  value="aGApp.impersonateToggleUser" toggle-model="aGApp.impersonateToggleUser"
                    on-click="aGApp.toggleOverwrite(data, type.key)"></cv-toggle>
                    <cv:msg key="label.asUser" bundle="capps" />
            </label>
        </div>
        <div class="col-xs-8 col-md-8 col-lg-8" data-ng-if="aGApp.showEditLink">
            <label>
                <a href="" data-ng-click="aGApp.showEditCredentials()"><cv:msg key="label.editToggleUser" bundle="capps" /></a>
            </label>
            
        </div>
    </div>
	<div class="margin-top-10" data-ng-if="!aGApp.isEditAccessNode">
	    <cv-entity-plan-policy-select data-cv-hide-policy-toggle-option="aGApp.hidePolicyToggleOption" data-cv-model="aGApp.planPolicyModel" data-cv-app-id="aGApp.applicationId" data-cv-client-id="aGApp.clientId" data-cv-wrapper-class="'form-group'" data-cv-label-class="'col-xs-12 col-md-4 col-lg-4'" data-cv-select-class="'col-xs-12 col-md-8 col-lg-8'">
	    </cv-entity-plan-policy-select>
	</div>
    <div class="button-container">
        <button id="addCloudStorageContent_button_#2780" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="aGApp.cancel()">
            <cv:msg key="Cancel" bundle="messages" />
        </button>
        <button id="addCloudStorageContent_button_#0001" type="submit" class="btn btn-primary cvBusyOnAjax">
            <cv:msg key="Save" bundle="messages" />
        </button>
    </div>
    
    <div class="form-group row" data-ng-if="aGApp.isEditRepo">
        <label class="col-xs-12 col-md-4 col-lg-4" for="stagingPath"><cv:msg key="label.selectedRepositories" bundle="capps" /></label>
        <div class="col-xs-6 col-md-4 col-lg-4">
            <span data-ng-if="!aGApp.contentEntityDetails || !aGApp.contentEntityDetails.length"><p class="info-place-holder"><cv:msg key="label.noRepository" bundle="capps" /></p></span>
            <ul class="list-style__row group" data-ng-repeat="contentEntity in aGApp.contentEntityDetails">
                    <li> {{contentEntity.name}} 
						<ul class="list-style__row group" data-ng-repeat="contentEntityItems in contentEntity.repositoryInfo.repositories" data-ng-if="!aGApp.isGitHub">
								<li>{{contentEntityItems.name}}</li>
						</ul>
					</li>
                    <span data-ng-if="aGApp.contentEntity.path == '/'" class='laptop-content-help-text less-padding'> - &nbsp;<cv:msg key='label.allContents' bundle='profiles'/></span>
			</ul>
        </div>
    </div>

   </form>
</div>
