<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.setup"></cv:cvMessages>
</script>
<div data-ng-controller="office365LandingPageController as office365LPCtrl">
	<h1 data-ng-class= 'page-title'><cv:msg key="label.nav.office365" bundle="navJs" /></h1>
<div class="getting-started">
	<div class="center-container setup-container">
		<div class="row">
			<div class="app-tiles">
				<div data-ng-repeat="appType in office365LPCtrl.office365AppsTypes">
								<div class="col-md-6 col-lg-6 app-setup-container">
									<div class="panel panel-default" class="clickable">
											<div class="panel-body horz-center capps-tile-wrapper">
												<div class="capps-tile-container"  data-ng-click="office365LPCtrl.handleTileClick(appType)">
													<div class="svg-primary-fill"><img ng-src={{appType.svgPath}} class="svg-primary-fill" /></div>
													<div data-ng-if="appType.setupCompleted"><a class="larger-font" href="javascript:void(0)">{{appType.localizedType}}</a></div>
													<div data-ng-if="!appType.setupCompleted"><a class="larger-font" href="javascript:void(0)">{{'label.completeSetupFor' | cvLoc:appType.localizedType}}<i style="margin-left: 5px;" class="ion-chevron-right"></i></a></div>
												</div>
												<div class="capps-tile-footer" data-ng-if="appType.setupCompleted">
													<input name="chkDefault_{{appType.type.key}}" id="chkDefault_{{appType.type.key}}" type="checkbox"
													data-ng-model="appType.isDefault"
													 data-ng-change="office365LPCtrl.defaultOffice365AppTypeChanged(appType)"
													 data-ng-disabled="appType.isDefault"
													  />
													<label for="chkDefault_{{appType.type.key}}" class="cv-checkbox-label"><cv:msg key="label.setAsDefaultApp" bundle="capps" /></label>
												</div>
											</div>
									</div>
							    </div>
						</div>
				</div>
			</div>
		</div>
	</div>
</div>
