<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>;
</script>
<jsp:include page="archiveTemplates.jsp" />
<div class="width-750-center archive-setup" ng-controller="archiveController as archCtrl">
	<form
		name="setUpArchiving"
		data-cv-submit="archCtrl.finishSetup()"
		class="form-horizontal bootstrap-wrapper"
		novalidate
		autocomplete="off"
	>
		<h1 class="page-header">
			<span ng-bind="archCtrl.heading"></span>
			<cv-help-component help-text="<cv:msg key="label.setUpFileArchivingHelpText" bundle="archiving" />" />
		</h1>
		<div
			class="{{ archCtrl.generalSetupMessage.type }} serverMessage archiving-text-align-center"
			ng-bind="archCtrl.generalSetupMessage.message"
		></div>
		<div class="panel panel-default">
			<div class="panel-body">
				<!-- // File server mode selection // -->
				<div class="form-group">
					<label class="col-lg-4" for="fileServerType">
						<cv:msg key="label.dataSource" bundle="archiving" />
					</label>
					<div class="col-lg-3">
						<input
							id="createNewChkBox"
							type="radio"
							ng-model="archCtrl.isCreateNewFileServer"
							ng-value="true"
							ng-change="archCtrl.showNdmpCredentials = true;"
						/>
						<label for="createNewChkBox" style="clear: both;"
							><cv:msg key="string.createNew" bundle="archiving"
						/></label>
					</div>
					<div class="col-lg-4">
						<input
							id="addExistingChkBox"
							type="radio"
							ng-model="archCtrl.isCreateNewFileServer"
							ng-value="false"
							ng-change="archCtrl.showNdmpCredentials = false;"
						/>
						<label for="addExistingChkBox" style="clear: both;"
							><cv:msg key="string.AddExisting" bundle="archiving"
						/></label>
					</div>
				</div>
				<ng-include src="'archivingFileServerConfiguration.html'"></ng-include>
				<ng-include src="'archivingNdmpConfiguration.html'"></ng-include>
				<ng-include src="'archivingExistingServerConfiguration.html'"></ng-include>
			</div>
		</div>
		<div class="panel panel-default">
			<div class="panel-body">
				<div ng-include src="'archivingShareTypeConfiguration.html'"></div>
			</div>
		</div>
		<div class="panel panel-default">
			<div class="panel-body">
				<ng-include src="'archivingAccessNodesConfiguration.html'"></ng-include>
			</div>
		</div>
		<div class="panel panel-default">
			<div class="panel-body">
				<ng-include src="'archivingConfiguration.html'"></ng-include>
			</div>
		</div>
		<div class="button-container">
			<button
				id="setUpFileArchiving_button_#4392"
				type="button"
				class="btn btn-default cvBusyOnAjax"
				ng-click="archCtrl.cancelSetup()"
				ng-show="archCtrl.showCancel"
			>
				<cv:msg key="action.cancel" bundle="profiles" />
			</button>
			<button
				id="setUpFileArchiving_button_#2698"
				type="submit"
				class="btn btn-primary cvBusyOnAjax"
				ng-bind="archCtrl.submitButtonName"
			></button>
		</div>
	</form>
</div>
<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>
