<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
</script>
<div class="width-750-center" data-ng-controller="archivingController as archCtrl">
<form name="setUpArchiving" data-cv-submit="archCtrl.finishSetup()"	class="form-horizontal bootstrap-wrapper" novalidate autocomplete="off">
<h1 class="page-header">
{{archCtrl.heading}}
<cv-help-component help-text="<cv:msg key="label.setUpFileArchivingHelpText" bundle="archiving" />" />
</h1>
<div>
	<div class="{{archCtrl.generalSetupMessage.type}} serverMessage archiving-text-align-center">{{archCtrl.generalSetupMessage.message}}</div>
</div>
<div class="panel panel-default">
                <div class="panel-body">
                    <div class="form-group">
                        <label class="col-lg-3" for="indexingEngine"><cv:msg key="label.configureIndexingEngine" bundle="archiving" /> </label>
                        <div class="col-xs-12 col-lg-6">
                            <select
								id="indexingEngine"  name="indexingEngine"
								data-ng-model="archCtrl.model.selectedIndexEngine" required
								data-ng-options="indexingEngine.engineName for indexingEngine in archCtrl.indexingEngines"
								data-ng-change="archCtrl.indexingEngineChanged()">
								<option value="">
									<cv:msg key="placeholder.selectIndexEngine" bundle="archiving" />
								</option>
							</select>
							<div class="help-block" data-ng-show="archCtrl.indexingEngines.length==0 || cv.setUpArchiving.needsAttention(setUpArchiving.indexingEngine)">
										<i class="ion-alert-circled"></i>
										{{archCtrl.indexingEngines.length>0 ? '<cv:msg key="error.indexingEngine" bundle="archiving" />' : '<cv:msg key="error.noIndexEngines" bundle="archiving" />'}}
					</div>
					<div data-ng-if="archCtrl.indexingEngines.length==0">
					<span><a data-ng-click="archCtrl.createIndexServer()"><cv:msg key="label.createIndexServer" bundle="archiving" /></a></span>
					</div>
					<div data-ng-if="archCtrl.showCreateIndexServerLoading" class="archivingLoading">
					<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
					<cv:msg key="label.CreatingIndexServer" bundle="archiving" />
					</div>
					</div>
                    </div>
                </div>
            </div>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="form-group">
						<label class="col-lg-3" for="fileServerType">
        				<cv:msg key="label.dataSource" bundle="archiving" />
        			</label>
						<div class="col-lg-3">
           					<input id="createNewChkBox" type="radio" ng-model="archCtrl.isCreateNewFileServer" ng-value="true" >
		   					<label for="createNewChkBox" style="clear:both"><cv:msg key="string.createNew" bundle="archiving" /></label>
		   				</div>
						<div class="col-lg-3">
							<input id="addExistingChkBox" type="radio" ng-model="archCtrl.isCreateNewFileServer" ng-value="false">
							<label for="addExistingChkBox" style="clear:both"><cv:msg key="string.AddExisting" bundle="archiving" /></label>
						</div>
					</div>
                    <div class="form-group"  data-ng-if="archCtrl.isCreateNewFileServer">
                    <label class="col-lg-3" for="Name"><cv:msg key="label.name" bundle="archiving" />
					</label>
					<div class="col-xs-12 col-lg-6">
					<input type="text" name="Name" id="Name" pattern="[^\s]+" data-ng-model="archCtrl.model.newDatasourceProps.name" required />
					<div class="help-block" data-ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.Name)">
										<i class="ion-alert-circled"></i>
										<cv:msg key="error.indexingEngineServerName" bundle="archiving" />
						</div>
					</div>
					</div>
					<div class="form-group"  data-ng-if="archCtrl.isCreateNewFileServer">
					<label for="Description" class="col-lg-3"> <cv:msg key="label.description" bundle="archiving" />
					</label>
					<div class="col-xs-12 col-lg-6">
					<textarea name="Description" id="Description" data-ng-model="archCtrl.model.newDatasourceProps.description"></textarea>
					<div class="help-block" data-ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.Description)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.datassourceDescription" bundle="archiving" />
					</div>
					</div>
					</div>
					<div class="form-group"  data-ng-if="archCtrl.isCreateNewFileServer">
					<label class="col-lg-3"> <cv:msg key="label.folderPaths"
									bundle="archiving" />
					</label>
					<div class="col-xs-12 col-lg-6">
									<div class="archiving-div-scroll">
										<ul class="manageCollectionList list-style__row group archiving-border"
											style="margin-left: 0px;"
											data-ng-repeat="folderpath in archCtrl.model.newDatasourceProps.folderpaths">
											<li data-ng-bind="folderpath" style="width: 90%"></li>
											<li style="width: 10%"><span class="delete-row"> <a
													href=""
													data-ng-click="archCtrl.removefolderPath(folderpath)"
													title="Delete content {{folderpath}}">&times;</a>
											</span></li>
										</ul>
									</div>
									<button id="setUpFileArchiving_button_#0350" type="button" class="btn btn-default cvBusyOnAjax" 
										data-ng-click="archCtrl.addFolderPaths()">
										<cv:msg key="label.addPaths" bundle="archiving" />
									</button>
						<div class="help-block" data-ng-show="!archCtrl.validFolderPaths">
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.datassourceFolderPaths" bundle="archiving" />
						</div>
					</div>
					</div>
					<div class="form-group"  data-ng-if="archCtrl.isCreateNewFileServer">
					<label class="col-lg-3" for="Username"><cv:msg key="label.userName" bundle="archiving" />
					</label>
					<div class="col-xs-12 col-lg-6">
					<input type="text" name="Username" id="Username" data-ng-model="archCtrl.model.newDatasourceProps.username"/>
					<div class="help-block" data-ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.Username)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.userName" bundle="archiving" />
					</div>
					</div>
					</div>
					<div class="form-group"  data-ng-if="archCtrl.isCreateNewFileServer">
					<label class="col-lg-3" for="password"><cv:msg key="label.password" bundle="archiving" /></label>
					<div class="col-xs-12 col-lg-6">
					<input type="password" name="password" id="password"
									data-ng-model="archCtrl.model.newDatasourceProps.archivingpasssword" maxlength="128"/>
					<div class="help-block" data-ng-show="archCtrl.showPasswordError">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.password" bundle="archiving" />
					</div>
					</div>
                    </div>
                	<div class="form-group"  data-ng-if="archCtrl.isCreateNewFileServer">
                    <label for="accessNode" class="col-lg-3"> <cv:msg key="label.accessNode" bundle="archiving" /> </label>
                	<div class="col-xs-12 col-lg-6">
                    <select id="accessNode" name="accessNode" data-ng-model="archCtrl.model.selectedAccessNode" required>
						<option value="">
							<cv:msg key="header.archiving.accessnode" bundle="archiving" />
						</option>
						<option ng-repeat="accessNode in archCtrl.accessNodes" value="{{accessNode.mediaAgentId}}">{{accessNode.mediaAgentName}}</option>
					</select>
					<div class="help-block" data-ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.accessNode)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.accessNode" bundle="archiving" />
                	</div>
                	</div>
                	</div>
                	<div class="form-group" data-ng-if="!archCtrl.isCreateNewFileServer">
        			<label class="col-lg-3" for="existingClient">
	        			<cv:msg key="label.archiving.existingFileServer" bundle="archiving" />
	        		</label>
	                <div class="col-xs-12 col-lg-6">
	                	<select id="existingClient"  name="existingClient"
									data-ng-model="archCtrl.selectedExistingClient" required
									data-ng-options="existingClient.client.clientEntity.displayName for existingClient in archCtrl.existingClients">
							<option value="">
								<cv:msg key="placeholder.selectExistingFileServer" bundle="archiving"/>
							</option>
						</select>
						<div class="help-block" data-ng-show="cv.setUpArchiving.needsAttention(setUpArchiving.existingClient)">
							<i class="ion-alert-circled"></i>
							<cv:msg key="error.existingFileServers" bundle="archiving" />
						</div>
					</div>
        			</div>
        		<div class="form-group" data-ng-show="!archCtrl.isCreateNewFileServer && archCtrl.selectedExistingClient">
        			<label class="col-lg-3" for="fileServerType">
        				<cv:msg key="label.fileserver.type" bundle="archiving" />
        			</label>
        			<div class="col-lg-6">
                    <input name="fileServerType" id="fileServerType" data-ng-model="archCtrl.selectedExistingClient.client.osInfo.Type" ng-disabled="true" style="width:inherit" />
					</div>
        		</div>
        		<div class="form-group" data-ng-show="!archCtrl.isCreateNewFileServer && archCtrl.selectedExistingClient">
        			<label class="col-lg-3" for="fileServerOS">
        				<cv:msg key="label.fileserver.OS" bundle="archiving" />
        			</label>
        			<div class="col-lg-6">
                    <input name="fileServerOS" id="fileServerOS" data-ng-model="archCtrl.selectedExistingClient.client.osInfo.OsDisplayInfo.OSName" ng-disabled="true"  style="width:inherit" />
					</div>
        		</div>
        		<div class="form-group" data-ng-show="!archCtrl.isCreateNewFileServer && archCtrl.selectedExistingClient">
        			<label class="col-lg-3" for="fileServerVersion">
        				<cv:msg key="label.fileserver.version" bundle="archiving" />
        			</label>
        			<div class="col-lg-6">
                    <input name="fileServerVersion" id="fileServerVersion" data-ng-model="archCtrl.selectedExistingClient.client.versionInfo.version" ng-disabled="true"  style="width:inherit" />
					</div>
        		</div>
        		<div class="form-group">
                	<div class="col-xs-12 col-lg-offset-3">
           				<input id="collectOwnerInfo" type="checkbox" ng-model="archCtrl.model.collectOwnerInfo" />
           				<label for="collectOwnerInfo"><cv:msg key="label.collectOwnerInfo" bundle="archiving" /></label>
		   			</div>
		   		</div>
        		<div class="form-group">
                	<div class="col-xs-12 col-lg-offset-3">
           				<input id="runNow" type="checkbox" ng-model="archCtrl.model.isRunNow"/>
           				<label for="runNow"><cv:msg key="label.archiving.runNow" bundle="archiving" /></label>
		   			</div>
		   		</div>
		   		<div class="form-group">
                	<span class="col-xs-12 col-lg-3 col-lg-offset-3">
           				<input id="scheduleToRun" type="checkbox" ng-model="archCtrl.isScheduleToRun"/>
           				<label for="scheduleToRun"><cv:msg key="label.archiving.scheduleToRun" bundle="archiving" /></label>
		   			</span>
		   			<span class="col-xs-12 col-lg-3 margin-top-10" data-ng-if="archCtrl.isScheduleToRun">
                    	<a data-ng-click="archCtrl.handleSchedule()" data-ng-if="archCtrl.model.scheduleName.length==0"><cv:msg key="string.defaultSchedule" bundle="archiving" />
                    	</a>
                    	<span>
                    		<a data-ng-click="archCtrl.handleSchedule()">
                    			{{archCtrl.model.scheduleName}}
                    		</a>
                    	</span>
                    </span>
		   		</div>
           	</div>
          </div>
			<div class="button-container">
			     	<button id="setUpFileArchiving_button_#4392" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="archCtrl.cancelSetup()" data-ng-show="archCtrl.showCancel"> 
					<cv:msg key="action.cancel" bundle="profiles" />
				</button>
				<button id="setUpFileArchiving_button_#2698" type="submit" class="btn btn-primary cvBusyOnAjax"> 
					{{archCtrl.submitButtonName}}
				</button>
			</div>
</form>
</div>
	<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>
