<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.nas"></cv:cvMessages>
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
</script>

<div class="setup-title">
	<h1><cv:msg key="title.nasServerMigration" bundle="nas" /></h1>
</div>
<div class="setup-content padding-left-20 padding-right-20">
	<span
		class="col-xs-12 margin-left-0 margin-right-0 serverMessage"
		ng-class="ctrl.serverMessage.type"
		ng-bind="ctrl.serverMessage.message"
		ng-if="ctrl.serverMessage"
	></span>
	<form
		name="nasMigrationForm"
		autocomplete="off"
		cv-submit="ctrl.saveMigrationSettings()"
		class="form-horizontal bootstrap-wrapper text-left"
		cv-hide-api
		novalidate
	>
		<!-- Cutover approver -->
		<div class="form-group cv-flex cutover-approver margin-top-20" ng-init="ctrl.setFormController(nasMigrationForm)">
			<label class="margin-top-15 col-xs-4" ng-bind="'label.cutoverApproverInput' | cvLoc"></label>
			<cv-select-2
				class="col-xs-8"
				search-options="ctrl.userSearchConfig"
				output-model="ctrl.cutoverApprovers"
			></cv-select-2>
		</div>
		<span
			class="col-xs-8 col-xs-offset-4 help-block"
			ng-if="cv.nasMigrationForm.attempted && ctrl.isInvalidCutoverApprovers"
			ng-bind="'error.missingCutoverApprover' | cvLoc"
		></span>

		<!-- Cutover date and time -->
		<div class="form-group grid-date-picker cutover-date-picker">
			<div class="col-xs-4">
				<div class="date-picker-label text-align-left" ng-bind="'label.cutoverDate' | cvLoc"></div>
			</div>
			<div class="col-xs-8">
				<div class="calendar-wrapper date-picker">
					<input
						type="text"
						class="date-box"
						placeholder="mm/dd/yyyy hh:mm"
						data-datetime-picker="MM/dd/yyyy HH:mm"
						data-ng-model="ctrl.datepicker.cutover.value"
						data-is-open="ctrl.datepicker.cutover.open"
						data-datepicker-options="ctrl.datepicker.cutover.dateOptions"
						data-timepicker-options="ctrl.datepicker.cutover.timeOptions"
					/>
					<button type="button" class="btn btn-primary" data-ng-click="ctrl.openDatePicker()">
						<i class="glyphicon glyphicon-calendar"></i>
					</button>
				</div>
			</div>
		</div>
		<span
			class="col-xs-8 col-xs-offset-4 help-block"
			ng-if="cv.nasMigrationForm.attempted && ctrl.isInvalidCutoverDate"
			ng-bind="'error.invalidCutoverDate' | cvLoc"
		></span>

		<!-- Access nodes -->
		<div class="form-group" ng-if="ctrl.isExistingFiler">
			<div class="col-xs-4">
				<label ng-bind="'label.accessNodes' | cvLoc"></label>
			</div>
			<cv-accessnode-dropdown
				class="col-xs-8"
				directive-id="{{ ctrl.accessNodeOptions.type }}AccessnodeSelectionDropdown"
				data-accessnodeoptions="ctrl.accessNodeOptions"
			></cv-accessnode-dropdown>
		</div>
		<span
			class="col-xs-8 col-xs-offset-4 help-block"
			ng-if="(cv.nasMigrationForm.attempted || ctrl.attemptingBrowse) && ctrl.isInvalidDataAccessNodes"
			ng-bind="'label.noAccessNodes' | cvLoc"
		></span>

		<!-- Impersonate user - Username -->
		<div class="form-group" ng-if="ctrl.isExistingFiler && ctrl.appId === 33">
			<label class="col-xs-4" for="cifsUsername" ng-bind="'label.cifsLogin' | cvLoc"></label>
			<div class="col-xs-8">
				<input
					type="text"
					name="cifsUsername"
					id="cifsUsername"
					ng-model="ctrl.cifsCredentials.userName"
					placeholder="{{ ctrl.userNameHelpText }}"
					required
				/>
			</div>
		</div>
		<span
			class="col-xs-8 col-xs-offset-4 help-block"
			ng-if="cv.nasMigrationForm.needsAttention(nasMigrationForm.cifsUsername) && ctrl.isInvalidUsername"
			ng-bind="'error.userName' | cvLoc"
		>
		</span>

		<!-- Impersonate user - Password -->
		<div class="form-group" ng-if="ctrl.isExistingFiler && ctrl.appId === 33">
			<label class="col-xs-4" for="cifsPassword" ng-bind="'label.cifsPassword' | cvLoc"></label>
			<div class="col-xs-8">
				<input
					type="password"
					name="cifsPassword"
					id="cifsPassword"
					ng-model="ctrl.cifsCredentials.password"
					maxlength="128"
					required
				/>
			</div>
		</div>
		<span
			class="col-xs-8 col-xs-offset-4 help-block"
			ng-if="cv.nasMigrationForm.needsAttention(nasMigrationForm.cifsPassword) && ctrl.isInvalidPassword"
			ng-bind="'error.password' | cvLoc"
		>
		</span>

		<!-- Impersonate user - Confirm password -->
		<div class="form-group" ng-if="ctrl.isExistingFiler && ctrl.appId === 33">
			<label class="col-xs-4" for="cifsConfirmPassword" ng-bind="'label.confirmPassword' | cvLoc"></label>
			<div class="col-xs-8">
				<input
					type="password"
					name="cifsConfirmPassword"
					id="cifsConfirmPassword"
					ng-model="ctrl.cifsCredentials.confirmPassword"
					maxlength="128"
					required
				/>
			</div>
		</div>
		<span
			class="col-xs-8 col-xs-offset-4 help-block"
			ng-if="cv.nasMigrationForm.needsAttention(nasMigrationForm.cifsConfirmPassword) && ctrl.isEmptyConfirmPassword"
			ng-bind="'error.confirmPassword' | cvLoc"
		>
		</span>
		<span
			class="col-xs-8 col-xs-offset-4 help-block"
			ng-if="!ctrl.isEmptyConfirmPassword && ctrl.isConfirmPasswordMismatch"
			ng-bind="'error.confirmPasswordNotMatched' | cvLoc"
		>
		</span>

		<!-- Parallel jobs threshold -->
		<div class="form-group">
			<label class="col-xs-4">
				<cv-help-text help-label="label.limitParallelJobs" help-text="help.limitParallelJobs"></cv-help-text>
			</label>
			<div class="col-xs-8 cv-flex space-between">
				<toggle-control
					status="ctrl.backupThreshold.isEnabled ? 'enabled-activity' : 'disabled-activity'"
					title="<cv:msg key='label.enableDisable' bundle='messages' />"
					ng-click="ctrl.toggleParallelJobsThreshold()"
					class="padding-bottom-12"
				></toggle-control>
				<div ng-if="ctrl.backupThreshold.isEnabled" class="inline-block">
					<label
						for="parallelJobsThreshold"
						class="inline-block margin-right-20"
						ng-bind="'label.parallelJobsThreshold' | cvLoc"
					></label>
					<input
						type="number"
						name="parallelJobsThreshold"
						id="parallelJobsThreshold"
						min="1"
						ng-model="ctrl.backupThreshold.parallelJobs"
						class="margin-bottom-0"
					/>
				</div>
			</div>
		</div>
		<span
			class="col-xs-8 col-xs-offset-4 help-block"
			ng-if="cv.nasMigrationForm.attempted && ctrl.isInvalidBackupThreshold"
			ng-bind="'error.backupThreshold' | cvLoc"
		></span>

		<!-- Source server -->
		<div class="form-group" ng-if="!ctrl.loadingServerList">
			<label class="col-xs-4" ng-bind="'label.nasMigrationSource' | cvLoc"></label>
			<div class="col-xs-8">
				<isteven-multi-select
					id="nasServerMigrationSource"
					input-model="ctrl.sourceServerList"
					output-model="ctrl.selectedSourceServer"
					button-label="displayName"
					item-label="displayName"
					selection-mode="single"
					tick-property="checked"
					class="isteven-multi-select user-group-select"
					on-close="ctrl.populateContentGrids()"
					translation="ctrl.localLang"
				>
				</isteven-multi-select>
			</div>
		</div>
		<span
			class="col-xs-8 col-xs-offset-4 help-block"
			ng-if="cv.nasMigrationForm.attempted && ctrl.isInvalidSourceServer"
			ng-bind="'error.missingSourceServer' | cvLoc"
		></span>

		<!-- Backup content from source server -->
		<div ng-if="ctrl.sourceServerClientId && !ctrl.fetchingBackupContent && !ctrl.isBackupContentFetchError">
			<h4 class="margin-top-30">
				<cv:msg key="title.foldersToMigrate" bundle="nas"></cv:msg>
				<cv-help-component data-help-text="<cv:msg key='help.foldersToMigrate' bundle='nas'/>"></cv-help-component>
			</h4>

			<!-- Target starting path -->
			<div class="form-group">
				<label class="col-xs-4">
					<cv-help-text help-label="label.targetStartingPath" help-text="help.targetStartingPath"></cv-help-text>
				</label>
				<div class="col-xs-8">
					<div class="cv-flex vertical-center">
						<input
							type="text"
							name="targetStartingPath"
							id="targetStartingPath"
							ng-model="ctrl.targetStartingPath"
							required
						/>
						<button
							id="browseTargetPath"
							type="button"
							class="icon-style cv-material-button browse"
							data-ng-click="ctrl.initTargetPathBrowse()"
						>
							<div class="cv-material-button-icon cursor-pointer">
								<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
									<path d="M0 0h24v24H0z" fill="none" />
									<path
										d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"
									/>
								</svg>
							</div>
							<div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
						</button>
					</div>
				</div>
			</div>
			<span
				class="col-xs-8 col-xs-offset-4 help-block"
				ng-if="cv.nasMigrationForm.attempted && ctrl.isInvalidTargetStartingPath"
				ng-bind="'error.invalidTargetStartingPath' | cvLoc"
			></span>

			<!-- Included content grid -->
			<cv-kendo-grid
				ng-if="ctrl.includedContentGridOptions"
				data-cv-grid-options="ctrl.includedContentGridOptions"
				class="included-content-grid"
			></cv-kendo-grid>
			<span
				class="col-xs-8 margin-left-0 margin-top-15 help-block"
				ng-if="cv.nasMigrationForm.attempted && ctrl.isInvalidMigrationContent"
				ng-bind="'error.noContentToMigrate' | cvLoc"
			></span>

			<!-- Excluded content grid -->
			<div class="margin-top-50" ng-if="!ctrl.isNasCreationUserFlow " ng-show="ctrl.excludedBackupContent.length">
				<h4 ng-bind="'title.excludedFromMigration' | cvLoc"></h4>
				<cv-kendo-grid
					ng-if="ctrl.excludedContentGridOptions"
					data-cv-grid-options="ctrl.excludedContentGridOptions"
				></cv-kendo-grid>
			</div>
		</div>

		<!-- Loader -->
		<div class="loading-data margin-top-50 text-center" ng-if="ctrl.loadingServerList || ctrl.fetchingBackupContent">
			<div class="loader-skeleton tile-style margin-bottom-15"></div>
			<div class="loader-skeleton tile-style margin-bottom-5"></div>
		</div>

		<div class="button-container">
			<button
				id="migrate-nas-cancel"
				type="button"
				class="btn btn-default cvBusyOnAjax"
				ng-click="ctrl.cancelMigrationSettings()"
			>
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="migrate-nas-save" type="submit" class="btn btn-primary cvBusyOnAjax">
				<cv:msg key="label.save" bundle="archiving" />
			</button>
		</div>
	</form>
</div>
