<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
</script>
<div class="row bootstrap-wrapper">
	<div class="col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
<form class="form-horizontal" name="enableArchivingForm" data-cv-submit="archCtrl.finishSetup()" novalidate autocomplete="off">
				
<h1 class="page-header">
{{archCtrl.heading}}
</h1>				
<div>
<div class="{{archCtrl.generalSetupMessage.type}} serverMessage archiving-text-align-center">{{archCtrl.generalSetupMessage.message}}</div>
</div>
<div class="panel panel-default">
                <div class="panel-body">
                    
                    <div class="form-group">
                        <label class="col-lg-3" for="plan"><cv:msg key="label.plan" bundle="archiving" /> </label>
                        <div class="col-xs-12 col-lg-6">
                            <select
								id="plan"  name="plan"
								data-ng-model="archCtrl.model.plan" required
								data-ng-options="plan.planSummary.plan.planName for plan in archCtrl.plans">
								<option value="">
									<cv:msg key="placeholder.plan" bundle="archiving" />
								</option>
							</select>
							<div class="help-block">
							
										<div data-ng-show="cv.enableArchivingForm.needsAttention(enableArchivingForm.plan)">
										<i class="ion-alert-circled"></i>
										<span><cv:msg key="error.plan" bundle="archiving" /></span>
										</div>
										<span><a data-ng-click="archCtrl.createServerPlan()"><cv:msg key="error.createPlan" bundle="archiving" /></a></span>
						</div>
                        </div>
                    </div>
                    
                    <div class="form-group" data-ng-if="archCtrl.flags.showModifiedDate">
                    <label class="col-lg-3" for="modifieddate"><cv:msg key="label.modifieddate" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-2">
					<span>
					<input type="number" name="modifieddateValue" data-ng-model="archCtrl.model.modifiedDateValue" min="0" required />
					<label><cv:msg key="options.months" bundle="archiving" /> </label>
					</span>
					<div class="help-block" data-ng-show="cv.enableArchivingForm.needsAttention(enableArchivingForm.modifieddateValue)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.modifiedDateValue" bundle="archiving" />
					</div>
					</div>
					</div>
                    
                    <div class="form-group" data-ng-if="archCtrl.flags.showAccessedDate">
                    <label class="col-lg-3" for="accesseddate"><cv:msg key="label.accesseddate" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-2">
					<span>
					<input type="number" name="accessedDateValue" data-ng-model="archCtrl.model.accessedDateValue" min="0" required />
					<label><cv:msg key="options.months" bundle="archiving" /> </label>
					</span>
					<div class="help-block" data-ng-show="cv.enableArchivingForm.needsAttention(enableArchivingForm.accessedDateValue)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.accessedDateValue" bundle="archiving" />
					</div>
					</div>
					</div>
					
					<div class="form-group">
                    <label class="col-lg-3" for="fileSize"><cv:msg key="label.fileSize" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-2">
					<span>
					<input type="number" name="fileSizeValue" data-ng-model="archCtrl.model.fileSizeValue" min="0" required />
					<label><cv:msg key="options.mb" bundle="archiving" /> </label>
					</span>
					<div class="help-block" data-ng-show="cv.enableArchivingForm.needsAttention(enableArchivingForm.fileSizeValue)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.fileSizeValue" bundle="archiving" />
					</div>
					</div>
					</div>
					
					<div class="form-group" data-ng-if="archCtrl.extensions.length>0">
                    <label class="col-lg-3" for="extensions"><cv:msg key="label.archiving.filetype" bundle="archiving" /> </label>
                    <div class="col-lg-8" id="extensions">
					<span ng-repeat="extension in archCtrl.extensions" class="margin-left-10">
					<input id="{{extension}}" type="checkbox" ng-checked="true" ng-disabled="true"/>
					<label for="{{extension}}">{{extension}}</label>
					</span>
					</div>
					</div>
					
					<div class="form-group" data-ng-if="archCtrl.owners.length>0">
                    <label class="col-lg-3" for="owners"><cv:msg key="label.archiving.FileOwners" bundle="archiving" /> </label>
                    <div class="col-lg-8" id="owners">
					<span ng-repeat="owner in archCtrl.owners" class="margin-left-10">
					<input id="{{owner.ownerName}}" type="checkbox" ng-checked="true" ng-disabled="true"/>
					<label for="{{owner.ownerName}}">{{owner.ownerName}}</label>
					</span>
					</div>
					</div>
					
					<div class="form-group">
                    <label for="accessNode" class="col-lg-3"> <cv:msg key="label.accessNode" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-6">
                    <select id="accessNode" name="accessNode" data-ng-model="archCtrl.model.selectedAccessNode" required>
					<option ng-repeat="accessNode in archCtrl.accessNodes" value="{{accessNode.mediaAgentId}}">{{accessNode.mediaAgentName}}</option>
					</select>
					<div class="help-block" data-ng-show="cv.enableArchivingForm.needsAttention(enableArchivingForm.accessNode)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.accessNode" bundle="archiving" />
					</div>
                    </div>
                    </div>
                </div>
            </div>
            
            <uib-accordion id="nmdpAccordian" close-others="true" class="text-left">
			<div uib-accordion-group data-is-open="archCtrl.flags.showNAS" >
			<uib-accordion-heading>
				<input name="nmdpDetailsPanelChkBox" type="checkbox"
						data-ng-checked="archCtrl.flags.showNAS" data-ng-click="$event.preventDefault();" />
				<label for="nmdpDetailsPanelChkBox" data-ng-click="$event.preventDefault();">
					<cv:msg key="label.accordian.filerDetails" bundle="archiving" />
				</label>
				<a data-ng-show="archCtrl.flags.isFilerDetectSuccess" data-ng-click="$event.stopPropagation();archCtrl.editNDMPDetails()" class="pull-right accordion-heading-action-link"><cv:msg key="label.edit.ndmpDetails" bundle="archiving" /></a>
			</uib-accordion-heading>
        			<div class="form-group">
                   <div data-ng-if="archCtrl.flags.showNasServerMessage" class="{{archCtrl.nas.type}} serverMessage archiving-text-align-center">{{archCtrl.nas.message}}</div>
                    </div>
                    <div class="form-group">
                    <label for="ndmpHostname" class="col-lg-3"> <cv:msg key="label.ndmp.hostname" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-6">
                    <input type="text" name="ndmpHostname" data-ng-model="archCtrl.ndmp.hostname" ng-disabled="archCtrl.flags.isFilerDetectSuccess"/>
					</div>
                    </div>
                    <div class="form-group">
                    <label for="ndmpLogin" class="col-lg-3"> <cv:msg key="label.ndmp.login" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-6">
                    <input type="text" name="ndmpLogin" data-ng-model="archCtrl.ndmp.login" ng-disabled="archCtrl.flags.isFilerDetectSuccess"/>
					</div>
                    </div>
                    <div class="form-group">
                    <label for="ndmpPassword" class="col-lg-3"> <cv:msg key="label.ndmp.password" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-6">
                    <input type="password" name="ndmpPassword" data-ng-model="archCtrl.ndmp.password" ng-disabled="archCtrl.flags.isFilerDetectSuccess"/>
					</div>
                    </div>
                    <div class="form-group">
                    <label for="ndmpListenPort" class="col-lg-3"> <cv:msg key="label.ndmp.port" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-6">
                    <input type="number" name="ndmpListenPort" data-ng-model="archCtrl.ndmp.listenPort" ng-disabled="archCtrl.flags.isFilerDetectSuccess"/>
					</div>
                    </div>
                    <div class="form-group" data-ng-if="archCtrl.flags.isFilerDetectSuccess">
                    <label for="ndmpVendorType" class="col-lg-3"> <cv:msg key="label.ndmp.vendorType" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-6">
                    <input name="ndmpVendorType" data-ng-model="archCtrl.ndmp.vendor" ng-disabled="archCtrl.flags.isFilerDetectSuccess"/>
					</div>
                    </div>
                    <div class="form-group">
                    <div class="col-lg-8">
                    <div class="help-block" data-ng-show="archCtrl.flags.showNasError">
					<i class="ion-alert-circled"></i>
					{{archCtrl.ndmp.errorString}}
					</div>
                    </div>
                    </div>
                    <div class="form-group" data-ng-if="!archCtrl.flags.isFilerDetectSuccess">
                    <div class="col-lg-3">
                    <button id="rulesSaveBtn" type="button" class="btn btn-primary cvBusyOnAjax archivingNext" ng-click="archCtrl.detectNAS()"><cv:msg key="label.detect" bundle="archiving"/></button>
                    </div>
                    </div>
                    <div class="form-group" data-ng-if="archCtrl.flags.isFilerDetectSuccess && archCtrl.flags.isNetApp">
                    <label for="nmdpPrimaryProxyLbl" class="col-lg-3"> <cv:msg key="label.ndmp.primaryProxy" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-6">
                    <select id="nmdpPrimaryProxy" name="nmdpPrimaryProxy" data-ng-model="archCtrl.ndmp.primaryProxyID" required>
					<option value="">
									<cv:msg key="header.archiving.primaryNode" bundle="archiving" />
					</option>
					<option ng-repeat="accessNode in archCtrl.accessNodes" value="{{accessNode.id}}">{{accessNode.name}}</option>
					</select>
					<div class="help-block" data-ng-show="cv.enableArchivingForm.needsAttention(enableArchivingForm.nmdpPrimaryProxy)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.archiving.ndmp.primaryNode" bundle="archiving" />
                	</div>
                	</div>
                    </div>
                    <div class="form-group" data-ng-if="archCtrl.flags.isFilerDetectSuccess && archCtrl.flags.isNetApp">
                    <label for="ndmpSecondaryProxyLbl" class="col-lg-3"> <cv:msg key="label.ndmp.secondaryProxy" bundle="archiving" /> </label>
                    <div class="col-xs-12 col-lg-6">
                    <select id="ndmpSecondaryProxy" name="ndmpSecondaryProxy" data-ng-model="archCtrl.ndmp.secondaryProxyID">
					<option value="">
									<cv:msg key="header.archiving.secondaryNode" bundle="archiving" />
					</option>
					<option ng-repeat="accessNode in archCtrl.accessNodes" value="{{accessNode.id}}">{{accessNode.name}}</option>
					</select>
					</div>
                    </div>
                    <div class="form-group" data-ng-if="archCtrl.flags.isFilerDetectSuccess && archCtrl.flags.isCelera">
                    <label for="ndmpHttpPort" class="col-lg-3"> <cv:msg key="label.ndmp.httpPort" bundle="archiving"/></label>
                    <div class="col-xs-12 col-lg-6">
                   	<input type="number" name="ndmpHttpPort" data-ng-model="archCtrl.ndmp.httpPort" required/>
                    <div class="help-block" data-ng-show="cv.enableArchivingForm.needsAttention(enableArchivingForm.ndmpHttpPort)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.archiving.ndmp.httpPort" bundle="archiving" />
                	</div>
                    </div>
                    </div>
                    <div class="form-group" data-ng-if="archCtrl.flags.isFilerDetectSuccess && archCtrl.flags.isCelera">
                    <label for="ndmpRecallPath" class="col-lg-3"> <cv:msg key="label.ndmp.recallPath" bundle="archiving"/> </label>
                    <div class="col-xs-12 col-lg-6">
                    <input name="ndmpRecallPath" data-ng-model="archCtrl.ndmp.recallPath" size="30" required/>
                    <div class="help-block" data-ng-show="cv.enableArchivingForm.needsAttention(enableArchivingForm.ndmpRecallPath)">
					<i class="ion-alert-circled"></i>
					<cv:msg key="error.archiving.ndmp.recallPath" bundle="archiving" />
                	</div>
					</div>
                    </div>
                    </div>
                    </uib-accordion>
                    
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="form-group">
							<h4 class="col-xs-12 col-lg-4 panel-title"><cv:msg key="label.dataSource" bundle="archiving" /></h4>
						</div>
                    
                    <div class="form-group">
                    <label class="col-lg-3"> <cv:msg key="label.name"
									bundle="archiving" />
							</label>
							
					<div class="col-xs-12 col-lg-6">
					<input type="text" name="Name" data-ng-model="archCtrl.model.newDatasourceProps.name" readonly />
					</div>
					
					</div>
					<div class="form-group">
					<label class="col-lg-3"> <cv:msg key="label.folderPaths"
									bundle="archiving" />
					</label>
					<div class="col-xs-12 col-lg-6">
								<div class="archiving-div-scroll">
									<ul class="manageCollectionList list-style__row group archiving-border"
										style="margin-left: 0px;"
										data-ng-repeat="folderpath in archCtrl.model.newDatasourceProps.contents">
										<li data-ng-bind="folderpath" style="width: 90%"></li>
									</ul>
								</div>
							</div>
					</div>
					<div class="form-group" data-ng-if="archCtrl.model.newDatasourceProps.exclusions.length>0">
					<label class="col-lg-3"><cv:msg key="label.Exclusions" bundle="fs" /></label>
					<div class="col-xs-12 col-lg-6">
								<div class="archiving-div-scroll">
									<ul class="manageCollectionList list-style__row group archiving-border"
										style="margin-left: 0px;"
										data-ng-repeat="folderpath in archCtrl.model.newDatasourceProps.exclusions">
										<li data-ng-bind="folderpath" style="width: 90%"></li>
									</ul>
								</div>
							</div>
							</div>
							<div class="form-group" data-ng-if="archCtrl.model.newDatasourceProps.exceptions.length>0">
					<label class="col-lg-3"><cv:msg key="label.Exceptions" bundle="fs" /></label>
					<div class="col-xs-12 col-lg-6">
								<div class="archiving-div-scroll">
									<ul class="manageCollectionList list-style__row group archiving-border"
										style="margin-left: 0px;"
										data-ng-repeat="folderpath in archCtrl.model.newDatasourceProps.exceptions">
										<li data-ng-bind="folderpath" style="width: 90%"></li>
									</ul>
					</div>
							</div>
					</div>
					</div>
                    </div>
                <div class="button-container text-right">
                <button id="enableArchiving_button_#5043" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="archCtrl.cancelSetup()"> 
				<cv:msg key="action.cancel" bundle="profiles" />
				</button>
				<button id="enableArchiving_button_#1285" type="submit" class="btn btn-primary cvBusyOnAjax"> 
                {{archCtrl.submitButtonName}}
                </button>
                </div>
</form>
</div>
</div>
	<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>
		