<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
	</script>
	<fmt:bundle basename="localization.archiving">
	<div class="row">
	<div class="col-md-12">
		<h2 class="float-left" data-ng-bind="archCtrl.properties.heading" ></h2>
	</div>
	<div class="{{archCtrl.generalSetupMessage.type}} serverMessage archiving-text-align-center">{{archCtrl.generalSetupMessage.message}}</div>
</div>
		<div class="row">
			<div class="col-md-6">
					<cv-tile-component data-ac-id="editArchivingProperties-header_archiving_content-archiving" data-title='<cv:msg key="header.archiving.content" bundle="archiving"/>' data-loader="archCtrl.properties.folderpaths">
					<div data-ng-switch on="applicationId">
					 	<ul class="list-style__row group " data-ng-repeat="folderpath in archCtrl.properties.folderpaths" >
					 		<li data-ng-bind="folderpath"/>
					 	</ul>
					 	<div class="page-details-box-links" ><a href="" data-ng-click="archCtrl.editContent();"><fmt:message key="label.archiving.edit"/></a></div>
				 	</div>
					</cv-tile-component>
					
					<cv-tile-component data-ac-id="editArchivingProperties-header_archiving_accessnode-archiving" data-title='<cv:msg key="header.archiving.accessnode" bundle="archiving"/>' data-loader="archCtrl.properties.selectedAccessNode">
					<div>
					<ul class="list-style-secondary">
							<li class="group"> 
							     <span class="pageDetailColumn" data-ng-bind="archCtrl.properties.selectedAccessNode.clientName"></span>
							</li>
							</ul>
					 	<div class="page-details-box-links" ><a href="" data-ng-click="archCtrl.editProperties('accessnode')"><fmt:message key="label.archiving.edit"/></a></div>
				 	</div>
					</cv-tile-component>
					<cv-tile-component data-ac-id="editArchivingProperties-header_archiving_ownerInfo-archiving" data-title='<cv:msg key="label.OwnerInfo" bundle="archiving"/>' data-loader="archCtrl.properties.OwnerInfo">
					<div data-ng-switch on="applicationId">
					 	<ul class="list-style-secondary">
							<li class="group"> 
							     <span class="pageDetailColumn" data-ng-bind="archCtrl.properties.OwnerInfo"></span>
							</li>
							</ul>
					 	<div class="page-details-box-links" ><a href="" data-ng-click="archCtrl.editProperties('ownerInfo');"><fmt:message key="label.archiving.edit"/></a></div>
				 	</div>
					</cv-tile-component>
			</div>
			<div class="col-md-6">
			<cv-tile-component data-ac-id="editArchivingProperties-header_archiving_plan-archiving" data-title='<cv:msg key="header.archiving.plan" bundle="archiving"/>'" data-loader="archCtrl.properties.plan">
					<div>
					<span data-ng-if="!archCtrl.properties.isArchiveEnabled"><p class="info-place-holder"><cv:msg key="label.noPlanSelected" bundle="archiving" /></p></span>
					 	<ul class="list-style-secondary" data-ng-if="archCtrl.properties.isArchiveEnabled">
							<li class="group"> 
							     <span class="pageDetailColumn">
							     <a data-ng-href="#/profileDetails/{{archCtrl.properties.plan.planId}}">{{archCtrl.properties.plan.planName}}</a>
							     </span>
							</li>
							</ul>
					 	<div class="page-details-box-links" ><a data-ng-if="archCtrl.properties.isArchiveEnabled" href="" data-ng-click="archCtrl.editProperties('plan')"><fmt:message key="label.archiving.edit"/></a>
					 	<a data-ng-if="!archCtrl.properties.isArchiveEnabled" href="" data-ng-click="archCtrl.editFromDashboard()"><fmt:message key="label.addPlan"/></a>
					 	</div>
				 	</div>
					</cv-tile-component>
					
					
					<cv-tile-component data-ac-id="editArchivingProperties-header_archiving_rules-archiving" data-title='<cv:msg key="header.archiving.rules" bundle="archiving"/>'>
					<div>
					<span data-ng-if="!archCtrl.properties.isArchiveEnabled"><p class="info-place-holder"><cv:msg key="label.noRulesSelected" bundle="archiving" /></p></span>
					<ul class="list-style-secondary" data-ng-if="archCtrl.properties.isArchiveEnabled">
							<li class="group"> <span class="pageDetailColumn"><fmt:message key="label.modifieddate" /> </span> 
							     <span class="pageDetailColumn">{{archCtrl.properties.modifiedDateValue}} <cv:msg key="options.months" bundle="archiving"/></span>
							</li>
							</ul>
							<ul class="list-style-secondary" data-ng-if="archCtrl.properties.isArchiveEnabled">
							<li class="group"> <span class="pageDetailColumn"><fmt:message key="label.accesseddate" /> </span> 
							     <span class="pageDetailColumn">{{archCtrl.properties.accessedDateValue}} <cv:msg key="options.months" bundle="archiving"/></span>
							</li>
							</ul>
							<ul class="list-style-secondary" data-ng-if="archCtrl.properties.isArchiveEnabled">
							<li class="group"> <span class="pageDetailColumn"><fmt:message key="label.fileSize" /> </span> 
							     <span class="pageDetailColumn">{{archCtrl.properties.fileSizeValue}} <cv:msg key="options.mb" bundle="archiving"/></span>
							</li>
							</ul>
							<ul class="list-style-secondary" data-ng-if="archCtrl.properties.isArchiveEnabled && archCtrl.properties.fileExtensions.length>0">
							<li class="group"> <span class="pageDetailColumn"><fmt:message key="label.archiving.filetype" /> </span> 
							     <span class="pageDetailColumn">{{archCtrl.properties.fileExtensions}}</span>
							</li>
							</ul>
							<ul class="list-style-secondary" data-ng-if="archCtrl.properties.isArchiveEnabled && archCtrl.properties.fileOwners.length>0">
							<li class="group"> <span class="pageDetailColumn"><fmt:message key="label.archiving.fileOwners" /> </span> 
							     <p class="pageDetailColumn">{{archCtrl.properties.fileOwners}}</p>
							</li>
							</ul>
							
							
							
							
							<div class="page-details-box-links" ><a data-ng-if="archCtrl.properties.isArchiveEnabled" href="" data-ng-click="archCtrl.editFromDashboard()"><fmt:message key="label.archiving.editFromDashBoard"/></a>
							<a data-ng-if="!archCtrl.properties.isArchiveEnabled" href="" data-ng-click="archCtrl.editFromDashboard()"><fmt:message key="label.addRules"/></a></div>
					</div>
					</cv-tile-component>
			</div>
		</div>
</fmt:bundle>
</div>
<script src="${pageContext.request.contextPath}/common/js/encoder.js"></script>
