<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
</script>

<div data-ng-if="activateURLCriteriaPresent" class="form-group row margin-top-10">
    <span class="col-lg-4 text-left">
        <cv:msg key="label.customCriteria" bundle="ediscovery"/>
    </span>
    <div class="col-lg-8 text-left">
        <a href="" data-ng-click="viewActivateArchivingRules()"><cv:msg key="label.view" bundle="ediscovery"/></a>
    </div>
</div>
<div ng-if="enablePreviewMode && !datacubeQueryPresent" class="archiving-preview-mode">
    <label ng-bind="archivingInfoFromPlan | cvLoc" ng-if="enablePreviewMode"></label>
    <div class="content-group-content-info">
        <div class="form-group row">
            <span class="col-lg-4">
                <cv:msg key="label.archivingRules.fileTimestamp" bundle="profiles" />
            </span>
            <div class="col-lg-8 text-left">
                <span ng-bind="previewFileTimestampConfig.accessRule.name"></span>
                <span ng-bind="previewFileTimestampConfig.lastAccessedAgo"></span>
                <span ng-bind="previewFileTimestampConfig.timestampRule.name"></span>
                <span><cv:msg key="label.ago" bundle="profiles" /></span>
            </div>
        </div>
        <div class="form-group row">
            <span class="col-lg-4">
                <cv:msg key="label.archivingRules.fileSize" bundle="profiles" />
            </span>
            <div class="col-lg-8 text-left">
                <span><cv:msg key="label.greaterThan" bundle="profiles" /></span>
                <span ng-bind="previewFileSizeConfig.size"></span>
                <span ng-bind="previewFileSizeConfig.rule.name"></span>
            </div>
        </div>
    </div>
</div>
<div class="form-group row text-left margin-left-5" ng-if="enableToggleOverrideArchivingRules && !datacubeQueryPresent">
    <cv-toggle toggle-name="enableOverrideArchivingRules" toggle-label="label.enableOverrideArchivingRules" value="toggleOverrideArchivingRules" on-click="toggleOverride(toggleOverrideArchivingRules)" help-text="toggleOverrideHelpText"></cv-toggle>
</div>
<div ng-if="(!hideEdit || !enablePreviewMode) && !datacubeQueryPresent" ng-class="{'margin-top-20': !enableToggleOverrideArchivingRules}">
    <div class="form-group row" ng-class="{'margin-top-10': !enableToggleOverrideArchivingRules, 'margin-bottom-10': !enableToggleOverrideArchivingRules}">
        <span class="col-lg-4 text-left"  ng-class="{'margin-top-10': hideEditArchivingRulesTimeStamp}">
            <cv:msg key="label.archivingRules.fileTimestamp" bundle="profiles" />
        </span>
        <div class="col-lg-8 text-left">
            <span ng-if="!hideEditArchivingRulesTimeStamp" ng-bind="fileTimestampConfig.accessRule.name"></span>
            <select ng-if="hideEditArchivingRulesTimeStamp" ng-change="updateRule(fileTimestampConfig.timestampRule);" ng-model="fileTimestampConfig.accessRule" ng-options="fileAccessRule as fileAccessRule.name for fileAccessRule in fileAccessRules"></select>
            <span ng-if="!hideEditArchivingRulesTimeStamp" ng-bind="fileTimestampConfig.lastAccessedAgo"></span>
            <input ng-if="hideEditArchivingRulesTimeStamp" ng-change="updateRule(fileTimestampConfig.timestampRule);" id="accessedAgo" name="accessedAgo" type="number" min="0" max="999" ng-model="fileTimestampConfig.lastAccessedAgo"/>
            <span ng-if="!hideEditArchivingRulesTimeStamp" ng-bind="fileTimestampConfig.timestampRule.name"></span>
            <select ng-if="hideEditArchivingRulesTimeStamp" ng-change="updateRule(fileTimestampConfig.timestampRule);" ng-model="fileTimestampConfig.timestampRule" ng-options="fileTimestampRule as fileTimestampRule.name for fileTimestampRule in fileTimestampRules"></select>
            <span><cv:msg key="label.ago" bundle="profiles" /></span>
            <span ng-if="hideEditArchivingRulesTimeStamp && enableEdit" class="padding-left-5">
                <a class="inline-editor-button" href ng-click="saveArchivingRules('hideEditArchivingRulesTimeStamp')"><span class="k-icon k-i-check"></span></a>
                <a class="inline-editor-button" href ng-click="toggleEditArchivingRules('hideEditArchivingRulesTimeStamp', null, true);"><span class="k-icon k-i-x"></span></a>
            </span>
            <span ng-if="enableEdit && !hideEditArchivingRulesTimeStamp" class="padding-left-5">
                <a href ng-click="toggleEditArchivingRules('hideEditArchivingRulesTimeStamp', 'true');">
                    <span class="glyphicon glyphicon-pencil"></span>
                </a>
            </span>
        </div>
    </div>
    <div class="form-group row" ng-class="{'margin-top-20': !enableToggleOverrideArchivingRules, 'margin-bottom-10': !enableToggleOverrideArchivingRules}">
        <span class="col-lg-4 text-left" ng-class="{'margin-top-10': hideEditArchivingRulesFileSize}">
            <cv:msg key="label.archivingRules.fileSize" bundle="profiles" />
        </span>
        <div class="col-lg-8 text-left">
            <span><cv:msg key="label.greaterThan" bundle="profiles" /></span>
            <span ng-if="!hideEditArchivingRulesFileSize" ng-bind="fileSizeConfig.size"></span>
            <input ng-if="hideEditArchivingRulesFileSize" ng-change="updateRule();" id="size" name="size" type="number" min="0" ng-model="fileSizeConfig.size"/>
            <span ng-if="!hideEditArchivingRulesFileSize" ng-bind="fileSizeConfig.rule.name"></span>
            <select ng-if="hideEditArchivingRulesFileSize" ng-change="updateRule();" ng-model="fileSizeConfig.rule" ng-options="fileSizeRule as fileSizeRule.name for fileSizeRule in fileSizeRules"></select>
            <span ng-if="enableEdit && hideEditArchivingRulesFileSize" class="padding-left-5">
                <a class="inline-editor-button" href ng-click="saveArchivingRules('hideEditArchivingRulesFileSize')"><span class="k-icon k-i-check"></span></a>
                <a class="inline-editor-button" href ng-click="toggleEditArchivingRules('hideEditArchivingRulesFileSize', null, true);"><span class="k-icon k-i-x"></span></a>
            </span>
            <span ng-if="!hideEditArchivingRulesFileSize && enableEdit" class="padding-left-5">
                <a href ng-click="toggleEditArchivingRules('hideEditArchivingRulesFileSize', 'true');">
                    <span class="glyphicon glyphicon-pencil"></span>
                </a>
            </span>
        </div>
    </div>
</div>