<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
	<cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
</script>
<h2 class="page-title">{{archCtrl.dsName}}</h2>
<div class="archivingLoading" data-ng-if="archCtrl.showInProgress">
<img src="${pageContext.request.contextPath}/common/img/ajax-loader.gif">
<cv:msg key="message.reportInprogress" bundle="archiving" />
</div>
<form class="form-horizontal">
<div id="reportArea"> 
<div class="bootstrap-wrapper">
<div id="reportArea" class="archivingReport">
<div class="row">
<div class="col-lg-10 margin-left-0">
	<h4 ng-bind-html="archCtrl.summaryText"></h4>
	<h5 data-ng-if="!archCtrl.showFinishButton"><cv:msg key="message.multipleSubclients" bundle="archiving"/></h5>
</div>
<div class="col-lg-2">
<button id="archivngReport_button_#4438" type="button" class="btn btn-primary cvBusyOnAjax archivingNext margin-left-5 float-right" ng-click="archCtrl.startArchiving()" data-ng-if="archCtrl.showFinishButton">{{archCtrl.buttonName}}</button>

</div>
</div>
<div class="col-xs-12 margin-top-20">
<div class="col-xs-12 col-md-12 col-lg-3" ng-repeat="(key, value) in archCtrl.two_level_tree">
<div class="panel panel-default padding-0">
    <div class="panel-body">
    <div class="form-group">
    	<div class="col-xs-12 archive-header">
    		<h5 class="margin-0 crop" title="{{key}}">{{key}}</h5>	
		</div>
		<div class="col-xs-12 archiving-div-scroll">
			<div class="multiple-checkbox-group" ng-repeat="subclient in value">
				<input id="{{subclient.id}}" type="checkbox" data-ng-model="subclient.selected" ng-click="archCtrl.onSubclientSelection()" />
				<label for="{{subclient.id}}" title="{{subclient.name}}">{{subclient.name}}</label>
			</div>
		</div>
    </div>
    </div>
    </div>
</div>
</div>
<div class="row">
<uib-accordion id="rulesAccordian" close-others="true" class="text-left">
<div uib-accordion-group data-is-open="archCtrl.status.isAccordianOpen" >
<uib-accordion-heading>
<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': archCtrl.status.isAccordianOpen, 'glyphicon-chevron-right': !archCtrl.status.isAccordianOpen}"></i>
<cv:msg key="header.archiving.rules" bundle="archiving"/>
</uib-accordion-heading>
<div class="row archivingRules">
<div class="col-lg-6 archivingFileSizeRules">
<uib-tabset>
<uib-tab heading='<cv:msg key="label.fileSize" bundle="archiving" />'>
					<div>
					<rzslider id="fileSizeSlider" class="custom-slider" data-rz-slider-model="archCtrl.model.sliders.fileSizeValue" data-rz-slider-options="archCtrl.sliderSizeOptions"></rzslider>
					</div>
				</uib-tab>
</uib-tabset>
</div>
<div class="col-lg-6 archivingFileDateRules">
<uib-tabset active="archCtrl.model.seletedDateTab">
      <uib-tab  index="0" heading='<cv:msg key="label.fileModified" bundle="archiving" />' select="archCtrl.refreshSlider(0)">
        <div ng-if="archCtrl.model.seletedDateTab==0">
						<rzslider id="fileModifiedSlider" class="custom-slider" data-rz-slider-model="archCtrl.model.sliders.fileModifiedValue" data-rz-slider-options="archCtrl.sliderModifiedOptions"></rzslider>
						</div>
      </uib-tab>
      <uib-tab  index="1" heading='<cv:msg key="label.fileAccessed" bundle="archiving" />' select="archCtrl.refreshSlider(1)">
      <div ng-if="archCtrl.model.seletedDateTab==1">
    <rzslider id="fileAccessedSlider" class="custom-slider" data-rz-slider-model="archCtrl.model.sliders.fileAccessedValue" data-rz-slider-options="archCtrl.sliderAccessedOptions"></rzslider>
        
						</div>
      </uib-tab>
</uib-tabset>
</div>
</div>
<div class ="row summaryDiv">
<div class="panel">
	<div>
		<span>
			<h4 class="display-inline">
				<cv:msg key="label.archiving.filetype" bundle="archiving"/>
			</h4>
		</span>
	</div>
	<div class="margin-top-15">
		<label class="margin-left-20" for="fileTypesToggle"><h5 class="font-weight-bold"><cv:msg key="label.archiving.allFileTypes" bundle="archiving" /></h5></label>
		<toggle-control id="fileTypesToggle" status="archCtrl.allFilesTypes" data-ng-click="archCtrl.editFileTypesFn()" true-property="true" false-property="false" class="margin-left-20" title="<cv:msg key="title.fileTypes" bundle="archiving"/>"></toggle-control>
	</div>
	<div  class="margin-top-15">
		<span ng-repeat="(key, value) in archCtrl.monikers" class="margin-left-20">
			<input id="{{key}}" type="checkbox" data-ng-model="archCtrl.monikers[key].selected" data-ng-click="archCtrl.extensionChange()" ng-disabled="!archCtrl.editFileTypes"/>
			<label for="{{key}}">{{key}}</label>
			<cv-help-component help-text="{{archCtrl.monikers[key].extensionsIncluded}}"/>
		</span>
	</div>
<div class="margin-top-15">
<span ng-repeat="customExtension in archCtrl.customExtensions" class="margin-left-20">
<input id="{{customExtension.name}}" type="checkbox" data-ng-model="customExtension.selected" data-ng-click="archCtrl.extensionChange()" ng-disabled="!archCtrl.editFileTypes"/>
<label for="{{customExtension.name}}">{{customExtension.name}}</label>
</span>
<button id="archivngReport_button_#2747" class="btn btn-link cvBusyOnAjax" ng-click="archCtrl.addCustomExtensions()" ng-disabled="!archCtrl.editFileTypes"><cv:msg key="label.archiving.addExtensions" bundle="archiving"/></button>
</div>
</div>
<div class="panel"  data-ng-if="!archCtrl.isNfsShare">
	<div>
		<span>
			<h4 class="display-inline">
				<cv:msg key="label.archiving.FileOwners" bundle="archiving"/>
			</h4>
		</span>
	</div>
	<div class="margin-top-15">
		<label class="margin-left-20" for="fileTypesToggle"><h5 class="font-weight-bold"><cv:msg key="label.archiving.allFileOwners" bundle="archiving"/></h5></label>
		<toggle-control id="fileOwnersToggle" status="archCtrl.allFileOwners" data-ng-click="archCtrl.editFileOwnersFn()" true-property="true" false-property="false" class="margin-left-20" title="<cv:msg key="title.fileOwners" bundle="archiving"/>"></toggle-control>
	</div>
	<div  class="owners-wrapper" ng-if="archCtrl.allFileOwners!='true'">
	<cv-drop-down-tags all-elements = "archCtrl.owners" selected-elements="archCtrl.selectedOwners" on-close-drop-down="archCtrl.ownersSelected()" drop-down-title="Add/Remove owners"/>
	</div>
</div>
</div>
</div>
</uib-accordion>
</div>
<div class ="row margin-left-minus-5 margin-bottom-50">
	<span>
		<a data-ng-click="archCtrl.showCharts = !archCtrl.showCharts;archCtrl.reloadChartsSection()"><h3 class="display-inline"><cv:msg key="header.archiving.viewCharts" bundle="archiving"/>
		</h3>
		<i class="glyphicon ng-scope glyphicon-chevron-right" data-ng-class="{'glyphicon-chevron-right': !archCtrl.showCharts, 'glyphicon-chevron-down': archCtrl.showCharts}"></i>
		</a>
	</span>
</div>
<div class ="row" data-ng-if="archCtrl.showCharts">
<div class="col-lg-6">
<div class="row" data-ng-if="!archCtrl.showChart['dataType']">
<img class="col-lg-offset-6 margin-bottom-150 chart-spinner" src="{{archCtrl.loadingGIF}}"/>
</div>
<div id="archivingReportDataType" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, 'Archiving Data Type')" data-ng-if="archCtrl.showMainReport" data-ng-show="archCtrl.showChart['dataType']">
<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
</div>
</div>
</div>
 <div class="col-lg-6">
<div class="row" data-ng-if="!archCtrl.showChart['totalData']">
<img class="col-lg-offset-6 chart-spinner" src="{{archCtrl.loadingGIF}}"/>
</div>
<div id="archivingReportTotalData" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, 'Archiving Total Data')" data-ng-if="archCtrl.showMainReport" data-ng-show="archCtrl.showChart['totalData']">
<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
</div>
</div>
</div>
</div>
<div class ="row" data-ng-if="archCtrl.showCharts">
<div class="col-lg-6">
<div class="row" data-ng-if="!archCtrl.showChart['age']">
<img class="col-lg-offset-6 chart-spinner" src="{{archCtrl.loadingGIF}}"/>
</div>
<div  id="archivingReportAge" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, 'Archiving Age')" data-ng-if="archCtrl.showMainReport" data-ng-show="archCtrl.showChart['age']">
<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
</div>
</div>
</div>
<div class="col-lg-6">
<div class="row" data-ng-if="!archCtrl.showChart['dataSize']">
<img class="col-lg-offset-6 chart-spinner" src="{{archCtrl.loadingGIF}}"/>
</div>
<div id="archivingReportDataSize" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, 'Archiving Data Size')" data-ng-if="archCtrl.showMainReport" data-ng-show="archCtrl.showChart['dataSize']">
<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
</div>
</div>
</div>
</div>
<div id="tabledetails" class ="row">
<span>
<a data-ng-click="archCtrl.showFileDetails=!archCtrl.showFileDetails"><h3 class="display-inline"><cv:msg key="header.archiving.viewfileDetails" bundle="archiving"/>
</h3>
<i class="glyphicon ng-scope glyphicon-chevron-right" data-ng-class="{'glyphicon-chevron-right': !archCtrl.showFileDetails, 'glyphicon-chevron-down': archCtrl.showFileDetails}"></i>
</a>
</span>
<uib-tabset data-ng-if="archCtrl.showFileDetails" class="margin-top-15">
<uib-tab heading='<cv:msg key="label.toBeArchived" bundle="archiving" />' select="archCtrl.detailsTabChanged(0)">
<div data-ng-if="archCtrl.detailsTabSelected == 0">
<div id="remainOnDiskDetails" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, 'Archiving To Be Archived Details')">
<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
</div>
</div>
</div>
</uib-tab>
<uib-tab heading='<cv:msg key="label.remainOnDisk" bundle="archiving" />' select="archCtrl.detailsTabChanged(1)">
<div data-ng-if="archCtrl.detailsTabSelected == 1">
<div id="toBeArchivedDetails" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, 'Archiving Remain On Disk Details')">
<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
</div>
</div>
</div>
</uib-tab>
<uib-tab heading='<cv:msg key="label.archived" bundle="archiving" />' select="archCtrl.detailsTabChanged(2)">
<div data-ng-if="archCtrl.detailsTabSelected == 2">
<div id="archivedDetails" data-ng-app="reports" data-ng-controller="reportsCtrl" data-ng-init="init(null, 'Archiving Archived Details')">
<div id="pageDiv" data-ng-controller="pageController" class="maskLayer" data-ng-class="{'isMasked':masked}" >
<div data-ng-include="'${pageContext.request.contextPath}/reportsplus/templates/reportComponents/viewerPage.jsp'"></div>
</div>
</div>
</div>
</uib-tab>
</uib-tabset>
</div>
</div>
</div>
</div>
</form>
